/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\"B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "project", "Lcom/intellij/openapi/project/Project;", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "autoImportAware", "Lcom/intellij/openapi/externalSystem/ExternalSystemAutoImportAware;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;Lcom/intellij/openapi/externalSystem/ExternalSystemAutoImportAware;)V", "getProjectId", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "externalProjectPath", "", "settingsFiles", "", "getSettingsFiles", "()Ljava/util/Set;", "externalProjectFiles", "", "Ljava/io/File;", "getExternalProjectFiles", "()Ljava/util/List;", "subscribe", "", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "reloadProject", "context", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "TaskNotificationListener", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProjectAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectAware.kt\ncom/intellij/openapi/externalSystem/service/project/autoimport/ProjectAware\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1563#2:109\n1634#2,3:110\n*S KotlinDebug\n*F\n+ 1 ProjectAware.kt\ncom/intellij/openapi/externalSystem/service/project/autoimport/ProjectAware\n*L\n37#1:109\n37#1:110,3\n*E\n"})
public final class ProjectAware
implements ExternalSystemProjectAware {
    @NotNull
    private final Project project;
    @NotNull
    private final ExternalSystemProjectId projectId;
    @NotNull
    private final ExternalSystemAutoImportAware autoImportAware;
    @NotNull
    private final ProjectSystemId systemId;
    @NotNull
    private final String externalProjectPath;

    public ProjectAware(@NotNull Project project, @NotNull ExternalSystemProjectId projectId, @NotNull ExternalSystemAutoImportAware autoImportAware) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)autoImportAware, (String)"autoImportAware");
        this.project = project;
        this.projectId = projectId;
        this.autoImportAware = autoImportAware;
        this.systemId = this.getProjectId().getSystemId();
        this.externalProjectPath = this.getProjectId().getExternalProjectPath();
    }

    @NotNull
    public ExternalSystemProjectId getProjectId() {
        return this.projectId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getSettingsFiles() {
        void $this$mapTo$iv$iv;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.project));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        PathMacroManager pathMacroManager2 = pathMacroManager;
        Iterable $this$map$iv = this.getExternalProjectFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String path = FileUtil.toCanonicalPath((String)it.getPath());
            String collapsedPath = pathMacroManager2.collapsePath(path);
            String expandedPath = pathMacroManager2.expandPath(collapsedPath);
            collection.add(expandedPath);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final List<File> getExternalProjectFiles() {
        List list = this.autoImportAware.getAffectedExternalProjectFiles(this.externalProjectPath, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAffectedExternalProjectFiles(...)");
        return list;
    }

    public void subscribe(@NotNull ExternalSystemProjectListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        progressManager.addNotificationListener(new TaskNotificationListener(listener2), parentDisposable);
        ExternalProjectsManager projectsManager = ExternalProjectsManager.getInstance((Project)this.project);
        projectsManager.runWhenInitialized(() -> ProjectAware.subscribe$lambda$0(listener2));
    }

    public void reloadProject(@NotNull ExternalSystemProjectReloadContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ImportSpecBuilder importSpec = new ImportSpecBuilder(this.project, this.systemId);
        if (!context.isExplicitReload()) {
            importSpec.dontReportRefreshErrors();
            importSpec.dontNavigateToError();
        }
        if (!TrustedProjects.isProjectTrusted((Project)this.project)) {
            importSpec.usePreviewMode();
        }
        ExternalSystemUtil.refreshProject(this.externalProjectPath, importSpec);
    }

    private static final void subscribe$lambda$0(ExternalSystemProjectListener $listener) {
        $listener.onSettingsFilesListChange();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J$\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectAware$TaskNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "delegate", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "<init>", "(Lcom/intellij/openapi/externalSystem/service/project/autoimport/ProjectAware;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;)V", "getDelegate", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "externalSystemTaskId", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "getExternalSystemTaskId", "()Ljava/util/concurrent/atomic/AtomicReference;", "setExternalSystemTaskId", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "onStart", "", "projectPath", "", "id", "afterProjectRefresh", "status", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemRefreshStatus;", "onSuccess", "onFailure", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onCancel", "intellij.platform.externalSystem.impl"})
    private final class TaskNotificationListener
    implements ExternalSystemTaskNotificationListener {
        @NotNull
        private final ExternalSystemProjectListener delegate;
        @NotNull
        private AtomicReference<ExternalSystemTaskId> externalSystemTaskId;

        public TaskNotificationListener(ExternalSystemProjectListener delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.externalSystemTaskId = new AtomicReference<Object>(null);
        }

        @NotNull
        public final ExternalSystemProjectListener getDelegate() {
            return this.delegate;
        }

        @NotNull
        public final AtomicReference<ExternalSystemTaskId> getExternalSystemTaskId() {
            return this.externalSystemTaskId;
        }

        public final void setExternalSystemTaskId(@NotNull AtomicReference<ExternalSystemTaskId> atomicReference) {
            Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
            this.externalSystemTaskId = atomicReference;
        }

        public void onStart(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (id.getType() != ExternalSystemTaskType.RESOLVE_PROJECT) {
                return;
            }
            if (!FileUtil.pathsEqual((String)projectPath, (String)ProjectAware.this.externalProjectPath)) {
                return;
            }
            ExternalSystemProcessingManager processingManager = ExternalSystemProcessingManager.getInstance();
            ExternalSystemTask task = processingManager.findTask(id);
            if (task instanceof ExternalSystemResolveProjectTask && !ProjectAware.this.autoImportAware.isApplicable(((ExternalSystemResolveProjectTask)task).getResolverPolicy())) {
                return;
            }
            this.externalSystemTaskId.set(id);
            this.delegate.onProjectReloadStart();
        }

        private final void afterProjectRefresh(ExternalSystemTaskId id, ExternalSystemRefreshStatus status) {
            if (id.getType() != ExternalSystemTaskType.RESOLVE_PROJECT) {
                return;
            }
            if (!this.externalSystemTaskId.compareAndSet(id, null)) {
                return;
            }
            this.delegate.onProjectReloadFinish(status);
        }

        public void onSuccess(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.afterProjectRefresh(id, ExternalSystemRefreshStatus.SUCCESS);
        }

        public void onFailure(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            this.afterProjectRefresh(id, ExternalSystemRefreshStatus.FAILURE);
        }

        public void onCancel(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.afterProjectRefresh(id, ExternalSystemRefreshStatus.CANCEL);
        }
    }
}

