/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalLibraryPathTypeMapper;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.LibraryDataServiceExtension;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectStructureUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483628)
@ApiStatus.Internal
public final class LibraryDataService
extends AbstractProjectDataService<LibraryData, Library> {
    private static final Logger LOG = Logger.getInstance(LibraryDataService.class);
    public static final ExtensionPointName<LibraryDataServiceExtension> EP_NAME = ExtensionPointName.create((String)"com.intellij.libraryDataServiceExtension");

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        if (key == null) {
            LibraryDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<? extends DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            LibraryDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(3);
        }
        HashMap<String, LibraryData> processedLibraries = new HashMap<String, LibraryData>();
        for (DataNode<LibraryData> dataNode : toImport) {
            LibraryData libraryData = (LibraryData)dataNode.getData();
            String libraryName = libraryData.getInternalName();
            LibraryData importedLibrary = processedLibraries.putIfAbsent(libraryName, libraryData);
            if (importedLibrary == null) {
                LibraryDataService.importLibrary(modelsProvider, libraryData);
                continue;
            }
            LOG.warn("Multiple project level libraries found with the same name '" + libraryName + "'");
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Chosen library:" + String.valueOf(importedLibrary.getPaths(LibraryPathType.BINARY)));
            LOG.debug("Ignored library:" + String.valueOf(libraryData.getPaths(LibraryPathType.BINARY)));
        }
    }

    private static void importLibrary(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryData libraryData) {
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(4);
        }
        if (libraryData == null) {
            LibraryDataService.$$$reportNull$$$0(5);
        }
        String libraryName = libraryData.getInternalName();
        PersistentLibraryKind<?> libraryKind = LibraryDataService.getLibraryKind(libraryData);
        ProjectModelExternalSource librarySource = ExternalSystemApiUtil.toExternalSource((ProjectSystemId)libraryData.getOwner());
        Library existingLibrary = modelsProvider.getLibraryByName(libraryName);
        Library library = (Library)ObjectUtils.notNull((Object)existingLibrary, () -> {
            LibraryTable.ModifiableModel librariesModel = modelsProvider.getModifiableProjectLibrariesModel();
            return librariesModel.createLibrary(libraryName, libraryKind, librarySource);
        });
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        if (existingLibrary != null) {
            if (library.getExternalSource() == null) {
                ((LibraryEx.ModifiableModelEx)libraryModel).setExternalSource(librarySource);
            }
            LibraryDataService.syncPaths(libraryModel, libraryData);
        } else {
            LibraryDataService.registerPaths(libraryModel, libraryData);
        }
        EP_NAME.forEachExtensionSafe(extension -> extension.prepareLibrary(modelsProvider, library, libraryData));
    }

    private static PersistentLibraryKind<?> getLibraryKind(LibraryData anImport) {
        for (LibraryDataServiceExtension extension : EP_NAME.getExtensionList()) {
            PersistentLibraryKind<?> kind = extension.getLibraryKind(anImport);
            if (kind == null) continue;
            return kind;
        }
        return null;
    }

    @NotNull
    static Map<OrderRootType, Collection<File>> prepareLibraryFiles(@NotNull LibraryData data) {
        if (data == null) {
            LibraryDataService.$$$reportNull$$$0(6);
        }
        HashMap<OrderRootType, Collection<File>> result = new HashMap<OrderRootType, Collection<File>>();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            Set paths;
            OrderRootType orderRootType = ExternalLibraryPathTypeMapper.getInstance().map(pathType);
            if (orderRootType == null || (paths = data.getPaths(pathType)).isEmpty()) continue;
            List files = ContainerUtil.map((Collection)paths, File::new);
            result.put(orderRootType, files);
        }
        HashMap<OrderRootType, Collection<File>> hashMap = result;
        if (hashMap == null) {
            LibraryDataService.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    static void registerPaths(boolean unresolved, @NotNull Map<OrderRootType, Collection<File>> libraryFiles, @NotNull Set<String> excludedPaths, @NotNull Library.ModifiableModel model, @NotNull String libraryName) {
        if (libraryFiles == null) {
            LibraryDataService.$$$reportNull$$$0(8);
        }
        if (excludedPaths == null) {
            LibraryDataService.$$$reportNull$$$0(9);
        }
        if (model == null) {
            LibraryDataService.$$$reportNull$$$0(10);
        }
        if (libraryName == null) {
            LibraryDataService.$$$reportNull$$$0(11);
        }
        for (Map.Entry<OrderRootType, Collection<File>> entry : libraryFiles.entrySet()) {
            for (File file : entry.getValue()) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = virtualFile = unresolved ? null : VirtualFileManager.getInstance().findFileByNioPath(file.toPath().toAbsolutePath());
                if (virtualFile == null) {
                    String[] urls;
                    String url;
                    if (!unresolved && ExternalSystemConstants.VERBOSE_PROCESSING && entry.getKey() == OrderRootType.CLASSES) {
                        LOG.warn(String.format("Can't find %s of the library '%s' at path '%s'", entry.getKey(), libraryName, file.getAbsolutePath()));
                    }
                    if (ArrayUtil.contains((String)(url = VfsUtil.getUrlForLibraryRoot((File)file)), (String[])(urls = model.getUrls(entry.getKey())))) continue;
                    model.addRoot(url, entry.getKey());
                    continue;
                }
                if (virtualFile.isDirectory()) {
                    Object[] files = model.getFiles(entry.getKey());
                    if (ArrayUtil.contains((Object)virtualFile, (Object[])files)) continue;
                    model.addRoot(virtualFile, entry.getKey());
                    continue;
                }
                VirtualFile root = virtualFile;
                if (virtualFile.getFileType() instanceof ArchiveFileType && (root = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile)) == null) {
                    LOG.warn(String.format("Can't parse contents of the JAR file at path '%s' for the library '%s''", file.getAbsolutePath(), libraryName));
                    continue;
                }
                Object[] files = model.getFiles(entry.getKey());
                if (ArrayUtil.contains((Object)root, (Object[])files)) continue;
                model.addRoot(root, entry.getKey());
            }
        }
        if (model instanceof LibraryEx.ModifiableModelEx) {
            LibraryEx.ModifiableModelEx modelEx = (LibraryEx.ModifiableModelEx)model;
            for (String excludedPath : excludedPaths) {
                String[] urls;
                String url = VfsUtil.getUrlForLibraryRoot((File)new File(excludedPath));
                if (ArrayUtil.contains((String)url, (String[])(urls = modelEx.getExcludedRootUrls()))) continue;
                modelEx.addExcludedRoot(url);
            }
        }
    }

    public void postProcess(@NotNull Collection<? extends DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(12);
        }
        if (project == null) {
            LibraryDataService.$$$reportNull$$$0(13);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(14);
        }
        if (projectData == null) {
            return;
        }
        if (modelsProvider instanceof ProjectStructureUIModifiableModelsProvider) {
            return;
        }
        SmartList orphanIdeLibraries = new SmartList();
        LibraryTable.ModifiableModel librariesModel = modelsProvider.getModifiableProjectLibrariesModel();
        final HashMap<String, Library> namesToLibs = new HashMap<String, Library>();
        final HashSet<Library> potentialOrphans = new HashSet<Library>();
        RootPolicy<Void> excludeUsedLibraries = new RootPolicy<Void>(this){

            public Void visitLibraryOrderEntry(@NotNull LibraryOrderEntry ideDependency, Void value) {
                if (ideDependency == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ideDependency.isModuleLevel()) {
                    return null;
                }
                Library lib = ideDependency.getLibrary();
                if (lib == null) {
                    lib = (Library)namesToLibs.get(ideDependency.getLibraryName());
                }
                if (lib != null) {
                    potentialOrphans.remove(lib);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideDependency", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService$1", "visitLibraryOrderEntry"));
            }
        };
        for (Library library : librariesModel.getLibraries()) {
            if (!ExternalSystemApiUtil.isExternalSystemLibrary((Library)library, (ProjectSystemId)projectData.getOwner())) continue;
            namesToLibs.put(library.getName(), library);
            potentialOrphans.add(library);
        }
        for (Library library : modelsProvider.getModules()) {
            for (OrderEntry entry : modelsProvider.getOrderEntries((Module)library)) {
                entry.accept((RootPolicy)excludeUsedLibraries, null);
            }
        }
        for (Library lib : potentialOrphans) {
            if (modelsProvider.isLibrarySubstituted(lib)) continue;
            orphanIdeLibraries.add(lib);
        }
        for (Library library : orphanIdeLibraries) {
            Library library2;
            String libraryName = library.getName();
            if (libraryName == null || (library2 = librariesModel.getLibraryByName(libraryName)) == null) continue;
            librariesModel.removeLibrary(library2);
        }
    }

    private static void registerPaths(@NotNull Library.ModifiableModel libraryModel, @NotNull LibraryData libraryData) {
        if (libraryModel == null) {
            LibraryDataService.$$$reportNull$$$0(15);
        }
        if (libraryData == null) {
            LibraryDataService.$$$reportNull$$$0(16);
        }
        Map<OrderRootType, Collection<File>> libraryFiles = LibraryDataService.prepareLibraryFiles(libraryData);
        Set excludedPaths = libraryData.getPaths(LibraryPathType.EXCLUDED);
        LibraryDataService.registerPaths(libraryData.isUnresolved(), libraryFiles, excludedPaths, libraryModel, libraryData.getInternalName());
    }

    private static void syncPaths(@NotNull Library.ModifiableModel libraryModel, @NotNull LibraryData libraryData) {
        if (libraryModel == null) {
            LibraryDataService.$$$reportNull$$$0(17);
        }
        if (libraryData == null) {
            LibraryDataService.$$$reportNull$$$0(18);
        }
        if (libraryData.isUnresolved()) {
            return;
        }
        HashMap toRemove = new HashMap();
        HashMap toAdd = new HashMap();
        ExternalLibraryPathTypeMapper externalLibraryPathTypeMapper = ExternalLibraryPathTypeMapper.getInstance();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            OrderRootType ideType = externalLibraryPathTypeMapper.map(pathType);
            if (ideType == null) continue;
            HashSet toAddPerType = new HashSet(libraryData.getPaths(pathType));
            toAdd.put(ideType, toAddPerType);
            if (pathType != LibraryPathType.BINARY && toAddPerType.isEmpty()) continue;
            HashSet<String> toRemovePerType = new HashSet<String>();
            toRemove.put(ideType, toRemovePerType);
            for (String url : libraryModel.getUrls(ideType)) {
                String idePath = LibraryDataService.getLocalPath(url);
                if (toAddPerType.remove(idePath)) continue;
                toRemovePerType.add(url);
            }
        }
        if (toRemove.isEmpty() && toAdd.isEmpty()) {
            return;
        }
        for (Map.Entry entry : toRemove.entrySet()) {
            for (String path : (Set)entry.getValue()) {
                libraryModel.removeRoot(path, (OrderRootType)entry.getKey());
            }
        }
        Set excludedPaths = libraryData.getPaths(LibraryPathType.EXCLUDED);
        for (Map.Entry entry : toAdd.entrySet()) {
            HashMap<OrderRootType, Collection<File>> roots = new HashMap<OrderRootType, Collection<File>>();
            roots.put((OrderRootType)entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), File::new));
            LibraryDataService.registerPaths(false, roots, excludedPaths, libraryModel, libraryData.getInternalName());
        }
    }

    @NotNull
    private static String getLocalPath(@NotNull String url) {
        if (url == null) {
            LibraryDataService.$$$reportNull$$$0(19);
        }
        if (url.startsWith("jar://")) {
            url = StringUtil.trimEnd((String)url, (String)"!/");
        }
        String string = VfsUtilCore.urlToPath((String)url);
        if (string == null) {
            LibraryDataService.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPaths";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryModel";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLibraryFiles";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareLibraryFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerPaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }
}

