/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.service.project.manage.LibraryDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483618)
@ApiStatus.Internal
public final class LibraryDependencyDataService
extends AbstractDependencyDataService<LibraryDependencyData, LibraryOrderEntry> {
    private static final Logger LOG = Logger.getInstance(LibraryDependencyDataService.class);

    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY_DEPENDENCY;
        if (key == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Override
    @NotNull
    public Class<LibraryOrderEntry> getOrderEntryType() {
        return LibraryOrderEntry.class;
    }

    @Override
    protected Map<OrderEntry, OrderAware> importData(@NotNull Collection<? extends DataNode<LibraryDependencyData>> nodesToImport, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (nodesToImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(1);
        }
        if (module == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(3);
        }
        DataToImport toImport = LibraryDependencyDataService.preProcessData(nodesToImport);
        LinkedHashMap<OrderEntry, OrderAware> orderEntryDataMap = new LinkedHashMap<OrderEntry, OrderAware>();
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        for (OrderEntry entry : modifiableRootModel.getOrderEntries()) {
            LibraryOrderEntry libraryOrderEntry;
            LibraryDependencyData processingResult = null;
            if (OrderEntryUtil.isModuleLibraryOrderEntry((OrderEntry)entry)) {
                processingResult = LibraryDependencyDataService.importModuleLibraryOrderEntry((LibraryOrderEntry)entry, toImport.moduleLibraries, modifiableRootModel, modelsProvider);
            } else if (entry instanceof LibraryOrderEntry && (processingResult = LibraryDependencyDataService.importLibraryOrderEntry(libraryOrderEntry = (LibraryOrderEntry)entry, toImport.projectLibraries, modifiableRootModel, toImport.hasUnresolvedLibraries)) != null) {
                libraryOrderEntry.setExported(processingResult.isExported());
                libraryOrderEntry.setScope(processingResult.getScope());
            }
            if (processingResult == null) continue;
            orderEntryDataMap.put(entry, (OrderAware)processingResult);
        }
        for (LibraryDependencyData dependencyData : toImport.projectLibraries.values()) {
            OrderEntry entry = LibraryDependencyDataService.importMissingLibraryOrderEntry(dependencyData, modifiableRootModel, modelsProvider, module);
            orderEntryDataMap.put(entry, (OrderAware)dependencyData);
        }
        for (LibraryDependencyData dependencyData : toImport.moduleLibraries.values()) {
            OrderEntry entry = LibraryDependencyDataService.importMissingModuleLibraryOrderEntry(dependencyData, modifiableRootModel, modelsProvider, module);
            orderEntryDataMap.put(entry, (OrderAware)dependencyData);
        }
        return orderEntryDataMap;
    }

    @Nullable
    private static LibraryDependencyData importModuleLibraryOrderEntry(@NotNull LibraryOrderEntry entry, @NotNull Map<Set<String>, LibraryDependencyData> moduleLibrariesToImport, @NotNull ModifiableRootModel modifiableRootModel, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (entry == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(4);
        }
        if (moduleLibrariesToImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(5);
        }
        if (modifiableRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(6);
        }
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(7);
        }
        Library library = entry.getLibrary();
        VirtualFile[] libraryFiles = library.getFiles(OrderRootType.CLASSES);
        HashSet<CallSite> moduleLibraryKey = new HashSet<CallSite>(libraryFiles.length);
        for (VirtualFile file : libraryFiles) {
            moduleLibraryKey.add((CallSite)((Object)(ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file) + entry.getScope().name())));
        }
        LibraryDependencyData existing = moduleLibrariesToImport.remove(moduleLibraryKey);
        if (existing != null && StringUtil.equals((CharSequence)StringUtil.nullize((String)existing.getInternalName()), (CharSequence)library.getName())) {
            LibraryDependencyDataService.syncExistingLibraryDependency(modelsProvider, existing, library, modifiableRootModel, entry.getOwnerModule(), entry);
            return existing;
        }
        modifiableRootModel.removeOrderEntry((OrderEntry)entry);
        return null;
    }

    @Nullable
    private static LibraryDependencyData importLibraryOrderEntry(@NotNull LibraryOrderEntry entry, @NotNull Map<String, LibraryDependencyData> projectLibrariesToImport, @NotNull ModifiableRootModel modifiableRootModel, boolean hasUnresolvedLibraries) {
        String libraryName;
        LibraryDependencyData existing;
        if (entry == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(8);
        }
        if (projectLibrariesToImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(9);
        }
        if (modifiableRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(10);
        }
        if ((existing = projectLibrariesToImport.remove((libraryName = entry.getLibraryName()) + entry.getScope().name())) != null) {
            return existing;
        }
        if (!hasUnresolvedLibraries) {
            modifiableRootModel.removeOrderEntry((OrderEntry)entry);
        }
        return null;
    }

    @NotNull
    private static DataToImport preProcessData(@NotNull Collection<? extends DataNode<LibraryDependencyData>> nodesToImport) {
        if (nodesToImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(11);
        }
        LinkedHashMap<Set<String>, LibraryDependencyData> moduleLibrariesToImport = new LinkedHashMap<Set<String>, LibraryDependencyData>();
        LinkedHashMap<String, LibraryDependencyData> projectLibrariesToImport = new LinkedHashMap<String, LibraryDependencyData>();
        boolean hasUnresolved = false;
        for (DataNode<LibraryDependencyData> dataNode : nodesToImport) {
            LibraryDependencyData dependencyData = (LibraryDependencyData)dataNode.getData();
            LibraryData libraryData = (LibraryData)dependencyData.getTarget();
            hasUnresolved |= libraryData.isUnresolved();
            LibraryLevel dependencyDataLevel = dependencyData.getLevel();
            if (LibraryLevel.MODULE == dependencyDataLevel) {
                HashSet<CallSite> paths = new HashSet<CallSite>();
                for (String path : libraryData.getPaths(LibraryPathType.BINARY)) {
                    paths.add((CallSite)((Object)(ExternalSystemApiUtil.toCanonicalPath((String)path) + dependencyData.getScope().name())));
                }
                moduleLibrariesToImport.put(paths, dependencyData);
                continue;
            }
            if (LibraryLevel.PROJECT != dependencyDataLevel) continue;
            projectLibrariesToImport.put(libraryData.getInternalName() + dependencyData.getScope().name(), dependencyData);
        }
        return new DataToImport(moduleLibrariesToImport, projectLibrariesToImport, hasUnresolved);
    }

    @NotNull
    private static OrderEntry importMissingModuleLibraryOrderEntry(@NotNull LibraryDependencyData dependencyData, @NotNull ModifiableRootModel moduleRootModel, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Module module) {
        if (dependencyData == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(12);
        }
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(13);
        }
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(14);
        }
        if (module == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(15);
        }
        LibraryData libraryData = (LibraryData)dependencyData.getTarget();
        String libraryName = libraryData.getInternalName();
        LibraryTable moduleLibraryTable = moduleRootModel.getModuleLibraryTable();
        Library moduleLib = libraryName.isEmpty() ? moduleLibraryTable.createLibrary() : moduleLibraryTable.createLibrary(libraryName);
        return LibraryDependencyDataService.syncExistingLibraryDependency(modelsProvider, dependencyData, moduleLib, moduleRootModel, module, null);
    }

    @NotNull
    private static OrderEntry importMissingLibraryOrderEntry(@NotNull LibraryDependencyData dependencyData, @NotNull ModifiableRootModel moduleRootModel, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Module module) {
        LibraryData libraryData;
        String libraryName;
        Library projectLib;
        if (dependencyData == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(16);
        }
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(17);
        }
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(18);
        }
        if (module == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(19);
        }
        if ((projectLib = modelsProvider.getLibraryByName(libraryName = (libraryData = (LibraryData)dependencyData.getTarget()).getInternalName())) == null) {
            LibraryTable moduleLibraryTable = moduleRootModel.getModuleLibraryTable();
            return LibraryDependencyDataService.syncExistingLibraryDependency(modelsProvider, dependencyData, moduleLibraryTable.createLibrary(libraryName), moduleRootModel, module, null);
        }
        LibraryOrderEntry orderEntry = moduleRootModel.addLibraryEntry(projectLib);
        LibraryDependencyDataService.setLibraryScope(orderEntry, projectLib, module, dependencyData);
        LibraryOrderEntry libraryOrderEntry = orderEntry;
        if (libraryOrderEntry == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(20);
        }
        return libraryOrderEntry;
    }

    private static void setLibraryScope(@NotNull LibraryOrderEntry orderEntry, @NotNull Library lib, @NotNull Module module, @NotNull LibraryDependencyData dependencyData) {
        if (orderEntry == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(21);
        }
        if (lib == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(22);
        }
        if (module == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(23);
        }
        if (dependencyData == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(24);
        }
        orderEntry.setExported(dependencyData.isExported());
        orderEntry.setScope(dependencyData.getScope());
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Configuring library '%s' of module '%s' to be%s exported and have scope %s", lib, module.getName(), dependencyData.isExported() ? " not" : "", dependencyData.getScope()));
        }
    }

    @NotNull
    private static LibraryOrderEntry syncExistingLibraryDependency(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryDependencyData libraryDependencyData, @NotNull Library library, @NotNull ModifiableRootModel moduleRootModel, @NotNull Module module, @Nullable LibraryOrderEntry currentRegisteredLibraryOrderEntry) {
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(25);
        }
        if (libraryDependencyData == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(26);
        }
        if (library == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(27);
        }
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(28);
        }
        if (module == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(29);
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        String libraryName = libraryDependencyData.getInternalName();
        LibraryData libraryDependencyDataTarget = (LibraryData)libraryDependencyData.getTarget();
        Map<OrderRootType, Collection<File>> files = LibraryDataService.prepareLibraryFiles(libraryDependencyDataTarget);
        Set excludedPaths = libraryDependencyDataTarget.getPaths(LibraryPathType.EXCLUDED);
        LibraryDataService.registerPaths(libraryDependencyDataTarget.isUnresolved(), files, excludedPaths, libraryModel, libraryName);
        LibraryOrderEntry orderEntry = currentRegisteredLibraryOrderEntry;
        if (orderEntry == null) {
            orderEntry = LibraryDependencyDataService.findLibraryOrderEntry(moduleRootModel, library, libraryDependencyData.getScope());
        }
        assert (orderEntry != null);
        LibraryDependencyDataService.setLibraryScope(orderEntry, library, module, libraryDependencyData);
        LibraryOrderEntry libraryOrderEntry = orderEntry;
        if (libraryOrderEntry == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(30);
        }
        return libraryOrderEntry;
    }

    @Nullable
    private static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModifiableRootModel moduleRootModel, @NotNull Library library, @NotNull DependencyScope scope) {
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(31);
        }
        if (library == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(33);
        }
        LibraryOrderEntry candidate = null;
        for (OrderEntry orderEntry : moduleRootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
            Library orderEntryLibrary = libraryOrderEntry.getLibrary();
            if (library == orderEntryLibrary) {
                return libraryOrderEntry;
            }
            if (!library.equals((Object)orderEntryLibrary) || candidate != null && libraryOrderEntry.getScope() != scope) continue;
            candidate = libraryOrderEntry;
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToImport";
                break;
            }
            case 2: 
            case 15: 
            case 19: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 7: 
            case 14: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLibrariesToImport";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLibrariesToImport";
                break;
            }
            case 12: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyData";
                break;
            }
            case 13: 
            case 17: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRootModel";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDependencyData";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "importMissingLibraryOrderEntry";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "syncExistingLibraryDependency";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importModuleLibraryOrderEntry";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importLibraryOrderEntry";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "preProcessData";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "importMissingModuleLibraryOrderEntry";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "importMissingLibraryOrderEntry";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setLibraryScope";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "syncExistingLibraryDependency";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryOrderEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33 -> new IllegalArgumentException(string);
        };
    }

    private static class DataToImport {
        @NotNull
        private final LinkedHashMap<Set<String>, LibraryDependencyData> moduleLibraries;
        @NotNull
        private final LinkedHashMap<String, LibraryDependencyData> projectLibraries;
        private final boolean hasUnresolvedLibraries;

        private DataToImport(@NotNull LinkedHashMap<Set<String>, LibraryDependencyData> moduleLibraries, @NotNull LinkedHashMap<String, LibraryDependencyData> projectLibraries, boolean hasUnresolvedLibraries) {
            if (moduleLibraries == null) {
                DataToImport.$$$reportNull$$$0(0);
            }
            if (projectLibraries == null) {
                DataToImport.$$$reportNull$$$0(1);
            }
            this.moduleLibraries = moduleLibraries;
            this.projectLibraries = projectLibraries;
            this.hasUnresolvedLibraries = hasUnresolvedLibraries;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleLibraries";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "projectLibraries";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$DataToImport";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

