/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectSdkData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J6\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/ProjectSdkDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectSdkData;", "Lcom/intellij/openapi/project/Project;", "<init>", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "importProjectSdk", "sdkData", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nSdkDataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkDataService.kt\ncom/intellij/openapi/externalSystem/service/project/manage/ProjectSdkDataService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class ProjectSdkDataService
extends AbstractProjectDataService<ProjectSdkData, Project> {
    @NotNull
    public Key<ProjectSdkData> getTargetDataKey() {
        return ProjectSdkData.KEY;
    }

    public void importData(@NotNull Collection<? extends DataNode<ProjectSdkData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (toImport.isEmpty() || projectData == null) {
            return;
        }
        if (!(toImport.size() == 1)) {
            boolean bl = false;
            String string = "Expected to get a single project but got %d: %s";
            Object[] objectArray = new Object[]{toImport.size(), toImport};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String string3 = string2;
            throw new IllegalArgumentException(string3.toString());
        }
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)projectData, (Module[])modelsProvider.getModules())) {
            return;
        }
        for (DataNode<ProjectSdkData> dataNode : toImport) {
            ExternalSystemApiUtil.executeProjectChangeAction((ComponentManager)((ComponentManager)project), () -> ProjectSdkDataService.importData$lambda$1(this, project, dataNode));
        }
    }

    private final void importProjectSdk(Project project, ProjectSdkData sdkData) {
        String string = sdkData.getSdkName();
        if (string == null) {
            return;
        }
        String sdkName = string;
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        Sdk sdk = projectJdkTable.findJdk(sdkName);
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Sdk projectSdk = projectRootManager.getProjectSdk();
        if (projectSdk == null) {
            projectRootManager.setProjectSdk(sdk);
        }
    }

    private static final void importData$lambda$1(ProjectSdkDataService this$0, Project $project, DataNode $sdkDataNode) {
        Object object = $sdkDataNode.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        this$0.importProjectSdk($project, (ProjectSdkData)object);
    }
}

