/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.nameGenerator;

import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleNameDeduplicationStrategy;
import com.intellij.openapi.externalSystem.service.project.nameGenerator.NumericNameGenerator;
import com.intellij.openapi.externalSystem.service.project.nameGenerator.PathNameGenerator;
import com.intellij.openapi.externalSystem.service.project.nameGenerator.SimpleNameGenerator;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007J:\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/nameGenerator/ModuleNameGenerator;", "", "<init>", "()V", "generate", "", "", "moduleData", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "delimiter", "group", "name", "path", "Ljava/nio/file/Path;", "deduplicationStrategy", "Lcom/intellij/openapi/externalSystem/model/project/ModuleNameDeduplicationStrategy;", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class ModuleNameGenerator {
    @NotNull
    public static final ModuleNameGenerator INSTANCE = new ModuleNameGenerator();

    private ModuleNameGenerator() {
    }

    @JvmStatic
    @NotNull
    public static final Iterable<String> generate(@NotNull ModuleData moduleData, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        File modulePath = new File(moduleData.getLinkedExternalProjectPath());
        if (modulePath.isFile()) {
            File file = modulePath.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
            modulePath = file;
        }
        String string = moduleData.getGroup();
        String string2 = moduleData.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
        Path path = modulePath.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        ModuleNameDeduplicationStrategy moduleNameDeduplicationStrategy = moduleData.getModuleNameDeduplicationStrategy();
        Intrinsics.checkNotNullExpressionValue((Object)moduleNameDeduplicationStrategy, (String)"getModuleNameDeduplicationStrategy(...)");
        return ModuleNameGenerator.generate(string, string2, path, delimiter, moduleNameDeduplicationStrategy);
    }

    @JvmStatic
    @NotNull
    public static final Iterable<String> generate(@Nullable String group, @NotNull String name, @NotNull Path path, @NotNull String delimiter, @NotNull ModuleNameDeduplicationStrategy deduplicationStrategy) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        Intrinsics.checkNotNullParameter((Object)deduplicationStrategy, (String)"deduplicationStrategy");
        Iterable strategySuggestions = switch (WhenMappings.$EnumSwitchMapping$0[deduplicationStrategy.ordinal()]) {
            case 1 -> PathNameGenerator.Companion.generate(name, path, delimiter);
            case 2 -> NumericNameGenerator.Companion.generate(name);
            case 3 -> CollectionsKt.plus(PathNameGenerator.Companion.generate(name, path, delimiter), NumericNameGenerator.Companion.generate(name));
            default -> throw new NoWhenBranchMatchedException();
        };
        return CollectionsKt.plus(SimpleNameGenerator.Companion.generate(group, name, delimiter), (Iterable)strategySuggestions);
    }

    public static /* synthetic */ Iterable generate$default(String string, String string2, Path path, String string3, ModuleNameDeduplicationStrategy moduleNameDeduplicationStrategy, int n, Object object) {
        if ((n & 0x10) != 0) {
            moduleNameDeduplicationStrategy = ModuleNameDeduplicationStrategy.DEFAULT;
        }
        return ModuleNameGenerator.generate(string, string2, path, string3, moduleNameDeduplicationStrategy);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModuleNameDeduplicationStrategy.values().length];
            try {
                nArray[ModuleNameDeduplicationStrategy.PARENT_PATH_NAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleNameDeduplicationStrategy.NUMBER_SUFFIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleNameDeduplicationStrategy.DEFAULT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

