/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationDataService;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483618)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 !2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J6\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J6\u0010\u0013\u001a\u00020\t2\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u00a3\u0001\u0010\u0016\u001a\u00020\t\"\b\b\u0000\u0010\u0017*\u00020\u00152\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u0002H\u001721\u0010\u0019\u001a-\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\u001a\u00a2\u0006\u0002\b\u001c2)\u0010\u001d\u001a%\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\u001e\u00a2\u0006\u0002\b\u001cH\u0002\u00a2\u0006\u0002\u0010 \u00a8\u0006\""}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "Ljava/lang/Void;", "<init>", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "onSuccessImport", "imported", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "withConfigurationData", "ModelsProvider", "configurationData", "acceptProject", "Lkotlin/Function5;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "Lkotlin/ExtensionFunctionType;", "acceptModule", "Lkotlin/Function4;", "Lcom/intellij/openapi/module/Module;", "(Ljava/util/Collection;Lcom/intellij/openapi/externalSystem/model/project/ProjectData;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;Lkotlin/jvm/functions/Function5;Lkotlin/jvm/functions/Function4;)V", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public final class ConfigurationDataService
extends AbstractProjectDataService<ConfigurationData, Void> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED = "external.system.configuration.import.enabled";

    @NotNull
    public Key<ConfigurationData> getTargetDataKey() {
        Key key = ProjectKeys.CONFIGURATION;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONFIGURATION");
        return key;
    }

    public void importData(@NotNull Collection<? extends DataNode<ConfigurationData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        this.withConfigurationData(toImport, projectData, project, (IdeModelsProvider)modelsProvider, importData.1.INSTANCE, importData.2.INSTANCE);
    }

    public void onSuccessImport(@NotNull Collection<? extends DataNode<ConfigurationData>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(imported, (String)"imported");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        this.withConfigurationData(imported, projectData, project, modelsProvider, onSuccessImport.1.INSTANCE, onSuccessImport.2.INSTANCE);
    }

    private final <ModelsProvider extends IdeModelsProvider> void withConfigurationData(Collection<? extends DataNode<ConfigurationData>> configurationData, ProjectData projectData, Project project, ModelsProvider modelsProvider, Function5<? super ConfigurationHandler, ? super Project, ? super ProjectData, ? super ModelsProvider, ? super ConfigurationData, Unit> acceptProject, Function4<? super ConfigurationHandler, ? super Module, ? super ModelsProvider, ? super ConfigurationData, Unit> acceptModule) {
        if (configurationData.isEmpty() || !Registry.Companion.is(EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED)) {
            LOG.debug("Configuration data is" + (!configurationData.isEmpty() ? " not " : " ") + "empty, Registry flag is " + Registry.Companion.is(EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED));
            return;
        }
        DataNode<ConfigurationData> javaProjectDataNode = configurationData.iterator().next();
        DataNode dataNode = ExternalSystemApiUtil.findParent(javaProjectDataNode, (Key)ProjectKeys.PROJECT);
        Intrinsics.checkNotNull((Object)dataNode);
        DataNode projectDataNode = dataNode;
        DataNode projectConfigurationNode = ExternalSystemApiUtil.find((DataNode)projectDataNode, (Key)ProjectKeys.CONFIGURATION);
        if (projectConfigurationNode != null) {
            Object object = projectConfigurationNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
            ConfigurationData data = (ConfigurationData)object;
            if (LOG.isDebugEnabled() && data instanceof ConfigurationDataImpl) {
                LOG.debug("Importing project configuration: " + ((ConfigurationDataImpl)data).getJsonString());
            }
            if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)((ProjectData)projectDataNode.getData()), (Module[])ModuleManager.Companion.getInstance(project).getModules())) {
                LOG.warn("This external project are not the only project in the current IDE workspace, found project level configuration can override the configuration came from other external projects.");
            }
            for (ConfigurationHandler handler : (ConfigurationHandler[])ConfigurationHandler.EP_NAME.getExtensions()) {
                Intrinsics.checkNotNull((Object)handler);
                acceptProject.invoke((Object)handler, (Object)project, (Object)projectData, modelsProvider, (Object)data);
            }
        }
        for (DataNode<ConfigurationData> dataNode2 : configurationData) {
            DataNode moduleDataNode;
            if (dataNode2 == projectConfigurationNode || (moduleDataNode = ExternalSystemApiUtil.findParent(dataNode2, (Key)ProjectKeys.MODULE)) == null) continue;
            Module module = (Module)moduleDataNode.getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module2 = module;
            if (module2 == null) {
                module2 = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            }
            if ((module = module2) == null) {
                ConfigurationHandler[] configurationHandlerArray = "Can't import module level configuration. Reason: target module (%s) is not found at the ide";
                Object[] objectArray = new Object[]{moduleDataNode};
                String string = String.format((String)configurationHandlerArray, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                LOG.warn(string);
                continue;
            }
            Object object = dataNode2.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
            ConfigurationData data = (ConfigurationData)object;
            if (LOG.isDebugEnabled() && data instanceof ConfigurationDataImpl) {
                LOG.debug("Importing module configuration: " + ((ConfigurationDataImpl)data).getJsonString());
            }
            for (ConfigurationHandler handler : (ConfigurationHandler[])ConfigurationHandler.EP_NAME.getExtensions()) {
                Intrinsics.checkNotNull((Object)handler);
                acceptModule.invoke((Object)handler, (Object)module, modelsProvider, (Object)data);
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(ConfigurationDataService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationDataService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED", "", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

