/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/InspectionsProfileConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "<init>", "()V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "intellij.platform.externalSystem.impl"})
final class InspectionsProfileConfigurationHandler
implements ConfigurationHandler {
    public void apply(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (!(configuration.find("inspections") instanceof List)) {
            return;
        }
        String gradleProfileName = "Gradle Imported";
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.Companion.getInstance(project);
        InspectionProfileImpl importedProfile = new InspectionProfileImpl(gradleProfileName, (InspectionToolsSupplier)InspectionToolRegistrar.Companion.getInstance(), (BaseInspectionProfileManager)profileManager);
        importedProfile.copyFrom(profileManager.getProfile("Default"));
        importedProfile.initInspectionTools(project);
        InspectionProfileModifiableModel modifiableModel = new InspectionProfileModifiableModel(importedProfile);
        modifiableModel.setName(gradleProfileName);
        modifiableModel.commit();
        profileManager.addProfile(importedProfile);
        profileManager.setRootProfile(gradleProfileName);
    }
}

