/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.BeforeRunTaskImporter;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationHandlerKt;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u0005*\u0004\u0018\u00010\u0006H\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "<init>", "()V", "isTrue", "", "", "apply", "", "module", "Lcom/intellij/openapi/module/Module;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationHandler.kt\ncom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n808#2,11:85\n1068#2:96\n1#3:97\n*S KotlinDebug\n*F\n+ 1 RunConfigurationHandler.kt\ncom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationHandler\n*L\n27#1:85,11\n28#1:96\n*E\n"})
public final class RunConfigurationHandler
implements ConfigurationHandler {
    private final boolean isTrue(Object $this$isTrue) {
        return $this$isTrue != null && $this$isTrue instanceof Boolean && (Boolean)$this$isTrue != false;
    }

    public void apply(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        void $this$sortedByDescending$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Object runCfgMap = configuration.find("runConfigurations");
        if (!(runCfgMap instanceof List)) {
            return;
        }
        RunManagerEx runManagerEx = RunManagerEx.getInstanceEx((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)runManagerEx, (String)"getInstanceEx(...)");
        RunManagerEx runManager = runManagerEx;
        Iterable iterable = (Iterable)runCfgMap;
        boolean $i$f$filterIsInstance = false;
        void var9_9 = $this$filterIsInstance$iv;
        Collection<Object> destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Map)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        for (Map cfg : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(this){
            final /* synthetic */ RunConfigurationHandler this$0;
            {
                this.this$0 = runConfigurationHandler;
            }

            public final int compare(T a, T b) {
                Map it = (Map)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(RunConfigurationHandler.access$isTrue(this.this$0, it.get("defaults")));
                it = (Map)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(RunConfigurationHandler.access$isTrue(this.this$0, it.get("defaults"))));
            }
        })) {
            Unit unit;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings;
            String typeName;
            destination$iv$iv = cfg.get("name");
            String string = destination$iv$iv instanceof String ? (String)((Object)destination$iv$iv) : null;
            if (string == null) {
                string = "";
            }
            String name = string;
            destination$iv$iv = cfg.get("type");
            String string2 = typeName = destination$iv$iv instanceof String ? (String)((Object)destination$iv$iv) : null;
            if (typeName == null) {
                RunConfigurationHandlerKt.getLOG().warn("Missing type for run configuration: '" + name + "', skipping");
                continue;
            }
            RunConfigurationImporter importer = RunConfigurationHandlerKt.access$handlerForType(typeName);
            if (importer == null) {
                RunConfigurationHandlerKt.getLOG().warn("No importers for run configuration '" + name + "' with type '" + typeName + "', skipping");
                continue;
            }
            boolean isDefaults = this.isTrue(cfg.get("defaults"));
            if (isDefaults) {
                ConfigurationFactory configurationFactory = importer.getConfigurationFactory();
                Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"getConfigurationFactory(...)");
                runnerAndConfigurationSettings = runManager.getConfigurationTemplate(configurationFactory);
            } else {
                ConfigurationFactory configurationFactory = importer.getConfigurationFactory();
                Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"getConfigurationFactory(...)");
                runnerAndConfigurationSettings = runManager.createConfiguration(name, configurationFactory);
            }
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
            try {
                Unit unit2;
                Object object;
                RunConfiguration runConfiguration = runnerAndConfigurationSettings2.getConfiguration();
                Intrinsics.checkNotNull((Object)cfg, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                importer.process(project, runConfiguration, cfg, modelsProvider);
                if (!isDefaults) {
                    String string3;
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings3 = runnerAndConfigurationSettings2;
                    object = cfg.get("folderName");
                    String string4 = object instanceof String ? (String)object : null;
                    if (string4 != null) {
                        Object object2;
                        object = string4;
                        if (object.length() == 0) {
                            RunnerAndConfigurationSettings runnerAndConfigurationSettings4 = runnerAndConfigurationSettings3;
                            boolean bl = false;
                            object2 = null;
                            runnerAndConfigurationSettings3 = runnerAndConfigurationSettings4;
                        } else {
                            object2 = object;
                        }
                        string3 = (String)object2;
                    } else {
                        string3 = null;
                    }
                    runnerAndConfigurationSettings3.setFolderName(string3);
                    runManager.addConfiguration(runnerAndConfigurationSettings2);
                }
                if (((object = cfg.get("beforeRun")) instanceof List ? (List)object : null) != null) {
                    List it;
                    it = it;
                    boolean bl = false;
                    List tasksList = null;
                    List list = runnerAndConfigurationSettings2.getConfiguration().getBeforeRunTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBeforeRunTasks(...)");
                    tasksList = CollectionsKt.toMutableList((Collection)list);
                    for (Map beforeRunConfig : CollectionsKt.filterIsInstance((Iterable)it, Map.class)) {
                        BeforeRunTaskImporter importer2;
                        Object v = beforeRunConfig.get("type");
                        String string5 = v instanceof String ? (String)v : null;
                        if (string5 == null) continue;
                        String typeName2 = string5;
                        if (RunConfigurationHandlerKt.access$importerForType(typeName2) == null) continue;
                        boolean bl2 = false;
                        RunConfiguration runConfiguration2 = runnerAndConfigurationSettings2.getConfiguration();
                        Intrinsics.checkNotNull((Object)beforeRunConfig, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, *>");
                        List list2 = importer2.process(project, modelsProvider, runConfiguration2, tasksList, TypeIntrinsics.asMutableMap((Object)beforeRunConfig));
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"process(...)");
                        tasksList = list2;
                    }
                    runManager.setBeforeRunTasks(runnerAndConfigurationSettings2.getConfiguration(), tasksList);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                unit = unit2;
            }
            catch (Exception e) {
                RunConfigurationHandlerKt.getLOG().warn("Error occurred when importing run configuration " + name + ": " + e.getMessage(), (Throwable)e);
                unit = Unit.INSTANCE;
            }
        }
    }

    public static final /* synthetic */ boolean access$isTrue(RunConfigurationHandler $this, Object $receiver) {
        return $this.isTrue($receiver);
    }
}

