/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.trusted;

import com.intellij.ide.trustedProjects.TrustedProjectsLocator;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.PathPrefixTree;
import com.intellij.util.containers.prefixTree.set.MutablePrefixTreeSet;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/trusted/ExternalSystemTrustedProjectsLocator;", "Lcom/intellij/ide/trustedProjects/TrustedProjectsLocator;", "<init>", "()V", "getProjectRoots", "", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "projectRoot", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemTrustedProjectsLocator
implements TrustedProjectsLocator {
    @NotNull
    public List<Path> getProjectRoots(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MutablePrefixTreeSet projectRoots = PathPrefixTree.INSTANCE.createSet();
        ExternalSystemManager.EP_NAME.forEachExtensionSafe(arg_0 -> ExternalSystemTrustedProjectsLocator.getProjectRoots$lambda$1(arg_0 -> ExternalSystemTrustedProjectsLocator.getProjectRoots$lambda$0(project, projectRoots, arg_0), arg_0));
        return CollectionsKt.toList((Iterable)projectRoots.getRoots());
    }

    @NotNull
    public List<Path> getProjectRoots(@NotNull Path projectRoot, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        return this.getProjectRoots(project);
    }

    private static final Unit getProjectRoots$lambda$0(Project $project, MutablePrefixTreeSet $projectRoots, ExternalSystemManager manager) {
        AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)$project);
        for (ExternalProjectSettings projectSettings : settings.getLinkedProjectsSettings()) {
            Path path = Path.of(projectSettings.getExternalProjectPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            $projectRoots.add((Object)path);
        }
        return Unit.INSTANCE;
    }

    private static final void getProjectRoots$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

