/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBoxRendererKt;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public final class ExternalSystemJdkComboBox
extends ComboBoxWithWidePopup<JdkComboBoxItem> {
    private static final int MAX_PATH_LENGTH = 50;
    @Nullable
    private Project myProject;
    @Nullable
    private Sdk myProjectJdk;
    private boolean myHighlightInternalJdk = true;

    public ExternalSystemJdkComboBox() {
        this(null);
    }

    public ExternalSystemJdkComboBox(@Nullable Project project) {
        this.myProject = project;
        this.setRenderer(ExternalSystemJdkComboBoxRendererKt.externalSystemJdkComboBoxRenderer());
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    public void setProjectJdk(@Nullable Sdk projectJdk) {
        this.myProjectJdk = projectJdk;
    }

    public void setSetupButton(@NotNull JButton setUpButton, @NotNull ProjectSdksModel jdksModel, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String actionGroupTitle, @Nullable Condition<? super SdkTypeId> creationFilter) {
        if (setUpButton == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(0);
        }
        if (jdksModel == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(1);
        }
        this.setSetupButton(setUpButton, jdksModel, actionGroupTitle, creationFilter, null);
    }

    public void setSetupButton(@NotNull JButton setUpButton, final @NotNull ProjectSdksModel jdksModel, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String actionGroupTitle, @Nullable Condition<? super SdkTypeId> creationFilter, @Nullable WizardContext wizardContext) {
        if (setUpButton == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(2);
        }
        if (jdksModel == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(3);
        }
        Arrays.stream(setUpButton.getActionListeners()).forEach(setUpButton::removeActionListener);
        setUpButton.addActionListener(e -> {
            DefaultActionGroup group = new DefaultActionGroup();
            final Sdk selectedJdk = this.getSelectedJdk();
            final Consumer updateTree = jdk -> {
                String jdkName;
                Sdk existingJdk = (Sdk)ContainerUtil.find((Object[])ProjectJdkTable.getInstance().getAllJdks(), sdk -> StringUtil.equals((CharSequence)sdk.getHomePath(), (CharSequence)jdk.getHomePath()));
                if (existingJdk == null) {
                    SdkConfigurationUtil.addSdk((Sdk)jdk);
                    jdkName = jdk.getName();
                } else {
                    jdkName = existingJdk.getName();
                }
                this.refreshData(jdkName, wizardContext != null ? wizardContext.getProjectJdk() : null);
            };
            jdksModel.reset(this.getProject());
            jdksModel.createAddActions(this.myProject, group, (JComponent)((Object)this), selectedJdk, (java.util.function.Consumer)updateTree, (Predicate)creationFilter);
            if (group.getChildrenCount() == 0) {
                final SimpleJavaSdkType javaSdkType = SimpleJavaSdkType.getInstance();
                DumbAwareAction addAction = new DumbAwareAction(javaSdkType.getPresentableName(), null, javaSdkType.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        jdksModel.doAdd((JComponent)((Object)ExternalSystemJdkComboBox.this), selectedJdk, (SdkType)javaSdkType, updateTree);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/ui/ExternalSystemJdkComboBox$1", "actionPerformed"));
                    }
                };
                group.add((AnAction)addAction);
            }
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            if (group.getChildrenCount() > 1) {
                JBPopupFactory.getInstance().createActionGroupPopup(actionGroupTitle, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)setUpButton);
            } else if (group.getChildrenCount() == 1) {
                AnActionEvent event = AnActionEvent.createEvent((DataContext)dataContext, null, (String)"unknown", (ActionUiKind)ActionUiKind.TOOLBAR, null);
                group.getChildren(ActionManager.getInstance())[0].actionPerformed(event);
            }
        });
    }

    @Nullable
    public Sdk getSelectedJdk() {
        String jdkName = this.getSelectedValue();
        Sdk jdk = null;
        try {
            jdk = ExternalSystemJdkUtil.resolveJdkName(this.myProjectJdk, jdkName);
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            // empty catch block
        }
        return jdk;
    }

    @Deprecated
    public void setHighlightInternalJdk(boolean highlightInternalJdk) {
        this.myHighlightInternalJdk = highlightInternalJdk;
    }

    public void refreshData(@Nullable String selectedValue) {
        this.refreshData(selectedValue, null);
    }

    public void refreshData(@Nullable String selectedValue, @Nullable Sdk projectJdk) {
        this.myProjectJdk = projectJdk;
        Map<String, JdkComboBoxItem> jdkMap = this.collectComboBoxItem();
        if ("#JAVA_INTERNAL".equals(selectedValue)) {
            jdkMap.put(selectedValue, this.getInternalJdkItem());
        } else if (selectedValue != null && !jdkMap.containsKey(selectedValue)) {
            assert (!selectedValue.isEmpty());
            jdkMap.put(selectedValue, new JdkComboBoxItem(selectedValue, selectedValue, "", false));
        }
        this.removeAllItems();
        ComboBoxModel comboBoxModel = this.getModel();
        for (Map.Entry<String, JdkComboBoxItem> entry : jdkMap.entrySet()) {
            ((MutableComboBoxModel)comboBoxModel).addElement(entry.getValue());
        }
        this.select(selectedValue);
    }

    @ApiStatus.Experimental
    public void select(@Nullable String selectedValue) {
        ComboBoxModel model = this.getModel();
        for (int i2 = 0; i2 < model.getSize(); ++i2) {
            JdkComboBoxItem item = (JdkComboBoxItem)model.getElementAt(i2);
            if (!item.jdkName.equals(selectedValue)) continue;
            model.setSelectedItem(item);
            return;
        }
        if ("#JAVA_INTERNAL".equals(selectedValue)) {
            JdkComboBoxItem item = this.getInternalJdkItem();
            ((MutableComboBoxModel)model).addElement(item);
        }
        if (model.getSize() != 0) {
            model.setSelectedItem(model.getElementAt(0));
        }
    }

    private JdkComboBoxItem getInternalJdkItem() {
        ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
        Sdk internalJdk = jdkProvider.getInternalJdk();
        return new JdkComboBoxItem("#JAVA_INTERNAL", ExternalSystemBundle.message((String)"external.system.java.internal.jre", (Object[])new Object[0]), ExternalSystemJdkComboBox.buildComment(internalJdk), !this.myHighlightInternalJdk);
    }

    @Nullable
    public String getSelectedValue() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object item = model.getSelectedItem();
        return item != null ? ((JdkComboBoxItem)item).jdkName : null;
    }

    private Map<String, JdkComboBoxItem> collectComboBoxItem() {
        String javaHomePath;
        LinkedHashMap<String, JdkComboBoxItem> result = new LinkedHashMap<String, JdkComboBoxItem>();
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            SdkTypeId sdkType = sdk.getSdkType();
            if (!(sdkType instanceof JavaSdkType) || !(sdkType instanceof SdkType) || !((SdkType)sdkType).sdkHasValidPath(sdk)) continue;
            String name = sdk.getName();
            String comment = ExternalSystemJdkComboBox.buildComment(sdk);
            result.put(name, new JdkComboBoxItem(name, name, comment, true));
        }
        if (this.myProjectJdk == null && this.myProject != null && !this.myProject.isDisposed()) {
            this.myProjectJdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        if (this.myProjectJdk != null) {
            result.put("#USE_PROJECT_JDK", new JdkComboBoxItem("#USE_PROJECT_JDK", ExternalSystemBundle.message((String)"external.system.java.project.jdk", (Object[])new Object[0]), ExternalSystemJdkComboBox.buildComment(this.myProjectJdk), true));
        }
        if (ExternalSystemJdkUtil.isValidJdk(javaHomePath = ExternalSystemJdkUtil.getJavaHome())) {
            result.put("#JAVA_HOME", new JdkComboBoxItem("#JAVA_HOME", ExternalSystemBundle.message((String)"external.system.java.home.env", (Object[])new Object[0]), ExternalSystemBundle.message((String)"external.system.sdk.hint.path", (Object[])new Object[]{ExternalSystemJdkComboBox.truncateLongPath(javaHomePath)}), true));
        }
        return result;
    }

    @NlsContexts.HintText
    private static String buildComment(@NotNull Sdk sdk) {
        String path;
        if (sdk == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(4);
        }
        String versionString = sdk.getVersionString();
        String homePath = sdk.getHomePath();
        String string = path = homePath == null ? null : ExternalSystemJdkComboBox.truncateLongPath(homePath);
        if (versionString == null && path == null) {
            return "";
        }
        if (path == null) {
            return versionString;
        }
        if (versionString == null) {
            return ExternalSystemBundle.message((String)"external.system.sdk.hint.path", (Object[])new Object[]{path});
        }
        return ExternalSystemBundle.message((String)"external.system.sdk.hint.path.and.version", (Object[])new Object[]{versionString, path});
    }

    @NotNull
    private static String truncateLongPath(@NotNull String path) {
        if (path == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(5);
        }
        if (path.length() > 50) {
            String string = path.substring(0, 25) + "..." + path.substring(path.length() - 25 - 3);
            if (string == null) {
                ExternalSystemJdkComboBox.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(7);
        }
        return string;
    }

    static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected || SystemInfoRt.isWindows && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setUpButton";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdksModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalSystemJdkComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalSystemJdkComboBox";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateLongPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSetupButton";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildComment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "truncateLongPath";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static class JdkComboBoxItem {
        @NlsSafe
        final String jdkName;
        final @NlsContexts.Label String label;
        final @NlsContexts.HintText String comment;
        final boolean valid;

        JdkComboBoxItem(@NlsSafe String jdkName, @NlsContexts.Label String label, @NlsContexts.HintText String comment, boolean valid) {
            this.jdkName = jdkName;
            this.label = label;
            this.comment = comment;
            this.valid = valid;
        }
    }
}

