/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.SdkComboBox;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001\u001a\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001\u001a$\u0010\u000f\u001a\u00020\u0010*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010\"-\u0010\u0000\u001a\u0014 \u0003*\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00020\u0001\u00a2\u0006\u0002\b\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0018"}, d2={"RESOLVING_JDK", "", "Lorg/jetbrains/annotations/Nls;", "kotlin.jvm.PlatformType", "getRESOLVING_JDK", "()Ljava/lang/String;", "RESOLVING_JDK$delegate", "Lkotlin/Lazy;", "getSelectedJdkReference", "Lcom/intellij/openapi/roots/ui/configuration/SdkComboBox;", "sdkLookupProvider", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupProvider;", "setSelectedJdkReference", "", "jdkReference", "addJdkReferenceItem", "Lcom/intellij/openapi/roots/ui/configuration/SdkListItem;", "name", "homePath", "versionString", "isValid", "", "resolveJdkReference", "item", "intellij.platform.externalSystem.impl"})
@JvmName(name="ExternalSystemJdkComboBoxUtil")
@ApiStatus.Internal
public final class ExternalSystemJdkComboBoxUtil {
    @NotNull
    private static final Lazy RESOLVING_JDK$delegate = LazyKt.lazy(ExternalSystemJdkComboBoxUtil::RESOLVING_JDK_delegate$lambda$0);

    private static final String getRESOLVING_JDK() {
        Lazy lazy = RESOLVING_JDK$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public static final String getSelectedJdkReference(@NotNull SdkComboBox $this$getSelectedJdkReference, @NotNull SdkLookupProvider sdkLookupProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedJdkReference, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sdkLookupProvider, (String)"sdkLookupProvider");
        return ExternalSystemJdkComboBoxUtil.resolveJdkReference(sdkLookupProvider, $this$getSelectedJdkReference.getSelectedItem());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void setSelectedJdkReference(@NotNull SdkComboBox $this$setSelectedJdkReference, @NotNull SdkLookupProvider sdkLookupProvider, @Nullable String jdkReference) {
        Intrinsics.checkNotNullParameter((Object)$this$setSelectedJdkReference, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sdkLookupProvider, (String)"sdkLookupProvider");
        String string = jdkReference;
        if (Intrinsics.areEqual((Object)string, (Object)"#USE_PROJECT_JDK")) {
            $this$setSelectedJdkReference.setSelectedItem((Object)$this$setSelectedJdkReference.showProjectSdkItem());
            return;
        } else if (Intrinsics.areEqual((Object)string, (Object)"#JAVA_HOME")) {
            $this$setSelectedJdkReference.setSelectedItem((Object)ExternalSystemJdkComboBoxUtil.addJdkReferenceItem($this$setSelectedJdkReference, "JAVA_HOME", ExternalSystemJdkUtil.getJavaHome()));
            return;
        } else if (string == null) {
            SdkLookupProvider.SdkInfo sdkInfo = sdkLookupProvider.getSdkInfo();
            if (Intrinsics.areEqual((Object)sdkInfo, (Object)SdkLookupProvider.SdkInfo.Undefined.INSTANCE)) {
                $this$setSelectedJdkReference.setSelectedItem((Object)$this$setSelectedJdkReference.showNoneSdkItem());
                return;
            } else if (Intrinsics.areEqual((Object)sdkInfo, (Object)SdkLookupProvider.SdkInfo.Unresolved.INSTANCE)) {
                String string2 = ExternalSystemJdkComboBoxUtil.getRESOLVING_JDK();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-RESOLVING_JDK>(...)");
                $this$setSelectedJdkReference.setSelectedItem((Object)ExternalSystemJdkComboBoxUtil.addJdkReferenceItem($this$setSelectedJdkReference, string2, null, true));
                return;
            } else if (sdkInfo instanceof SdkLookupProvider.SdkInfo.Resolving) {
                $this$setSelectedJdkReference.setSelectedItem((Object)ExternalSystemJdkComboBoxUtil.addJdkReferenceItem($this$setSelectedJdkReference, ((SdkLookupProvider.SdkInfo.Resolving)sdkInfo).getName(), ((SdkLookupProvider.SdkInfo.Resolving)sdkInfo).getVersionString(), true));
                return;
            } else {
                if (!(sdkInfo instanceof SdkLookupProvider.SdkInfo.Resolved)) throw new NoWhenBranchMatchedException();
                $this$setSelectedJdkReference.setSelectedSdk(((SdkLookupProvider.SdkInfo.Resolved)sdkInfo).getName());
            }
            return;
        } else {
            $this$setSelectedJdkReference.setSelectedSdk(jdkReference);
            return;
        }
    }

    @NotNull
    public static final SdkListItem addJdkReferenceItem(@NotNull SdkComboBox $this$addJdkReferenceItem, @NotNull String name, @Nullable String homePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$addJdkReferenceItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"getJavaSdkType(...)");
        SdkType type = sdkType;
        boolean isValid = ExternalSystemJdkUtil.isValidJdk(homePath);
        if (isValid) {
            String string2 = homePath;
            Intrinsics.checkNotNull((Object)string2);
            string = type.getVersionString(string2);
        } else {
            string = null;
        }
        String versionString = string;
        SdkListItem sdkListItem = $this$addJdkReferenceItem.addSdkReferenceItem(type, name, versionString, isValid);
        Intrinsics.checkNotNullExpressionValue((Object)sdkListItem, (String)"addSdkReferenceItem(...)");
        return sdkListItem;
    }

    @NotNull
    public static final SdkListItem addJdkReferenceItem(@NotNull SdkComboBox $this$addJdkReferenceItem, @NotNull String name, @Nullable String versionString, boolean isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$addJdkReferenceItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"getJavaSdkType(...)");
        SdkType type = sdkType;
        SdkListItem sdkListItem = $this$addJdkReferenceItem.addSdkReferenceItem(type, name, versionString, isValid);
        Intrinsics.checkNotNullExpressionValue((Object)sdkListItem, (String)"addSdkReferenceItem(...)");
        return sdkListItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String resolveJdkReference(@NotNull SdkLookupProvider $this$resolveJdkReference, @Nullable SdkListItem item) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$resolveJdkReference, (String)"<this>");
        SdkListItem sdkListItem = item;
        if (sdkListItem instanceof SdkListItem.ProjectSdkItem) {
            return "#USE_PROJECT_JDK";
        }
        if (sdkListItem instanceof SdkListItem.SdkItem) {
            string = ((SdkListItem.SdkItem)item).sdk.getName();
            return string;
        } else if (sdkListItem instanceof SdkListItem.InvalidSdkItem) {
            string = ((SdkListItem.InvalidSdkItem)item).sdkName;
            return string;
        } else {
            if (!(sdkListItem instanceof SdkListItem.SdkReferenceItem)) return null;
            String string2 = ((SdkListItem.SdkReferenceItem)item).name;
            if (Intrinsics.areEqual((Object)string2, (Object)"JAVA_HOME")) {
                return "#JAVA_HOME";
            }
            if (Intrinsics.areEqual((Object)string2, (Object)ExternalSystemJdkComboBoxUtil.getRESOLVING_JDK())) {
                Sdk sdk = $this$resolveJdkReference.getSdk();
                if (sdk == null) return null;
                string = sdk.getName();
                return string;
            } else {
                SdkLookupProvider.SdkInfo sdkInfo = $this$resolveJdkReference.getSdkInfo();
                if (Intrinsics.areEqual((Object)sdkInfo, (Object)SdkLookupProvider.SdkInfo.Undefined.INSTANCE)) {
                    return null;
                }
                if (Intrinsics.areEqual((Object)sdkInfo, (Object)SdkLookupProvider.SdkInfo.Unresolved.INSTANCE)) {
                    return null;
                }
                if (sdkInfo instanceof SdkLookupProvider.SdkInfo.Resolving) {
                    return null;
                }
                if (!(sdkInfo instanceof SdkLookupProvider.SdkInfo.Resolved)) throw new NoWhenBranchMatchedException();
                string = ((SdkLookupProvider.SdkInfo.Resolved)sdkInfo).getName();
            }
        }
        return string;
    }

    private static final String RESOLVING_JDK_delegate$lambda$0() {
        return ExternalSystemBundle.message((String)"external.system.java.in.resolving", (Object[])new Object[0]);
    }
}

