/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui.completion;

import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.openapi.externalSystem.service.ui.completion.TextCompletionField;
import com.intellij.openapi.externalSystem.service.ui.completion.TextCompletionInfo;
import com.intellij.openapi.externalSystem.service.ui.completion.TextCompletionRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J$\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionInfoRenderer;", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionRenderer;", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionInfo;", "<init>", "()V", "getText", "", "item", "customizeCellRenderer", "", "editor", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField;", "cell", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionRenderer$Cell;", "intellij.platform.externalSystem.impl"})
public final class TextCompletionInfoRenderer
implements TextCompletionRenderer<TextCompletionInfo> {
    @Override
    @NotNull
    public String getText(@NotNull TextCompletionInfo item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item.getText();
    }

    @Override
    public void customizeCellRenderer(@NotNull TextCompletionField<TextCompletionInfo> editor, @NotNull TextCompletionRenderer.Cell<TextCompletionInfo> cell) {
        Intrinsics.checkNotNullParameter(editor, (String)"editor");
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        TextCompletionInfo item = cell.getItem();
        JList<?> list = cell.getList();
        SimpleColoredComponent $this$customizeCellRenderer_u24lambda_u240 = cell.getComponent();
        boolean bl = false;
        $this$customizeCellRenderer_u24lambda_u240.setIcon(item.getIcon());
        TextCompletionRenderer.Companion.append($this$customizeCellRenderer_u24lambda_u240, item.getText(), editor.getTextToComplete());
        String description = item.getDescription();
        if (description != null) {
            Color descriptionForeground = LookupCellRenderer.Companion.getGrayedForeground(cell.isSelected());
            SimpleTextAttributes descriptionAttributes = new SimpleTextAttributes(0, descriptionForeground);
            $this$customizeCellRenderer_u24lambda_u240.append(" ");
            $this$customizeCellRenderer_u24lambda_u240.append(((Object)StringsKt.trim((CharSequence)description)).toString(), descriptionAttributes);
            int padding = Math.max($this$customizeCellRenderer_u24lambda_u240.getPreferredSize().width, list.getWidth() - ($this$customizeCellRenderer_u24lambda_u240.getIpad().left + $this$customizeCellRenderer_u24lambda_u240.getIpad().right));
            $this$customizeCellRenderer_u24lambda_u240.appendTextPadding(padding, 4);
        }
    }
}

