/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.externalSystem.statistics.HasSharedSourcesUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "GROUP", "AUTO_RELOAD_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectTrackerSettings$AutoReloadType;", "EXTERNAL_SYSTEM_ID", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "NUMBER_OF_LINKED_PROJECT", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "", "USE_QUALIFIED_MODULE_NAMES", "", "MODULES_COUNT", "HAS_SHARED_SOURCES", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nExternalSystemSettingsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSystemSettingsCollector.kt\ncom/intellij/openapi/externalSystem/statistics/ExternalSystemSettingsCollector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,61:1\n13130#2,3:62\n*S KotlinDebug\n*F\n+ 1 ExternalSystemSettingsCollector.kt\ncom/intellij/openapi/externalSystem/statistics/ExternalSystemSettingsCollector\n*L\n39#1:62,3\n*E\n"})
public final class ExternalSystemSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("build.tools.state", 5, null, 4, null);
    @NotNull
    private final EventId1<ExternalSystemProjectTrackerSettings.AutoReloadType> AUTO_RELOAD_TYPE = this.GROUP.registerEvent("autoReloadType", (EventField)EventFields.Enum((String)"value", ExternalSystemProjectTrackerSettings.AutoReloadType.class, ExternalSystemSettingsCollector::AUTO_RELOAD_TYPE$lambda$0));
    @NotNull
    private final StringEventField EXTERNAL_SYSTEM_ID = EventFields.StringValidatedByEnum((String)"externalSystemId", (String)"build_tools");
    @NotNull
    private final EventId2<Integer, String> NUMBER_OF_LINKED_PROJECT = this.GROUP.registerEvent("numberOfLinkedProject", (EventField)EventFields.Count, (EventField)this.EXTERNAL_SYSTEM_ID);
    @NotNull
    private final EventId2<Boolean, String> USE_QUALIFIED_MODULE_NAMES = this.GROUP.registerEvent("useQualifiedModuleNames", (EventField)EventFields.Enabled, (EventField)this.EXTERNAL_SYSTEM_ID);
    @NotNull
    private final EventId2<Integer, String> MODULES_COUNT = this.GROUP.registerEvent("modules.count", (EventField)EventFields.RoundedInt((String)"count_rounded"), (EventField)this.EXTERNAL_SYSTEM_ID);
    @NotNull
    private final EventId1<Boolean> HAS_SHARED_SOURCES = this.GROUP.registerEvent("has.shared.sources", (EventField)EventFields.Enabled);

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set usages = new LinkedHashSet();
        ExternalSystemProjectTrackerSettings trackerSettings = ExternalSystemProjectTrackerSettings.Companion.getInstance(project);
        usages.add(this.AUTO_RELOAD_TYPE.metric((Object)trackerSettings.getAutoReloadType()));
        usages.add(this.HAS_SHARED_SOURCES.metric((Object)HasSharedSourcesUtil.hasSharedSources(project)));
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            Collection projects;
            ProjectSystemId projectSystemId = manager.getSystemId();
            Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"getSystemId(...)");
            String systemId = ExternalSystemStatUtilKt.getAnonymizedSystemId(projectSystemId);
            Intrinsics.checkNotNullExpressionValue((Object)((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project)).getLinkedProjectsSettings(), (String)"getLinkedProjectsSettings(...)");
            usages.add(this.NUMBER_OF_LINKED_PROJECT.metric((Object)projects.size(), (Object)systemId));
            for (ExternalProjectSettings projectsSetting : projects) {
                usages.add(this.USE_QUALIFIED_MODULE_NAMES.metric((Object)projectsSetting.isUseQualifiedModuleNames(), (Object)systemId));
                usages.add(this.MODULES_COUNT.metric((Object)projectsSetting.getModules().size(), (Object)systemId));
            }
        }
        Module[] $this$count$iv = ModuleManager.Companion.getInstance(project).getModules();
        boolean $i$f$count = false;
        int count$iv = 0;
        int n = $this$count$iv.length;
        for (int j = 0; j < n; ++j) {
            Module element$iv;
            Module it = element$iv = $this$count$iv[j];
            boolean bl = false;
            if (!ExternalSystemModulePropertyManager.Companion.getInstance(it).isMavenized()) continue;
            ++count$iv;
        }
        int mavenModules = count$iv;
        if (mavenModules > 0) {
            usages.add(this.MODULES_COUNT.metric((Object)mavenModules, (Object)"Maven"));
        }
        return usages;
    }

    private static final String AUTO_RELOAD_TYPE$lambda$0(ExternalSystemProjectTrackerSettings.AutoReloadType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.name();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }
}

