/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.statistics.JreType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.lang.JavaVersion;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsageFields;", "", "<init>", "()V", "UNKNOWN", "", "JRE_TYPE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/openapi/externalSystem/statistics/JreType;", "getJRE_TYPE_FIELD", "()Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "getJreType", "jreName", "getJreVersion", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nExternalSystemUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSystemUsagesCollector.kt\ncom/intellij/openapi/externalSystem/statistics/ExternalSystemUsageFields\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class ExternalSystemUsageFields {
    @NotNull
    public static final ExternalSystemUsageFields INSTANCE = new ExternalSystemUsageFields();
    @NotNull
    private static final String UNKNOWN = "unknown";
    @NotNull
    private static final EnumEventField<JreType> JRE_TYPE_FIELD = EventFields.Enum((String)"value", JreType.class, ExternalSystemUsageFields::JRE_TYPE_FIELD$lambda$0);

    private ExternalSystemUsageFields() {
    }

    @NotNull
    public final EnumEventField<JreType> getJRE_TYPE_FIELD() {
        return JRE_TYPE_FIELD;
    }

    @NotNull
    public final JreType getJreType(@Nullable String jreName) {
        JreType jreType;
        Object v0;
        Object object;
        block4: {
            object = (Iterable)JreType.getEntries();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                JreType it = (JreType)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDescription(), (Object)jreName)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        JreType jreType2 = v0;
        object = jreName;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            jreType = JreType.EMPTY;
        } else {
            jreType = jreType2;
            if (jreType == null) {
                jreType = JreType.CUSTOM;
            }
        }
        JreType anonymizedName = jreType;
        return anonymizedName;
    }

    @NotNull
    public final String getJreVersion(@NotNull Project project, @Nullable String jreName) {
        Sdk jdk;
        Sdk sdk;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            sdk = ExternalSystemJdkUtil.getJdk(project, jreName);
        }
        catch (Throwable ignored) {
            return UNKNOWN;
        }
        Sdk sdk2 = jdk = sdk;
        JavaVersion javaVersion = JavaVersion.Companion.tryParse(sdk2 != null ? sdk2.getVersionString() : null);
        if (javaVersion == null) {
            return UNKNOWN;
        }
        JavaVersion javaVersion2 = javaVersion;
        return javaVersion2.feature + "." + javaVersion2.minor;
    }

    private static final String JRE_TYPE_FIELD$lambda$0(JreType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getDescription();
    }
}

