/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.externalSystem.statistics.SystemIdValidationRule;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0005H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "EXTERNAL_SYSTEM_ID", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nExternalSystemUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSystemUsagesCollector.kt\ncom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n90#2,3:79\n1#3:82\n*S KotlinDebug\n*F\n+ 1 ExternalSystemUsagesCollector.kt\ncom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector\n*L\n60#1:79,3\n*E\n"})
public final class ExternalSystemUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("build.tools", 4, null, 4, null);
    @NotNull
    private final EventId1<String> EXTERNAL_SYSTEM_ID;

    public ExternalSystemUsagesCollector() {
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "value";
        String description$iv = null;
        boolean $i$f$StringValidatedByCustomRule = false;
        this.EXTERNAL_SYSTEM_ID = this.GROUP.registerEvent("externalSystemId", (EventField)EventFields.StringValidatedByCustomRule((String)name$iv, SystemIdValidationRule.class, description$iv));
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Set usages;
        block3: {
            Module module;
            block2: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                usages = new LinkedHashSet();
                for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
                    if (((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project)).getLinkedProjectsSettings().isEmpty()) continue;
                    ProjectSystemId projectSystemId = manager.getSystemId();
                    Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"getSystemId(...)");
                    usages.add(this.EXTERNAL_SYSTEM_ID.metric((Object)ExternalSystemStatUtilKt.getAnonymizedSystemId(projectSystemId)));
                }
                Module[] moduleArray = ModuleManager.Companion.getInstance(project).getModules();
                int n = moduleArray.length;
                for (int j = 0; j < n; ++j) {
                    Module module2;
                    Module it = module2 = moduleArray[j];
                    boolean bl = false;
                    if (!ExternalSystemModulePropertyManager.Companion.getInstance(it).isMavenized()) continue;
                    module = module2;
                    break block2;
                }
                module = null;
            }
            if (module == null) break block3;
            Module it = module;
            boolean bl = false;
            usages.add(this.EXTERNAL_SYSTEM_ID.metric((Object)"Maven"));
        }
        return usages;
    }
}

