/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.AbstractCrcCalculator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/util/DefaultCrcCalculator;", "Lcom/intellij/openapi/externalSystem/util/AbstractCrcCalculator;", "<init>", "()V", "isApplicable", "", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isIgnoredToken", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "tokenText", "", "parserDefinition", "Lcom/intellij/lang/ParserDefinition;", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class DefaultCrcCalculator
extends AbstractCrcCalculator {
    @NotNull
    public static final DefaultCrcCalculator INSTANCE = new DefaultCrcCalculator();

    private DefaultCrcCalculator() {
    }

    public boolean isApplicable(@NotNull ProjectSystemId systemId, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    @Override
    public boolean isIgnoredToken(@NotNull IElementType tokenType, @NotNull CharSequence tokenText, @NotNull ParserDefinition parserDefinition) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter((Object)tokenText, (String)"tokenText");
        Intrinsics.checkNotNullParameter((Object)parserDefinition, (String)"parserDefinition");
        TokenSet[] tokenSetArray = new TokenSet[]{parserDefinition.getCommentTokens(), parserDefinition.getWhitespaceTokens()};
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        TokenSet ignoredTokens = tokenSet;
        return ignoredTokens.contains(tokenType);
    }
}

