/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util.wsl;

import com.intellij.util.ExceptionUtil;
import java.net.ConnectException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a1\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"connectRetrying", "T", "timeoutMillis", "", "step", "action", "Lkotlin/Function0;", "(JJLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class WSLUtilKt {
    public static final <T> T connectRetrying(long timeoutMillis, long step, @NotNull Function0<? extends T> action2) {
        Object object;
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        long start = System.currentTimeMillis();
        Object result = null;
        Throwable lastException = null;
        do {
            try {
                object = action2.invoke();
            }
            catch (Throwable e) {
                Throwable rootCause;
                Intrinsics.checkNotNullExpressionValue((Object)ExceptionUtil.getRootCause((Throwable)e), (String)"getRootCause(...)");
                if (!(rootCause instanceof ConnectException)) {
                    throw e;
                }
                lastException = e;
                Thread.sleep(step);
                object = null;
            }
        } while ((result = object) == null && System.currentTimeMillis() - start < timeoutMillis);
        if (result == null) {
            if (lastException != null) {
                throw lastException;
            }
            throw new RuntimeException("Unexpected failure while connecting to remote server");
        }
        return (T)result;
    }

    public static /* synthetic */ Object connectRetrying$default(long l, long l2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = 100L;
        }
        return WSLUtilKt.connectRetrying(l, l2, function0);
    }
}

