/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.idea.AppMode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.backend.BackendTerminalInputKt;
import com.intellij.terminal.backend.BackendTerminalSession;
import com.intellij.terminal.backend.JediTermServices;
import com.intellij.terminal.backend.ObservableJediTerminal;
import com.intellij.terminal.backend.TerminalActivityTracker;
import com.intellij.terminal.backend.TerminalStarterEx;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.session.impl.TerminalClearBufferEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalCloseEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalHyperlinkClickedEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalInputEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalResizeEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalWriteBytesEvent;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a$\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0082@\u00a2\u0006\u0002\u0010\u000b\u001a\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"createTerminalInputChannel", "Lkotlinx/coroutines/channels/SendChannel;", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalInputEvent;", "services", "Lcom/intellij/terminal/backend/JediTermServices;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "handleInputEvents", "", "channel", "Lkotlinx/coroutines/channels/ReceiveChannel;", "(Lkotlinx/coroutines/channels/ReceiveChannel;Lcom/intellij/terminal/backend/JediTermServices;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleInputEvent", "event", "isTypingBytes", "", "bytes", "", "intellij.terminal.backend"})
@SourceDebugExtension(value={"SMAP\nBackendTerminalInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalInput.kt\ncom/intellij/terminal/backend/BackendTerminalInputKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n*L\n1#1,119:1\n67#2,4:120\n645#3,7:124\n*S KotlinDebug\n*F\n+ 1 BackendTerminalInput.kt\ncom/intellij/terminal/backend/BackendTerminalInputKt\n*L\n53#1:120,4\n88#1:124,7\n*E\n"})
public final class BackendTerminalInputKt {
    @NotNull
    public static final SendChannel<TerminalInputEvent> createTerminalInputChannel(@NotNull JediTermServices services, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Channel inputChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Channel<TerminalInputEvent>)inputChannel, services, null){
            int label;
            final /* synthetic */ Channel<TerminalInputEvent> $inputChannel;
            final /* synthetic */ JediTermServices $services;
            {
                this.$inputChannel = $inputChannel;
                this.$services = $services;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BackendTerminalInputKt.access$handleInputEvents((ReceiveChannel)this.$inputChannel, this.$services, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$inputChannel), null, (int)1, null);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return (SendChannel)inputChannel;
    }

    /*
     * Unable to fully structure code
     */
    private static final Object handleInputEvents(ReceiveChannel<? extends TerminalInputEvent> channel, JediTermServices services, Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleInputEvents.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BackendTerminalInputKt.access$handleInputEvents(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = channel.iterator();
lbl13:
                // 3 sources

                while (true) {
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable(channel);
                    $continuation.L$1 = services;
                    $continuation.L$2 = var3_6;
                    $continuation.label = 1;
                    v0 = var3_6.hasNext((Continuation)$continuation);
                    if (v0 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl28
                    break;
                }
            }
            case 1: {
                var3_6 = (ChannelIterator)$continuation.L$2;
                services = (JediTermServices)$continuation.L$1;
                channel = (ReceiveChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) ** GOTO lbl39
                event = (TerminalInputEvent)var3_6.next();
                try {
                    BackendTerminalInputKt.handleInputEvent(event, services);
                    ** GOTO lbl13
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable t) {
                    BackendTerminalSession.Companion.getLOG().error("Exception when handling input event: " + event, t);
                    ** continue;
                }
lbl39:
                // 1 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void handleInputEvent(TerminalInputEvent event, JediTermServices services) {
        Logger $this$trace$iv = BackendTerminalSession.Companion.getLOG();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Input event received: " + event);
        }
        TerminalStarterEx terminalStarter = services.getTerminalStarter();
        TerminalActivityTracker.Companion.getInstance().registerActivity();
        TerminalInputEvent terminalInputEvent = event;
        if (terminalInputEvent instanceof TerminalWriteBytesEvent) {
            long eventTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            if (BackendTerminalInputKt.isTypingBytes(((TerminalWriteBytesEvent)event).getBytes())) {
                terminalStarter.sendTypedBytes(((TerminalWriteBytesEvent)event).getBytes(), (TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)eventTime));
            } else {
                terminalStarter.sendBytes(((TerminalWriteBytesEvent)event).getBytes(), false);
            }
            Byte by = ArraysKt.firstOrNull((byte[])((TerminalWriteBytesEvent)event).getBytes());
            boolean bl = by != null ? by == 13 : false;
            if (bl && AppMode.isRemoteDevHost()) {
                TerminalUsageLocalStorage.Companion.getInstance().recordEnterKeyPressed();
            }
        } else if (terminalInputEvent instanceof TerminalResizeEvent) {
            TermSize termSize = new TermSize(((TerminalResizeEvent)event).getNewSize().getColumns(), ((TerminalResizeEvent)event).getNewSize().getRows());
            terminalStarter.postResize(termSize, RequestOrigin.User);
        } else if (terminalInputEvent instanceof TerminalCloseEvent) {
            terminalStarter.close();
            TtyConnector ttyConnector = terminalStarter.getTtyConnector();
            Intrinsics.checkNotNullExpressionValue((Object)ttyConnector, (String)"getTtyConnector(...)");
            TerminalUtilKt.waitFor(ttyConnector, TerminalUtilKt.STOP_EMULATOR_TIMEOUT, (Function0<Unit>)((Function0)() -> BackendTerminalInputKt.handleInputEvent$lambda$1(terminalStarter)));
        } else if (terminalInputEvent instanceof TerminalClearBufferEvent) {
            TerminalTextBuffer textBuffer;
            TerminalTextBuffer $this$withLock$iv = textBuffer = services.getTextBuffer();
            boolean $i$f$withLock = false;
            $this$withLock$iv.lock();
            try {
                TerminalTextBuffer it = $this$withLock$iv;
                boolean bl = false;
                textBuffer.clearHistory();
                ObservableJediTerminal controller = services.getController();
                if (controller.getY() > 0) {
                    TerminalLine lastLine = textBuffer.getLine(controller.getY() - 1);
                    textBuffer.clearScreenBuffer();
                    textBuffer.addLine(lastLine);
                    controller.setY(1);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$withLock$iv.unlock();
            }
        } else if (!(terminalInputEvent instanceof TerminalHyperlinkClickedEvent)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final boolean isTypingBytes(byte[] bytes) {
        String string = new String(bytes, Charsets.UTF_8);
        if (string.length() > 1) {
            return false;
        }
        char c = string.charAt(0);
        return !Character.isISOControl(c) || c == '\r' || c == '\u007f';
    }

    private static final Unit handleInputEvent$lambda$1(TerminalStarterEx $terminalStarter) {
        $terminalStarter.requestEmulatorStop();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$handleInputEvents(ReceiveChannel channel, JediTermServices services, Continuation $completion) {
        return BackendTerminalInputKt.handleInputEvents((ReceiveChannel<? extends TerminalInputEvent>)channel, services, (Continuation<? super Unit>)$completion);
    }
}

