/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.frontend.view.impl.TerminalOutputScrollingModel;
import com.intellij.terminal.frontend.view.impl.TerminalViewImplKt;
import com.intellij.util.CoroutineScopeKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.block.BlockTerminalOptions;
import org.jetbrains.plugins.terminal.block.BlockTerminalOptionsListener;
import org.jetbrains.plugins.terminal.block.ui.BlockSeparatorRenderer;
import org.jetbrains.plugins.terminal.block.ui.TerminalBlockLeftErrorRenderer;
import org.jetbrains.plugins.terminal.block.ui.TerminalPromptLeftAreaRenderer;
import org.jetbrains.plugins.terminal.block.ui.TerminalPromptSeparatorRenderer;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.block.ui.VerticalSpaceInlayRenderer;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockAddedEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockBase;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockId;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlockRemovedEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlocksModelEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlocksModelListener;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalBlocksReplacedEvent;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalCommandBlock;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001+B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0014\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010#\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020%H\u0002J\u0018\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006,"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalBlocksDecorator;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "blocksModel", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlocksModel;", "scrollingModel", "Lcom/intellij/terminal/frontend/view/impl/TerminalOutputScrollingModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlocksModel;Lcom/intellij/terminal/frontend/view/impl/TerminalOutputScrollingModel;Lkotlinx/coroutines/CoroutineScope;)V", "decorations", "", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlockId;", "Lcom/intellij/terminal/frontend/view/impl/TerminalBlocksDecorator$BlockDecoration;", "getDecorations", "()Ljava/util/Map;", "handleBlocksModelEvent", "", "event", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlocksModelEvent;", "doHandleBlocksModelEvent", "createPromptDecoration", "block", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalCommandBlock;", "createFinishedBlockDecoration", "createDecorationsForAllBlocks", "disposeAllDecorations", "disposeDecoration", "decoration", "createTopInlay", "Lcom/intellij/openapi/editor/Inlay;", "createBottomInlay", "offset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "createBackgroundHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "startOffset", "endOffset", "createCornersHighlighter", "BlockDecoration", "intellij.terminal.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalBlocksDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBlocksDecorator.kt\ncom/intellij/terminal/frontend/view/impl/TerminalBlocksDecorator\n+ 2 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n549#2,6:216\n1#3:222\n*S KotlinDebug\n*F\n+ 1 TerminalBlocksDecorator.kt\ncom/intellij/terminal/frontend/view/impl/TerminalBlocksDecorator\n*L\n69#1:216,6\n*E\n"})
public final class TerminalBlocksDecorator {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalBlocksModel blocksModel;
    @NotNull
    private final TerminalOutputScrollingModel scrollingModel;
    @VisibleForTesting
    @NotNull
    private final Map<TerminalBlockId, BlockDecoration> decorations;

    public TerminalBlocksDecorator(@NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull TerminalBlocksModel blocksModel, @NotNull TerminalOutputScrollingModel scrollingModel, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)blocksModel, (String)"blocksModel");
        Intrinsics.checkNotNullParameter((Object)scrollingModel, (String)"scrollingModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.editor = editor;
        this.outputModel = outputModel;
        this.blocksModel = blocksModel;
        this.scrollingModel = scrollingModel;
        this.decorations = new HashMap();
        this.blocksModel.addListener(CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope), new TerminalBlocksModelListener(){

            @Override
            public void blockAdded(TerminalBlockAddedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.handleBlocksModelEvent(event);
            }

            @Override
            public void blockRemoved(TerminalBlockRemovedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.handleBlocksModelEvent(event);
            }

            @Override
            public void blocksReplaced(TerminalBlocksReplacedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.handleBlocksModelEvent(event);
            }
        });
        BlockTerminalOptions options = BlockTerminalOptions.Companion.getInstance();
        options.addListener(CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope), new BlockTerminalOptionsListener(){

            @Override
            public void showSeparatorsBetweenBlocksChanged(boolean shouldShow) {
                if (shouldShow) {
                    this.createDecorationsForAllBlocks();
                } else {
                    this.disposeAllDecorations();
                }
            }
        });
        if (options.getShowSeparatorsBetweenBlocks()) {
            this.createDecorationsForAllBlocks();
        }
    }

    @NotNull
    public final Map<TerminalBlockId, BlockDecoration> getDecorations() {
        return this.decorations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleBlocksModelEvent(TerminalBlocksModelEvent event) {
        if (!BlockTerminalOptions.Companion.getInstance().getShowSeparatorsBetweenBlocks()) {
            return;
        }
        Editor $this$doTerminalOutputScrollChangingAction$iv = (Editor)this.editor;
        boolean $i$f$doTerminalOutputScrollChangingAction = false;
        TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress($this$doTerminalOutputScrollChangingAction$iv, true);
        try {
            boolean bl = false;
            this.doHandleBlocksModelEvent(event);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress($this$doTerminalOutputScrollChangingAction$iv, false);
        }
        this.scrollingModel.scrollToCursor(false);
    }

    private final void doHandleBlocksModelEvent(TerminalBlocksModelEvent event) {
        TerminalBlocksModelEvent terminalBlocksModelEvent = event;
        if (terminalBlocksModelEvent instanceof TerminalBlockAddedEvent) {
            TerminalBlockBase terminalBlockBase;
            TerminalCommandBlock previousBlock;
            Object object = CollectionsKt.getOrNull(this.blocksModel.getBlocks(), (int)(CollectionsKt.getLastIndex(this.blocksModel.getBlocks()) - 1));
            TerminalCommandBlock terminalCommandBlock = previousBlock = object instanceof TerminalCommandBlock ? (TerminalCommandBlock)object : null;
            if (previousBlock != null) {
                BlockDecoration blockDecoration = this.decorations.get(previousBlock.getId());
                if (blockDecoration == null) {
                    throw new IllegalStateException(("Decoration not found for block " + previousBlock).toString());
                }
                BlockDecoration decoration = blockDecoration;
                this.disposeDecoration(decoration);
                this.decorations.put(previousBlock.getId(), this.createFinishedBlockDecoration(previousBlock));
            }
            TerminalCommandBlock terminalCommandBlock2 = (terminalBlockBase = ((TerminalBlockAddedEvent)event).getBlock()) instanceof TerminalCommandBlock ? (TerminalCommandBlock)terminalBlockBase : null;
            if (terminalCommandBlock2 == null) {
                return;
            }
            TerminalCommandBlock block = terminalCommandBlock2;
            this.decorations.put(block.getId(), this.createPromptDecoration(block));
        } else if (terminalBlocksModelEvent instanceof TerminalBlockRemovedEvent) {
            TerminalBlockBase block = ((TerminalBlockRemovedEvent)event).getBlock();
            BlockDecoration blockDecoration = this.decorations.get(block.getId());
            if (blockDecoration == null) {
                return;
            }
            BlockDecoration decoration = blockDecoration;
            this.disposeDecoration(decoration);
            this.decorations.remove(block.getId());
        } else if (terminalBlocksModelEvent instanceof TerminalBlocksReplacedEvent) {
            this.disposeAllDecorations();
            this.createDecorationsForAllBlocks();
        }
    }

    private final BlockDecoration createPromptDecoration(TerminalCommandBlock block) {
        RangeHighlighter rangeHighlighter;
        TerminalOffset startOffset = (TerminalOffset)RangesKt.coerceAtLeast((Comparable)block.getStartOffset(), (Comparable)this.outputModel.getStartOffset());
        TerminalOffset endOffset = block.getEndOffset();
        Inlay<?> topInlay = this.createTopInlay(block);
        RangeHighlighter bgHighlighter = this.createBackgroundHighlighter(startOffset, endOffset);
        bgHighlighter.setGreedyToRight(true);
        RangeHighlighter it = rangeHighlighter = this.createCornersHighlighter(startOffset, endOffset);
        boolean bl = false;
        it.setGreedyToLeft(true);
        it.setGreedyToRight(true);
        it.setCustomRenderer((CustomHighlighterRenderer)new TerminalPromptSeparatorRenderer());
        it.setLineMarkerRenderer((LineMarkerRenderer)new TerminalPromptLeftAreaRenderer());
        RangeHighlighter cornersHighlighter = rangeHighlighter;
        return new BlockDecoration(block.getId(), bgHighlighter, cornersHighlighter, topInlay, null);
    }

    private final BlockDecoration createFinishedBlockDecoration(TerminalCommandBlock block) {
        TerminalOffset startOffset = (TerminalOffset)RangesKt.coerceAtLeast((Comparable)block.getStartOffset(), (Comparable)this.outputModel.getStartOffset());
        TerminalOffset endOffset = (TerminalOffset)RangesKt.coerceAtLeast((Comparable)block.getEndOffset().minus(1L), (Comparable)this.outputModel.getStartOffset());
        Inlay<?> topInlay = this.createTopInlay(block);
        Inlay<?> bottomInlay = this.createBottomInlay(endOffset);
        RangeHighlighter bgHighlighter = this.createBackgroundHighlighter(startOffset, endOffset);
        RangeHighlighter cornersHighlighter = this.createCornersHighlighter(startOffset, endOffset);
        cornersHighlighter.setCustomRenderer((CustomHighlighterRenderer)new BlockSeparatorRenderer());
        if (block.getExitCode() != null) {
            Integer n = block.getExitCode();
            if (n == null || n != 0) {
                cornersHighlighter.setLineMarkerRenderer((LineMarkerRenderer)new TerminalBlockLeftErrorRenderer());
            }
        }
        return new BlockDecoration(block.getId(), bgHighlighter, cornersHighlighter, topInlay, bottomInlay);
    }

    private final void createDecorationsForAllBlocks() {
        if (!this.decorations.isEmpty()) {
            boolean $i$a$-check-TerminalBlocksDecorator$createDecorationsForAllBlocks$22 = false;
            String $i$a$-check-TerminalBlocksDecorator$createDecorationsForAllBlocks$22 = "Decorations map should be empty";
            throw new IllegalStateException($i$a$-check-TerminalBlocksDecorator$createDecorationsForAllBlocks$22.toString());
        }
        List<TerminalBlockBase> blocks = this.blocksModel.getBlocks();
        int n = ((Collection)blocks).size();
        for (int ind = 0; ind < n; ++ind) {
            TerminalCommandBlock block;
            TerminalBlockBase terminalBlockBase = blocks.get(ind);
            if ((terminalBlockBase instanceof TerminalCommandBlock ? (TerminalCommandBlock)terminalBlockBase : null) == null) continue;
            block = block;
            this.decorations.put(block.getId(), ind < CollectionsKt.getLastIndex(blocks) ? this.createFinishedBlockDecoration(block) : this.createPromptDecoration(block));
        }
    }

    private final void disposeAllDecorations() {
        for (BlockDecoration decoration : this.decorations.values()) {
            this.disposeDecoration(decoration);
        }
        this.decorations.clear();
    }

    private final void disposeDecoration(BlockDecoration decoration) {
        block0: {
            decoration.getBackgroundHighlighter().dispose();
            decoration.getCornersHighlighter().dispose();
            Disposer.dispose((Disposable)((Disposable)decoration.getTopInlay()));
            Inlay<?> inlay = decoration.getBottomInlay();
            if (inlay == null) break block0;
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }

    private final Inlay<?> createTopInlay(TerminalCommandBlock block) {
        VerticalSpaceInlayRenderer topRenderer = new VerticalSpaceInlayRenderer((Function0<Integer>)((Function0)() -> TerminalBlocksDecorator.createTopInlay$lambda$0(this, block)));
        Inlay inlay = this.editor.getInlayModel().addBlockElement(TerminalViewImplKt.toRelative(block.getStartOffset(), this.outputModel), false, true, 300, (EditorCustomElementRenderer)topRenderer);
        Intrinsics.checkNotNull((Object)inlay);
        return inlay;
    }

    private final Inlay<?> createBottomInlay(TerminalOffset offset) {
        VerticalSpaceInlayRenderer bottomRenderer = new VerticalSpaceInlayRenderer(6);
        Inlay inlay = this.editor.getInlayModel().addBlockElement(TerminalViewImplKt.toRelative(offset, this.outputModel), true, false, 100, (EditorCustomElementRenderer)bottomRenderer);
        Intrinsics.checkNotNull((Object)inlay);
        return inlay;
    }

    private final RangeHighlighter createBackgroundHighlighter(TerminalOffset startOffset, TerminalOffset endOffset) {
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(TerminalViewImplKt.toRelative(startOffset, this.outputModel), TerminalViewImplKt.toRelative(endOffset, this.outputModel), 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        return rangeHighlighter;
    }

    private final RangeHighlighter createCornersHighlighter(TerminalOffset startOffset, TerminalOffset endOffset) {
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(TerminalViewImplKt.toRelative(startOffset, this.outputModel), TerminalViewImplKt.toRelative(endOffset, this.outputModel), 900, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        return rangeHighlighter;
    }

    private static final int createTopInlay$lambda$0(TerminalBlocksDecorator this$0, TerminalCommandBlock $block) {
        TerminalBlockBase terminalBlockBase = (TerminalBlockBase)CollectionsKt.firstOrNull(this$0.blocksModel.getBlocks());
        boolean isFirstBlock = Intrinsics.areEqual((Object)(terminalBlockBase != null ? terminalBlockBase.getId() : null), (Object)$block.getId());
        return isFirstBlock ? 0 : 7;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\bH\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\f\b\u0002\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0015\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalBlocksDecorator$BlockDecoration;", "", "blockId", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlockId;", "backgroundHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "cornersHighlighter", "topInlay", "Lcom/intellij/openapi/editor/Inlay;", "bottomInlay", "<init>", "(Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlockId;Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/openapi/editor/Inlay;)V", "getBlockId", "()Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalBlockId;", "getBackgroundHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getCornersHighlighter", "getTopInlay", "()Lcom/intellij/openapi/editor/Inlay;", "getBottomInlay", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.terminal.frontend"})
    public static final class BlockDecoration {
        @NotNull
        private final TerminalBlockId blockId;
        @NotNull
        private final RangeHighlighter backgroundHighlighter;
        @NotNull
        private final RangeHighlighter cornersHighlighter;
        @NotNull
        private final Inlay<?> topInlay;
        @Nullable
        private final Inlay<?> bottomInlay;

        public BlockDecoration(@NotNull TerminalBlockId blockId, @NotNull RangeHighlighter backgroundHighlighter, @NotNull RangeHighlighter cornersHighlighter, @NotNull Inlay<?> topInlay, @Nullable Inlay<?> bottomInlay) {
            Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
            Intrinsics.checkNotNullParameter((Object)backgroundHighlighter, (String)"backgroundHighlighter");
            Intrinsics.checkNotNullParameter((Object)cornersHighlighter, (String)"cornersHighlighter");
            Intrinsics.checkNotNullParameter(topInlay, (String)"topInlay");
            this.blockId = blockId;
            this.backgroundHighlighter = backgroundHighlighter;
            this.cornersHighlighter = cornersHighlighter;
            this.topInlay = topInlay;
            this.bottomInlay = bottomInlay;
        }

        @NotNull
        public final TerminalBlockId getBlockId() {
            return this.blockId;
        }

        @NotNull
        public final RangeHighlighter getBackgroundHighlighter() {
            return this.backgroundHighlighter;
        }

        @NotNull
        public final RangeHighlighter getCornersHighlighter() {
            return this.cornersHighlighter;
        }

        @NotNull
        public final Inlay<?> getTopInlay() {
            return this.topInlay;
        }

        @Nullable
        public final Inlay<?> getBottomInlay() {
            return this.bottomInlay;
        }

        @NotNull
        public final TerminalBlockId component1() {
            return this.blockId;
        }

        @NotNull
        public final RangeHighlighter component2() {
            return this.backgroundHighlighter;
        }

        @NotNull
        public final RangeHighlighter component3() {
            return this.cornersHighlighter;
        }

        @NotNull
        public final Inlay<?> component4() {
            return this.topInlay;
        }

        @Nullable
        public final Inlay<?> component5() {
            return this.bottomInlay;
        }

        @NotNull
        public final BlockDecoration copy(@NotNull TerminalBlockId blockId, @NotNull RangeHighlighter backgroundHighlighter, @NotNull RangeHighlighter cornersHighlighter, @NotNull Inlay<?> topInlay, @Nullable Inlay<?> bottomInlay) {
            Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
            Intrinsics.checkNotNullParameter((Object)backgroundHighlighter, (String)"backgroundHighlighter");
            Intrinsics.checkNotNullParameter((Object)cornersHighlighter, (String)"cornersHighlighter");
            Intrinsics.checkNotNullParameter(topInlay, (String)"topInlay");
            return new BlockDecoration(blockId, backgroundHighlighter, cornersHighlighter, topInlay, bottomInlay);
        }

        public static /* synthetic */ BlockDecoration copy$default(BlockDecoration blockDecoration, TerminalBlockId terminalBlockId, RangeHighlighter rangeHighlighter, RangeHighlighter rangeHighlighter2, Inlay inlay, Inlay inlay2, int n, Object object) {
            if ((n & 1) != 0) {
                terminalBlockId = blockDecoration.blockId;
            }
            if ((n & 2) != 0) {
                rangeHighlighter = blockDecoration.backgroundHighlighter;
            }
            if ((n & 4) != 0) {
                rangeHighlighter2 = blockDecoration.cornersHighlighter;
            }
            if ((n & 8) != 0) {
                inlay = blockDecoration.topInlay;
            }
            if ((n & 0x10) != 0) {
                inlay2 = blockDecoration.bottomInlay;
            }
            return blockDecoration.copy(terminalBlockId, rangeHighlighter, rangeHighlighter2, inlay, inlay2);
        }

        @NotNull
        public String toString() {
            return "BlockDecoration(blockId=" + this.blockId + ", backgroundHighlighter=" + this.backgroundHighlighter + ", cornersHighlighter=" + this.cornersHighlighter + ", topInlay=" + this.topInlay + ", bottomInlay=" + this.bottomInlay + ")";
        }

        public int hashCode() {
            int result2 = this.blockId.hashCode();
            result2 = result2 * 31 + this.backgroundHighlighter.hashCode();
            result2 = result2 * 31 + this.cornersHighlighter.hashCode();
            result2 = result2 * 31 + this.topInlay.hashCode();
            result2 = result2 * 31 + (this.bottomInlay == null ? 0 : this.bottomInlay.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockDecoration)) {
                return false;
            }
            BlockDecoration blockDecoration = (BlockDecoration)other;
            if (!Intrinsics.areEqual((Object)this.blockId, (Object)blockDecoration.blockId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.backgroundHighlighter, (Object)blockDecoration.backgroundHighlighter)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cornersHighlighter, (Object)blockDecoration.cornersHighlighter)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.topInlay, blockDecoration.topInlay)) {
                return false;
            }
            return Intrinsics.areEqual(this.bottomInlay, blockDecoration.bottomInlay);
        }
    }
}

