/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.terminal.frontend.view.impl.TerminalOutputScrollingModel;
import com.intellij.terminal.frontend.view.impl.TerminalViewImplKt;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.terminal.block.BlockTerminalOptions;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.session.TerminalGridSize;
import org.jetbrains.plugins.terminal.session.impl.TerminalState;
import org.jetbrains.plugins.terminal.view.TerminalContentChangeEvent;
import org.jetbrains.plugins.terminal.view.TerminalCursorOffsetChangeEvent;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0017J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u000e\u0010\u001b\u001a\u00020\u0012H\u0087@\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalOutputScrollingModelImpl;", "Lcom/intellij/terminal/frontend/view/impl/TerminalOutputScrollingModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lkotlinx/coroutines/CoroutineScope;)V", "shouldScrollToCursor", "", "appliedOutputModelState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/terminal/frontend/view/impl/TerminalOutputScrollingModelImpl$OutputModelState;", "scrollToCursor", "", "force", "updateScrollPosition", "cursorOffset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "findLastNotBlankVisualLine", "", "startVisualLine", "getTopInset", "awaitEventProcessing", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCurrentOutputModelState", "OutputModelState", "intellij.terminal.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalOutputScrollingModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputScrollingModelImpl.kt\ncom/intellij/terminal/frontend/view/impl/TerminalOutputScrollingModelImpl\n+ 2 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n*L\n1#1,199:1\n549#2,3:200\n577#2,7:203\n554#2:210\n*S KotlinDebug\n*F\n+ 1 TerminalOutputScrollingModelImpl.kt\ncom/intellij/terminal/frontend/view/impl/TerminalOutputScrollingModelImpl\n*L\n145#1:200,3\n146#1:203,7\n145#1:210\n*E\n"})
public final class TerminalOutputScrollingModelImpl
implements TerminalOutputScrollingModel {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSessionModel sessionModel;
    private boolean shouldScrollToCursor;
    @NotNull
    private final MutableStateFlow<OutputModelState> appliedOutputModelState;

    public TerminalOutputScrollingModelImpl(@NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull TerminalSessionModel sessionModel, final @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.editor = editor;
        this.outputModel = outputModel;
        this.sessionModel = sessionModel;
        this.shouldScrollToCursor = true;
        this.appliedOutputModelState = StateFlowKt.MutableStateFlow((Object)this.getCurrentOutputModelState());
        this.outputModel.addListener(CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope), new TerminalOutputModelListener(){

            @Override
            public void afterContentChanged(TerminalContentChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (shouldScrollToCursor) {
                    CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                    ModalityState modalityState = ModalityState.any();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                    BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ TerminalOutputScrollingModelImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    TerminalOutputScrollingModelImpl.access$updateScrollPosition(this.this$0, TerminalOutputScrollingModelImpl.access$getOutputModel$p(this.this$0).getCursorOffset());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
            }

            @Override
            public void cursorOffsetChanged(TerminalCursorOffsetChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (shouldScrollToCursor) {
                    this.updateScrollPosition(event.getNewOffset());
                }
            }
        });
        this.editor.getScrollingModel().addVisibleAreaListener(new VisibleAreaListener(){

            public void visibleAreaChanged(VisibleAreaEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (TerminalUiUtilsKt.isTerminalOutputScrollChangingActionInProgress((Editor)editor)) {
                    return;
                }
                int endY = e.getNewRectangle().y + e.getNewRectangle().height;
                if (endY == ((TerminalOutputScrollingModelImpl)this).editor.getContentSize().height) {
                    shouldScrollToCursor = true;
                } else if (e.getOldRectangle() != null && e.getOldRectangle().y != e.getNewRectangle().y) {
                    shouldScrollToCursor = false;
                }
            }
        }, CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope));
    }

    @Override
    @RequiresEdt
    public void scrollToCursor(boolean force) {
        if (force) {
            this.shouldScrollToCursor = true;
        }
        if (this.shouldScrollToCursor) {
            this.updateScrollPosition(this.outputModel.getCursorOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateScrollPosition(TerminalOffset cursorOffset) {
        int scrollY;
        int n;
        TerminalGridSize terminalGridSize = TerminalUiUtilsKt.calculateTerminalSize((Editor)this.editor);
        if (terminalGridSize == null) {
            return;
        }
        int screenRows = terminalGridSize.getRows();
        int screenBottomVisualLine = this.editor.offsetToVisualLine(this.editor.getDocument().getTextLength(), true);
        int screenTopVisualLine = Math.max(0, screenBottomVisualLine - screenRows + 1);
        int topInset = this.getTopInset();
        int bottomInset = JBUI.scale((int)6);
        int lastNotBlankVisualLine = this.findLastNotBlankVisualLine(screenTopVisualLine);
        int lastNotBlankLineBottomY = this.editor.visualLineToY(lastNotBlankVisualLine) + this.editor.getLineHeight() + bottomInset;
        boolean isCursorVisible = ((TerminalState)this.sessionModel.getTerminalState().getValue()).isCursorVisible();
        int cursorVisualLine = this.editor.offsetToVisualLine(TerminalViewImplKt.toRelative(cursorOffset, this.outputModel), true);
        if (isCursorVisible) {
            int cursorBottomY = this.editor.visualLineToY(cursorVisualLine) + this.editor.getLineHeight() + bottomInset;
            n = Math.max(lastNotBlankLineBottomY, cursorBottomY);
        } else {
            n = lastNotBlankLineBottomY;
        }
        int screenBottomY = n;
        int screenTopY = this.editor.visualLineToY(screenTopVisualLine) - topInset;
        int screenHeight = this.editor.getScrollingModel().getVisibleArea().height;
        int n2 = scrollY = isCursorVisible && cursorVisualLine == screenTopVisualLine ? screenTopY : Math.max(screenBottomY - screenHeight, Math.max(screenTopY, this.editor.getScrollingModel().getVerticalScrollOffset()));
        if (scrollY != this.editor.getScrollingModel().getVerticalScrollOffset()) {
            Editor $this$doTerminalOutputScrollChangingAction$iv = (Editor)this.editor;
            boolean $i$f$doTerminalOutputScrollChangingAction = false;
            TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress($this$doTerminalOutputScrollChangingAction$iv, true);
            try {
                boolean bl = false;
                Editor $this$doWithoutScrollingAnimation$iv = (Editor)this.editor;
                boolean $i$f$doWithoutScrollingAnimation = false;
                $this$doWithoutScrollingAnimation$iv.getScrollingModel().disableAnimation();
                try {
                    boolean bl2 = false;
                    this.editor.getScrollingModel().scrollVertically(scrollY);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$doWithoutScrollingAnimation$iv.getScrollingModel().enableAnimation();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress($this$doTerminalOutputScrollChangingAction$iv, false);
            }
        }
        this.appliedOutputModelState.setValue((Object)new OutputModelState(cursorOffset, this.outputModel.getModificationStamp()));
    }

    private final int findLastNotBlankVisualLine(int startVisualLine) {
        int lastNotBlankVisualLine = startVisualLine;
        EditorEx editorEx = this.editor;
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        VisualLinesIterator iterator = new VisualLinesIterator((EditorImpl)editorEx, startVisualLine);
        while (!iterator.atEnd()) {
            int startOffset = iterator.getVisualLineStartOffset();
            int endOffset = iterator.getVisualLineEndOffset();
            if (!StringsKt.isBlank((CharSequence)((EditorImpl)this.editor).getDocument().getCharsSequence().subSequence(startOffset, endOffset))) {
                lastNotBlankVisualLine = iterator.getVisualLine();
            }
            iterator.advance();
        }
        return lastNotBlankVisualLine;
    }

    private final int getTopInset() {
        return ((TerminalState)this.sessionModel.getTerminalState().getValue()).isShellIntegrationEnabled() && BlockTerminalOptions.Companion.getInstance().getShowSeparatorsBetweenBlocks() ? JBUI.scale((int)6) : 0;
    }

    @TestOnly
    @Nullable
    public final Object awaitEventProcessing(@NotNull Continuation<? super Unit> $completion) {
        OutputModelState expectedState = this.getCurrentOutputModelState();
        Object object = FlowKt.first((Flow)((Flow)this.appliedOutputModelState), (Function2)((Function2)new Function2<OutputModelState, Continuation<? super Boolean>, Object>(expectedState, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ OutputModelState $expectedState;
            {
                this.$expectedState = $expectedState;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                OutputModelState outputModelState = (OutputModelState)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        return Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)it, (Object)this.$expectedState));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(OutputModelState p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final OutputModelState getCurrentOutputModelState() {
        return new OutputModelState(this.outputModel.getCursorOffset(), this.outputModel.getModificationStamp());
    }

    public static final /* synthetic */ TerminalOutputModel access$getOutputModel$p(TerminalOutputScrollingModelImpl $this) {
        return $this.outputModel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalOutputScrollingModelImpl$OutputModelState;", "", "cursorOffset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "docStamp", "", "<init>", "(Lorg/jetbrains/plugins/terminal/view/TerminalOffset;J)V", "getCursorOffset", "()Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "getDocStamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.terminal.frontend"})
    private static final class OutputModelState {
        @NotNull
        private final TerminalOffset cursorOffset;
        private final long docStamp;

        public OutputModelState(@NotNull TerminalOffset cursorOffset, long docStamp) {
            Intrinsics.checkNotNullParameter((Object)cursorOffset, (String)"cursorOffset");
            this.cursorOffset = cursorOffset;
            this.docStamp = docStamp;
        }

        @NotNull
        public final TerminalOffset getCursorOffset() {
            return this.cursorOffset;
        }

        public final long getDocStamp() {
            return this.docStamp;
        }

        @NotNull
        public final TerminalOffset component1() {
            return this.cursorOffset;
        }

        public final long component2() {
            return this.docStamp;
        }

        @NotNull
        public final OutputModelState copy(@NotNull TerminalOffset cursorOffset, long docStamp) {
            Intrinsics.checkNotNullParameter((Object)cursorOffset, (String)"cursorOffset");
            return new OutputModelState(cursorOffset, docStamp);
        }

        public static /* synthetic */ OutputModelState copy$default(OutputModelState outputModelState, TerminalOffset terminalOffset, long l, int n, Object object) {
            if ((n & 1) != 0) {
                terminalOffset = outputModelState.cursorOffset;
            }
            if ((n & 2) != 0) {
                l = outputModelState.docStamp;
            }
            return outputModelState.copy(terminalOffset, l);
        }

        @NotNull
        public String toString() {
            return "OutputModelState(cursorOffset=" + this.cursorOffset + ", docStamp=" + this.docStamp + ")";
        }

        public int hashCode() {
            int result2 = this.cursorOffset.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.docStamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OutputModelState)) {
                return false;
            }
            OutputModelState outputModelState = (OutputModelState)other;
            if (!Intrinsics.areEqual((Object)this.cursorOffset, (Object)outputModelState.cursorOffset)) {
                return false;
            }
            return this.docStamp == outputModelState.docStamp;
        }
    }
}

