/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.openapi.project.Project;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTab;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTabsManager;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTabsManagerKt;
import com.intellij.terminal.frontend.toolwindow.impl.TerminalInternalUtilsKt;
import com.intellij.terminal.frontend.view.TerminalView;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.toolWindow.ToolWindowSplitContentProvider;
import com.intellij.ui.content.Content;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.fus.TerminalOpeningWay;
import org.jetbrains.plugins.terminal.fus.TerminalStartupFusInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J \u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalToolWindowSplitContentProvider;", "Lcom/intellij/toolWindow/ToolWindowSplitContentProvider;", "<init>", "()V", "createContentCopy", "Lcom/intellij/ui/content/Content;", "project", "Lcom/intellij/openapi/project/Project;", "content", "createReworkedTerminalContent", "fusInfo", "Lorg/jetbrains/plugins/terminal/fus/TerminalStartupFusInfo;", "createClassicTerminalContent", "originalContent", "intellij.terminal.frontend"})
final class TerminalToolWindowSplitContentProvider
implements ToolWindowSplitContentProvider {
    @NotNull
    public Content createContentCopy(@NotNull Project project, @NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        TerminalStartupFusInfo fusInfo = new TerminalStartupFusInfo(TerminalOpeningWay.SPLIT_TOOLWINDOW, null, 2, null);
        return TerminalInternalUtilsKt.shouldUseReworkedTerminal() ? this.createReworkedTerminalContent(project, content, fusInfo) : this.createClassicTerminalContent(project, content);
    }

    private final Content createReworkedTerminalContent(Project project, Content content, TerminalStartupFusInfo fusInfo) {
        TerminalView originalView;
        TerminalToolWindowTabsManager manager = TerminalToolWindowTabsManager.Companion.getInstance(project);
        TerminalToolWindowTab terminalToolWindowTab = TerminalToolWindowTabsManagerKt.findTabByContent(manager, content);
        TerminalView terminalView = originalView = terminalToolWindowTab != null ? terminalToolWindowTab.getView() : null;
        String currentDirectory = terminalView != null ? terminalView.getCurrentDirectory() : null;
        return manager.createTabBuilder().workingDirectory(currentDirectory).shouldAddToToolWindow(false).startupFusInfo(fusInfo).createTab().getContent();
    }

    private final Content createClassicTerminalContent(Project project, Content originalContent) {
        TerminalTabState terminalTabState;
        TerminalWidget widget;
        TerminalWidget terminalWidget = widget = TerminalToolWindowManager.findWidgetByContent(originalContent);
        String currentDirectory = terminalWidget != null ? terminalWidget.getCurrentDirectory() : null;
        TerminalTabState it = terminalTabState = new TerminalTabState();
        boolean bl = false;
        it.myWorkingDirectory = currentDirectory;
        TerminalTabState tabState = terminalTabState;
        TerminalToolWindowManager manager = TerminalToolWindowManager.getInstance(project);
        Content content = manager.createTerminalContent(manager.getTerminalRunner(), TerminalOptionsProvider.Companion.getInstance().getTerminalEngine(), null, tabState, true, null);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createTerminalContent(...)");
        return content;
    }
}

