/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.ints;

import fleet.fastutil.ints.IntIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lfleet/fastutil/ints/IntArrays;", "", "<init>", "()V", "EMPTY_ARRAY", "", "getEMPTY_ARRAY", "()[I", "DEFAULT_EMPTY_ARRAY", "getDEFAULT_EMPTY_ARRAY", "forceCapacity", "array", "length", "", "preserve", "ensureCapacity", "grow", "trim", "unwrap", "i", "Lfleet/fastutil/ints/IntIterator;", "offset", "max", "fleet.fastutil"})
public final class IntArrays {
    @NotNull
    public static final IntArrays INSTANCE = new IntArrays();
    @NotNull
    private static final int[] EMPTY_ARRAY = new int[0];
    @NotNull
    private static final int[] DEFAULT_EMPTY_ARRAY = new int[0];

    private IntArrays() {
    }

    @NotNull
    public final int[] getEMPTY_ARRAY() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public final int[] getDEFAULT_EMPTY_ARRAY() {
        return DEFAULT_EMPTY_ARRAY;
    }

    @NotNull
    public final int[] forceCapacity(@NotNull int[] array, int length, int preserve) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int[] t = new int[length];
        ArraysKt.copyInto((int[])array, (int[])t, (int)0, (int)0, (int)preserve);
        return t;
    }

    @NotNull
    public final int[] ensureCapacity(@NotNull int[] array, int length, int preserve) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return length > array.length ? this.forceCapacity(array, length, preserve) : array;
    }

    @NotNull
    public final int[] grow(@NotNull int[] array, int length) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return this.grow(array, length, array.length);
    }

    @NotNull
    public final int[] grow(@NotNull int[] array, int length, int preserve) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (length > array.length) {
            int newLength = Math.max(Math.min(array.length + (array.length >> 1), 0x7FFFFFF7), length);
            int[] t = new int[newLength];
            ArraysKt.copyInto((int[])array, (int[])t, (int)0, (int)0, (int)preserve);
            return t;
        }
        return array;
    }

    @NotNull
    public final int[] trim(@NotNull int[] array, int length) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (length >= array.length) {
            return array;
        }
        int[] t = length == 0 ? EMPTY_ARRAY : new int[length];
        ArraysKt.copyInto((int[])array, (int[])t, (int)0, (int)0, (int)length);
        return t;
    }

    @NotNull
    public final int[] unwrap(@NotNull IntIterator i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        return this.unwrap(i, Integer.MAX_VALUE);
    }

    public final int unwrap(@NotNull IntIterator i, @NotNull int[] array, int offset, int max) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int offset2 = offset;
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset2 < 0 || offset2 + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            array[offset2++] = i.next();
        }
        return max - j - 1;
    }

    public final int unwrap(@NotNull IntIterator i, @NotNull int[] array) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return this.unwrap(i, array, 0, array.length);
    }

    @NotNull
    public final int[] unwrap(@NotNull IntIterator i, int max) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        int max2 = max;
        if (max2 < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max2 + ") is negative");
        }
        int[] array = new int[16];
        int j = 0;
        while (max2-- != 0 && i.hasNext()) {
            if (j == array.length) {
                array = this.grow(array, j + 1);
            }
            array[j++] = i.next();
        }
        return this.trim(array, j);
    }
}

