/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.platform.debugger.impl.ui.XDebuggerEntityConverter;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebugSession;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class XDebugView
implements Disposable {
    private final SingleAlarm clearAlarm = SingleAlarm.Companion.singleEdtAlarm(100, (Disposable)this, () -> this.clear());

    protected final void requestClear() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!this.clearAlarm.isDisposed()) {
                this.clear();
            }
        } else {
            this.clearAlarm.cancelAndRequest();
        }
    }

    @Nullable
    public JComponent getMainComponent() {
        return null;
    }

    protected final void cancelClear() {
        this.clearAlarm.cancel();
    }

    protected abstract void clear();

    @ApiStatus.Internal
    protected void sessionStopped() {
    }

    @ApiStatus.OverrideOnly
    @ApiStatus.Internal
    public void processSessionEvent(@NotNull SessionEvent event, @NotNull XDebugSessionProxy session) {
        XDebugSession xDebugSession;
        if (event == null) {
            XDebugView.$$$reportNull$$$0(0);
        }
        if (session == null) {
            XDebugView.$$$reportNull$$$0(1);
        }
        if ((xDebugSession = XDebuggerEntityConverter.getSession(session)) != null) {
            this.processSessionEvent(event, xDebugSession);
        }
    }

    @ApiStatus.Obsolete
    public void processSessionEvent(@NotNull SessionEvent event, @NotNull XDebugSession session) {
        if (event == null) {
            XDebugView.$$$reportNull$$$0(2);
        }
        if (session == null) {
            XDebugView.$$$reportNull$$$0(3);
        }
        throw new AbstractMethodError("Please override XDebugView.processSessionEvent(XDebugView.SessionEvent, XDebugSessionProxy)");
    }

    @Nullable
    protected static XDebugSession getSession(@NotNull EventObject e) {
        if (e == null) {
            XDebugView.$$$reportNull$$$0(4);
        }
        Component component = e.getSource() instanceof Component ? (Component)e.getSource() : null;
        return component == null ? null : XDebugView.getSession(component);
    }

    @ApiStatus.Internal
    @Nullable
    protected static XDebugSessionProxy getSessionProxy(@NotNull EventObject e) {
        if (e == null) {
            XDebugView.$$$reportNull$$$0(5);
        }
        Component component = e.getSource() instanceof Component ? (Component)e.getSource() : null;
        return component == null ? null : XDebugView.getSessionProxy(component);
    }

    @ApiStatus.Obsolete
    @Nullable
    public static XDebugSession getSession(@NotNull Component component) {
        if (component == null) {
            XDebugView.$$$reportNull$$$0(6);
        }
        return (XDebugSession)XDebugView.getData(XDebugSession.DATA_KEY, component);
    }

    @ApiStatus.Internal
    @Nullable
    public static XDebugSessionProxy getSessionProxy(@NotNull Component component) {
        if (component == null) {
            XDebugView.$$$reportNull$$$0(7);
        }
        return (XDebugSessionProxy)XDebugView.getData(XDebugSessionProxy.DEBUG_SESSION_PROXY_KEY, component);
    }

    @Nullable
    public static <T> T getData(DataKey<T> key, @NotNull Component component) {
        Object data;
        DataContext dataContext;
        ViewContext viewContext;
        ContentManager contentManager;
        if (component == null) {
            XDebugView.$$$reportNull$$$0(8);
        }
        ContentManager contentManager2 = contentManager = (viewContext = (ViewContext)ViewContext.CONTEXT_KEY.getData(dataContext = DataManager.getInstance().getDataContext(component))) == null ? null : viewContext.getContentManager();
        if (contentManager != null && !contentManager.isDisposed() && (data = key.getData(DataManager.getInstance().getDataContext((Component)contentManager.getComponent()))) != null) {
            return (T)data;
        }
        return (T)key.getData(dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebugView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processSessionEvent";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSession";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSessionProxy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum SessionEvent {
        PAUSED,
        BEFORE_RESUME,
        RESUMED,
        STOPPED,
        FRAME_CHANGED,
        SETTINGS_CHANGED;

    }
}

