/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.ModNavigatorTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ModNavigator;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public final class TailTypes {
    private static final ModNavigatorTailType UNKNOWN = new ModNavigatorTailType(){

        @Override
        public int processTail(@NotNull Project project, @NotNull ModNavigator navigator, int tailOffset) {
            if (project == null) {
                1.$$$reportNull$$$0(0);
            }
            if (navigator == null) {
                1.$$$reportNull$$$0(1);
            }
            return tailOffset;
        }

        @Override
        public int processTail(@NotNull Editor editor, int tailOffset) {
            if (editor == null) {
                1.$$$reportNull$$$0(2);
            }
            return tailOffset;
        }

        public String toString() {
            return "UNKNOWN";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "navigator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/TailTypes$1";
            objectArray[2] = "processTail";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final ModNavigatorTailType NONE = new ModNavigatorTailType(){

        @Override
        public int processTail(@NotNull Project project, @NotNull ModNavigator navigator, int tailOffset) {
            if (project == null) {
                2.$$$reportNull$$$0(0);
            }
            if (navigator == null) {
                2.$$$reportNull$$$0(1);
            }
            return tailOffset;
        }

        @Override
        public int processTail(@NotNull Editor editor, int tailOffset) {
            if (editor == null) {
                2.$$$reportNull$$$0(2);
            }
            return tailOffset;
        }

        public String toString() {
            return "NONE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "navigator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/TailTypes$2";
            objectArray[2] = "processTail";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final ModNavigatorTailType SEMICOLON = new CharTailType(';');
    private static final ModNavigatorTailType SPACE = new CharTailType(' ');
    private static final ModNavigatorTailType INSERT_SPACE = new CharTailType(' ', false);
    private static final ModNavigatorTailType HUMBLE_SPACE_BEFORE_WORD = new CharTailType(' ', false){

        @Override
        public int processTail(@NotNull Project project, @NotNull ModNavigator navigator, int tailOffset) {
            char ch;
            CharSequence text;
            if (project == null) {
                3.$$$reportNull$$$0(0);
            }
            if (navigator == null) {
                3.$$$reportNull$$$0(1);
            }
            if ((text = navigator.getDocument().getCharsSequence()).length() > tailOffset + 1 && text.charAt(tailOffset) == ' ' && ((ch = text.charAt(tailOffset + 1)) == '@' || Character.isLetter(ch))) {
                return tailOffset;
            }
            return super.processTail(project, navigator, tailOffset);
        }

        @Override
        public String toString() {
            return "HUMBLE_SPACE_BEFORE_WORD";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "navigator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/TailTypes$3";
            objectArray[2] = "processTail";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final ModNavigatorTailType DOT = new CharTailType('.');
    private static final ModNavigatorTailType CASE_COLON = new CharTailType(':');
    private static final ModNavigatorTailType EQUALS = new CharTailType('=');
    private static final ModNavigatorTailType COND_EXPR_COLON = new ModNavigatorTailType(){

        @Override
        public int processTail(@NotNull Project project, @NotNull ModNavigator editor, int tailOffset) {
            if (project == null) {
                4.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                4.$$$reportNull$$$0(1);
            }
            Document document = editor.getDocument();
            int textLength = document.getTextLength();
            CharSequence chars = document.getCharsSequence();
            int afterWhitespace = CharArrayUtil.shiftForward((CharSequence)chars, (int)tailOffset, (String)" \n\t");
            if (afterWhitespace < textLength && chars.charAt(afterWhitespace) == ':') {
                return 4.moveCaret(editor, tailOffset, afterWhitespace - tailOffset + 1);
            }
            document.insertString(tailOffset, (CharSequence)" : ");
            return 4.moveCaret(editor, tailOffset, 3);
        }

        public String toString() {
            return "COND_EXPR_COLON";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/TailTypes$4";
            objectArray[2] = "processTail";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private TailTypes() {
    }

    public static TailType unknownType() {
        return UNKNOWN;
    }

    public static TailType noneType() {
        return NONE;
    }

    public static TailType semicolonType() {
        return SEMICOLON;
    }

    public static TailType spaceType() {
        return SPACE;
    }

    public static TailType insertSpaceType() {
        return INSERT_SPACE;
    }

    public static TailType humbleSpaceBeforeWordType() {
        return HUMBLE_SPACE_BEFORE_WORD;
    }

    public static TailType dotType() {
        return DOT;
    }

    public static TailType caseColonType() {
        return CASE_COLON;
    }

    public static TailType equalsType() {
        return EQUALS;
    }

    public static TailType conditionalExpressionColonType() {
        return COND_EXPR_COLON;
    }

    public static TailType charType(char aChar) {
        return new CharTailType(aChar);
    }

    public static TailType charType(char aChar, boolean overwrite) {
        return new CharTailType(aChar, overwrite);
    }
}

