/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModUpdateFileText;
import com.intellij.modcompletion.ModCompletionItem;
import com.intellij.modcompletion.ModCompletionItemPresentation;
import com.intellij.openapi.diagnostic.ReportingClassSubstitutor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.MarkupText;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@NotNullByDefault
@ApiStatus.Internal
public final class CompletionItemLookupElement
extends LookupElement
implements ReportingClassSubstitutor {
    private final ModCompletionItem item;
    @Nullable
    private volatile ModCommand myCachedCommand;

    CompletionItemLookupElement(ModCompletionItem item) {
        this.item = item;
    }

    public ModCompletionItem item() {
        return this.item;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    public ModCommand computeCommand(ActionContext actionContext, ModCompletionItem.InsertionContext insertionContext) {
        void actionContext2;
        void insertionContext2;
        ThreadingAssertions.softAssertReadAccess();
        if (!insertionContext2.equals(ModCompletionItem.DEFAULT_INSERTION_CONTEXT)) {
            return this.item.perform((ActionContext)actionContext2, (ModCompletionItem.InsertionContext)insertionContext2);
        }
        ModCommand command = this.getCachedCommand((ActionContext)actionContext2, (ModCompletionItem.InsertionContext)insertionContext2);
        if (command != null) {
            return command;
        }
        this.myCachedCommand = command = this.item.perform((ActionContext)actionContext2, (ModCompletionItem.InsertionContext)insertionContext2);
        return command;
    }

    @Nullable
    public ModCommand getCachedCommand(ActionContext actionContext, ModCompletionItem.InsertionContext insertionContext) {
        ModCommand command = this.myCachedCommand;
        if (command == null || !insertionContext.equals(ModCompletionItem.DEFAULT_INSERTION_CONTEXT)) {
            return null;
        }
        if (CompletionItemLookupElement.isApplicableToContext(command, actionContext)) {
            return command;
        }
        return null;
    }

    public Class<?> getSubstitutedClass() {
        return this.item.getClass();
    }

    private static boolean isApplicableToContext(ModCommand command, ActionContext context) {
        VirtualFile file = context.file().getVirtualFile();
        Object text = context.file().getFileDocument().getText();
        TextRange selection = context.selection();
        if (!selection.isEmpty()) {
            text = ((String)text).substring(0, selection.getStartOffset()) + ((String)text).substring(selection.getEndOffset());
        }
        for (ModCommand subCommand : command.unpack()) {
            ModUpdateFileText update;
            if (!(subCommand instanceof ModUpdateFileText) || !(update = (ModUpdateFileText)subCommand).file().equals(file)) continue;
            return update.oldText().equals(text);
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.item.isValid();
    }

    @Override
    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return this.item.autoCompletionPolicy();
    }

    @Override
    public String getLookupString() {
        return this.item.mainLookupString();
    }

    @Override
    public @Unmodifiable Set<String> getAllLookupStrings() {
        Set<String> strings = this.item.additionalLookupStrings();
        return strings.isEmpty() ? Set.of(this.item.mainLookupString()) : Stream.concat(Stream.of(this.item.mainLookupString()), strings.stream()).collect(Collectors.toSet());
    }

    @Override
    public Object getObject() {
        return this.item.contextObject();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        ModCompletionItemPresentation itemPresentation = this.item.presentation();
        MarkupText mainText = itemPresentation.mainText();
        List fragments = mainText.fragments();
        String tailText = "";
        if (!fragments.isEmpty()) {
            MarkupText.Fragment last = (MarkupText.Fragment)fragments.getLast();
            if (last.kind() == MarkupText.Kind.GRAYED) {
                tailText = last.text();
                fragments = fragments.subList(0, fragments.size() - 1);
            }
            presentation.setItemText(StringUtil.join((Collection)fragments, MarkupText.Fragment::text, (String)""));
            MarkupText.Fragment onlyFragment = (MarkupText.Fragment)ContainerUtil.getOnlyItem((Collection)fragments);
            if (onlyFragment != null) {
                switch (onlyFragment.kind()) {
                    case STRONG: {
                        presentation.setItemTextBold(true);
                        break;
                    }
                    case EMPHASIZED: {
                        presentation.setItemTextItalic(true);
                    }
                }
            }
        }
        presentation.setIcon(itemPresentation.mainIcon());
        presentation.setTailText(tailText + " (MC)", true);
        presentation.setTypeText(itemPresentation.detailText().toText(), itemPresentation.detailIcon());
    }

    @Override
    public boolean requiresCommittedDocuments() {
        return false;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        throw new UnsupportedOperationException("Should not be called: unwrap the element via item() method and process it as a ModCommand");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof CompletionItemLookupElement)) return false;
        CompletionItemLookupElement element = (CompletionItemLookupElement)((Object)o);
        if (!this.item.equals(element.item)) return false;
        return true;
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    @Override
    public String toString() {
        return "Adapter for " + String.valueOf(this.item);
    }
}

