/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.CacheAvoidingVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.TransientVirtualFileImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
@VisibleForTesting
public final class CacheAvoidingVirtualFileWrapper
extends VirtualFile
implements VirtualFileWithId,
CacheAvoidingVirtualFile {
    private static final Logger LOG = Logger.getInstance(CacheAvoidingVirtualFileWrapper.class);
    private final NewVirtualFile wrappedFile;

    @VisibleForTesting
    public CacheAvoidingVirtualFileWrapper(@NotNull NewVirtualFile wrappedFile) {
        if (wrappedFile == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(0);
        }
        if (wrappedFile instanceof CacheAvoidingVirtualFile) {
            throw new IllegalArgumentException(String.valueOf((Object)wrappedFile) + " is cache-avoiding itself -- double-wrapping is not allowed");
        }
        this.wrappedFile = wrappedFile;
    }

    @NotNull
    public VirtualFile asCacheable() {
        NewVirtualFile newVirtualFile = this.wrappedFile;
        if (newVirtualFile == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(1);
        }
        return newVirtualFile;
    }

    public boolean isCached() {
        return true;
    }

    public VirtualFile getParent() {
        return this.wrappedFile.getParent();
    }

    public VirtualFile[] getChildren() {
        if (!this.wrappedFile.isDirectory()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        if (this.wrappedFile.allChildrenCached()) {
            return (VirtualFile[])StreamSupport.stream(this.wrappedFile.iterInDbChildren().spliterator(), false).map(child -> ((NewVirtualFile)((Object)child)).asCacheAvoiding()).toArray(VirtualFile[]::new);
        }
        NewVirtualFileSystem fileSystem = this.wrappedFile.getFileSystem();
        String[] childNames = fileSystem.list(this.wrappedFile);
        VirtualFile[] children = new VirtualFile[childNames.length];
        for (int i = 0; i < childNames.length; ++i) {
            String childName = childNames[i];
            children[i] = this.findChild(childName);
        }
        return children;
    }

    public VirtualFile findChild(@NotNull String childName) {
        if (childName == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(2);
        }
        NewVirtualFileSystem fileSystem = this.wrappedFile.getFileSystem();
        NewVirtualFile child = this.wrappedFile.findChildIfCached(childName);
        if (child != null) {
            return new CacheAvoidingVirtualFileWrapper(child);
        }
        return new TransientVirtualFileImpl(childName, this.getPath() + "/" + childName, fileSystem, this);
    }

    @Nullable
    public VirtualFile findFileByRelativePath(@NotNull String relPath) {
        if (relPath == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(3);
        }
        NewVirtualFileSystem fileSystem = this.wrappedFile.getFileSystem();
        return fileSystem.findFileByPathWithoutCaching(this.getPath() + "/" + relPath);
    }

    @NotNull
    public VirtualFile findOrCreateChildData(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = this.findChild(name);
        if (virtualFile == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    public int getId() {
        return this.wrappedFile.getId();
    }

    @NotNull
    public String getName() {
        String string = this.wrappedFile.getName();
        if (string == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.wrappedFile.getPath();
        if (string == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        NewVirtualFileSystem newVirtualFileSystem = this.wrappedFile.getFileSystem();
        if (newVirtualFileSystem == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(8);
        }
        return newVirtualFileSystem;
    }

    public boolean isWritable() {
        return this.wrappedFile.isWritable();
    }

    public boolean isDirectory() {
        return this.wrappedFile.isDirectory();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.wrappedFile.getFileType();
        if (fileType == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(9);
        }
        return fileType;
    }

    public boolean isValid() {
        return this.wrappedFile.isValid();
    }

    public boolean exists() {
        return this.wrappedFile.exists();
    }

    public boolean is(@NotNull VFileProperty property) {
        if (property == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(10);
        }
        return this.wrappedFile.is(property);
    }

    public void setWritable(boolean writable) throws IOException {
        this.wrappedFile.setWritable(writable);
    }

    @Nullable
    public VirtualFile getCanonicalFile() {
        return this.wrappedFile.getCanonicalFile();
    }

    @Nullable
    public String getCanonicalPath() {
        return this.wrappedFile.getCanonicalPath();
    }

    @NotNull
    public String getNameWithoutExtension() {
        String string = this.wrappedFile.getNameWithoutExtension();
        if (string == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public String getExtension() {
        return this.wrappedFile.getExtension();
    }

    @NotNull
    public String getPresentableUrl() {
        String string = this.wrappedFile.getPresentableUrl();
        if (string == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = this.wrappedFile.getUrl();
        if (string == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public Path toNioPath() {
        Path path = this.wrappedFile.toNioPath();
        if (path == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(14);
        }
        return path;
    }

    @NotNull
    public CharSequence getNameSequence() {
        CharSequence charSequence = this.wrappedFile.getNameSequence();
        if (charSequence == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(15);
        }
        return charSequence;
    }

    public boolean isCaseSensitive() {
        return this.wrappedFile.isCaseSensitive();
    }

    @NotNull
    public String getPresentableName() {
        String string = this.wrappedFile.getPresentableName();
        if (string == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean isRecursiveOrCircularSymlink() {
        return this.wrappedFile.isRecursiveOrCircularSymlink();
    }

    public <T> T computeWithPreloadedContentHint(byte @NotNull [] preloadedContentHint, @NotNull Supplier<? extends T> computable) {
        if (computable == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(17);
        }
        if (preloadedContentHint == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(18);
        }
        return (T)this.wrappedFile.computeWithPreloadedContentHint(preloadedContentHint, computable);
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(19);
        }
        VirtualFile virtualFile = this.wrappedFile.createChildData(requestor, name);
        if (virtualFile == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(20);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(21);
        }
        VirtualFile virtualFile = this.wrappedFile.createChildDirectory(requestor, name);
        if (virtualFile == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(22);
        }
        return virtualFile;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.wrappedFile.getInputStream();
        if (inputStream == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(23);
        }
        return inputStream;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = this.wrappedFile.getOutputStream(requestor, newModificationStamp, newTimeStamp);
        if (outputStream == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(24);
        }
        return outputStream;
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        byte[] byArray = this.wrappedFile.contentsToByteArray();
        if (byArray == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(25);
        }
        return byArray;
    }

    public long getTimeStamp() {
        return this.wrappedFile.getTimeStamp();
    }

    public long getLength() {
        return this.wrappedFile.getLength();
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.wrappedFile.getCharset();
        if (charset == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(26);
        }
        return charset;
    }

    public void setCharset(Charset charset) {
        this.wrappedFile.setCharset(charset);
    }

    public void setCharset(Charset charset, @Nullable Runnable whenChanged) {
        this.wrappedFile.setCharset(charset, whenChanged);
    }

    public void setCharset(Charset charset, @Nullable Runnable whenChanged, boolean fireEventsWhenChanged) {
        this.wrappedFile.setCharset(charset, whenChanged, fireEventsWhenChanged);
    }

    protected void storeCharset(Charset charset) {
        super.storeCharset(charset);
    }

    @NotNull
    public VirtualFile copy(Object requestor, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (newParent == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(27);
        }
        if (copyName == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(28);
        }
        VirtualFile virtualFile = this.wrappedFile.copy(requestor, newParent, copyName);
        if (virtualFile == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(29);
        }
        return virtualFile;
    }

    public void rename(Object requestor, @NotNull String newName) throws IOException {
        if (newName == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(30);
        }
        this.wrappedFile.rename(requestor, newName);
    }

    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(31);
        }
        this.wrappedFile.move(requestor, newParent);
    }

    public void delete(Object requestor) throws IOException {
        this.wrappedFile.delete(requestor);
    }

    public void setBOM(byte @Nullable [] BOM) {
        this.wrappedFile.setBOM(BOM);
    }

    public byte @Nullable [] getBOM() {
        return this.wrappedFile.getBOM();
    }

    public boolean isCharsetSet() {
        return this.wrappedFile.isCharsetSet();
    }

    public long getModificationCount() {
        return this.wrappedFile.getModificationCount();
    }

    public long getModificationStamp() {
        return this.wrappedFile.getModificationStamp();
    }

    public boolean isInLocalFileSystem() {
        return this.wrappedFile.isInLocalFileSystem();
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long l) throws IOException {
        void newTimeStamp;
        if (content == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(32);
        }
        this.wrappedFile.setBinaryContent(content, newModificationStamp, (long)newTimeStamp);
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long newTimeStamp, Object object) throws IOException {
        void requestor;
        if (content == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(33);
        }
        this.wrappedFile.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor);
    }

    public byte @NotNull [] contentsToByteArray(boolean cacheContent) throws IOException {
        byte[] byArray = this.wrappedFile.contentsToByteArray(cacheContent);
        if (byArray == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(34);
        }
        return byArray;
    }

    @Nullable
    public String getDetectedLineSeparator() {
        return this.wrappedFile.getDetectedLineSeparator();
    }

    public void setDetectedLineSeparator(@Nullable String separator) {
        this.wrappedFile.setDetectedLineSeparator(separator);
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        this.wrappedFile.refresh(asynchronous, recursive, postRunnable);
    }

    public void refresh(boolean asynchronous, boolean recursive) {
        this.wrappedFile.refresh(asynchronous, recursive);
    }

    public void copyUserDataTo(@NotNull UserDataHolderBase other) {
        if (other == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(35);
        }
        CacheAvoidingVirtualFileWrapper.logUnsupportedIfNeeded(TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS);
        this.wrappedFile.copyUserDataTo(other);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(36);
        }
        CacheAvoidingVirtualFileWrapper.logUnsupportedIfNeeded(TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS);
        return (T)this.wrappedFile.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(37);
        }
        CacheAvoidingVirtualFileWrapper.logUnsupportedIfNeeded(TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS);
        this.wrappedFile.putUserData(key, value);
    }

    public <T> @UnknownNullability T getCopyableUserData(@NotNull Key<T> key) {
        if (key == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(38);
        }
        CacheAvoidingVirtualFileWrapper.logUnsupportedIfNeeded(TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS);
        return (T)this.wrappedFile.getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(39);
        }
        CacheAvoidingVirtualFileWrapper.logUnsupportedIfNeeded(TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS);
        this.wrappedFile.putCopyableUserData(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(40);
        }
        CacheAvoidingVirtualFileWrapper.logUnsupportedIfNeeded(TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS);
        return this.wrappedFile.replace(key, oldValue, newValue);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(41);
        }
        if (value == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(42);
        }
        CacheAvoidingVirtualFileWrapper.logUnsupportedIfNeeded(TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS);
        Object object = this.wrappedFile.putUserDataIfAbsent(key, value);
        if (object == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(43);
        }
        return (T)object;
    }

    public void copyCopyableDataTo(@NotNull UserDataHolderBase clone) {
        if (clone == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(44);
        }
        CacheAvoidingVirtualFileWrapper.logUnsupportedIfNeeded(TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS);
        this.wrappedFile.copyCopyableDataTo(clone);
    }

    public boolean isCopyableDataEqual(@NotNull UserDataHolderBase other) {
        if (other == null) {
            CacheAvoidingVirtualFileWrapper.$$$reportNull$$$0(45);
        }
        CacheAvoidingVirtualFileWrapper.logUnsupportedIfNeeded(TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS);
        return this.wrappedFile.isCopyableDataEqual(other);
    }

    public boolean isUserDataEmpty() {
        CacheAvoidingVirtualFileWrapper.logUnsupportedIfNeeded(TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS);
        return this.wrappedFile.isUserDataEmpty();
    }

    private static void logUnsupportedIfNeeded(boolean logUserDataHolderAccess) {
        if (logUserDataHolderAccess) {
            LOG.error("CacheAvoidingVirtualFileWrapper does NOT really support UserDataHolder (see javadoc)");
        }
    }

    public int hashCode() {
        return ((Object)((Object)this.wrappedFile)).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualFileWithId)) {
            return false;
        }
        return ((VirtualFileWithId)o).getId() == this.wrappedFile.getId();
    }

    public String toString() {
        return "CacheAvoidingVirtualFileWrapper[" + String.valueOf((Object)this.wrappedFile) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 20, 22, 23, 24, 25, 26, 29, 34, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappedFile";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 34: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/CacheAvoidingVirtualFileWrapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 4: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preloadedContentHint";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/CacheAvoidingVirtualFileWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asCacheable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateChildData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toNioPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSequence";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 25: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 34: 
            case 43: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByRelativePath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateChildData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeWithPreloadedContentHint";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "copyUserDataTo";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getCopyableUserData";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "putCopyableUserData";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "copyCopyableDataTo";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isCopyableDataEqual";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 20, 22, 23, 24, 25, 26, 29, 34, 43 -> new IllegalStateException(string);
        };
    }
}

