/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileNavigator;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class VfsImplUtil {
    private static final Logger LOG = Logger.getInstance(VfsImplUtil.class);
    private static final AtomicBoolean ourSubscribed = new AtomicBoolean(false);
    private static final Object ourLock = new Object();
    private static final Map<String, Pair<ArchiveFileSystem, ArchiveHandler>> ourHandlerCache = CollectionFactory.createFilePathMap();
    private static final Map<String, Set<String>> ourDominatorsMap = CollectionFactory.createFilePathMap();

    private VfsImplUtil() {
        throw new AssertionError((Object)"Static utils class: not for instantiation");
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static NewVirtualFile findFileByPath(@NotNull NewVirtualFileSystem fileSystem, @NotNull String path) {
        if (fileSystem == null) {
            VfsImplUtil.$$$reportNull$$$0(0);
        }
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(1);
        }
        return NewVirtualFileSystem.findFileByPath(fileSystem, path);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static NewVirtualFile findFileByPathIfCached(@NotNull NewVirtualFileSystem fileSystem, @NotNull String path) {
        if (fileSystem == null) {
            VfsImplUtil.$$$reportNull$$$0(2);
        }
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(3);
        }
        return NewVirtualFileSystem.findFileByPathIfCached(fileSystem, path);
    }

    @Nullable
    public static NewVirtualFile refreshAndFindFileByPath(final @NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(4);
        }
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(5);
        }
        FileNavigator<NewVirtualFile> navigator = new FileNavigator<NewVirtualFile>(){

            @Override
            @Nullable
            public NewVirtualFile parentOf(@NotNull NewVirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file.is(VFileProperty.SYMLINK)) {
                    return file.getParent();
                }
                String canonicalPath = file.getCanonicalPath();
                return canonicalPath != null ? VfsImplUtil.refreshAndFindFileByPath(vfs, canonicalPath) : null;
            }

            @Override
            @Nullable
            public NewVirtualFile childOf(@NotNull NewVirtualFile parent, @NotNull String childName) {
                if (parent == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (childName == null) {
                    1.$$$reportNull$$$0(2);
                }
                return parent.refreshAndFindChild(childName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "childName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/VfsImplUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "parentOf";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childOf";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        FileNavigator.NavigateResult<NewVirtualFile> result = FileNavigator.navigate(vfs, path, navigator);
        return result.resolvedFileOr(null);
    }

    @ApiStatus.Experimental
    public static void refreshAndFindFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path, @NotNull Consumer<? super @Nullable NewVirtualFile> consumer) {
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(6);
        }
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            VfsImplUtil.$$$reportNull$$$0(8);
        }
        ProcessIOExecutorService.INSTANCE.execute(() -> {
            Pair<NewVirtualFile, Iterable<String>> rootAndPath = NewVirtualFileSystem.extractRootAndPathSegments(vfs, path);
            if (rootAndPath == null) {
                consumer.accept(null);
            } else {
                NewVirtualFile root = (NewVirtualFile)((Object)((Object)rootAndPath.first));
                Iterable pathSegments = (Iterable)rootAndPath.second;
                VfsImplUtil.refreshAndFindFileByPath(root, pathSegments.iterator(), FileNavigator.POSIX_LIGHT, consumer);
            }
        });
    }

    private static void refreshAndFindFileByPath(@Nullable NewVirtualFile root, @NotNull Iterator<String> pathSegments, @NotNull FileNavigator<NewVirtualFile> navigator, @NotNull Consumer<? super @Nullable NewVirtualFile> consumer) {
        if (pathSegments == null) {
            VfsImplUtil.$$$reportNull$$$0(9);
        }
        if (navigator == null) {
            VfsImplUtil.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            VfsImplUtil.$$$reportNull$$$0(11);
        }
        if (root == null || !pathSegments.hasNext()) {
            consumer.accept(root);
            return;
        }
        String pathSegment = pathSegments.next();
        if (pathSegment.isEmpty() || ".".equals(pathSegment)) {
            VfsImplUtil.refreshAndFindFileByPath(root, pathSegments, navigator, consumer);
            return;
        }
        if ("..".equals(pathSegment)) {
            NewVirtualFile parent = navigator.parentOf(root);
            if (parent == null) {
                consumer.accept(null);
            } else {
                String rootPathCanonicalized = parent.getPath();
                VfsImplUtil.refreshAndFindFileByPath(root.getFileSystem(), rootPathCanonicalized, canonicalFile -> VfsImplUtil.refreshAndFindFileByPath(canonicalFile, pathSegments, navigator, consumer));
            }
        } else {
            NewVirtualFile child = navigator.childOf(root, pathSegment);
            if (child != null) {
                VfsImplUtil.refreshAndFindFileByPath(child, pathSegments, navigator, consumer);
            } else {
                root.refresh(true, false, () -> ProcessIOExecutorService.INSTANCE.execute(() -> VfsImplUtil.refreshAndFindFileByPath(navigator.childOf(root, pathSegment), pathSegments, navigator, consumer)));
            }
        }
    }

    public static void refresh(@NotNull NewVirtualFileSystem vfs, boolean asynchronous) {
        VirtualFile[] roots;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(12);
        }
        if ((roots = ManagingFS.getInstance().getRoots(vfs)).length > 0) {
            RefreshQueue.getInstance().refresh(asynchronous, true, null, roots);
        }
    }

    public static void forceSyncRefresh(@NotNull VirtualFile file) {
        if (file == null) {
            VfsImplUtil.$$$reportNull$$$0(13);
        }
        VFileContentChangeEvent event = new VFileContentChangeEvent(VFileEvent.REFRESH_REQUESTOR, file, file.getModificationStamp(), -1L);
        RefreshQueue.getInstance().processEvents(false, List.of(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T extends ArchiveHandler> T getHandler(@NotNull ArchiveFileSystem vfs, @NotNull VirtualFile entryFile, @NotNull Function<? super String, ? extends T> producer) {
        ArchiveHandler handler;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(14);
        }
        if (entryFile == null) {
            VfsImplUtil.$$$reportNull$$$0(15);
        }
        if (producer == null) {
            VfsImplUtil.$$$reportNull$$$0(16);
        }
        String localPath = ArchiveFileSystem.getLocalPath(vfs, VfsUtilCore.getRootFile((VirtualFile)entryFile).getPath());
        VfsImplUtil.checkSubscription();
        Object object = ourLock;
        synchronized (object) {
            Pair record = ourHandlerCache.get(localPath);
            if (record == null) {
                handler = (ArchiveHandler)producer.fun((Object)localPath);
                record = Pair.create((Object)vfs, (Object)handler);
                ourHandlerCache.put(localPath, (Pair<ArchiveFileSystem, ArchiveHandler>)record);
                VfsImplUtil.forEachDirectoryComponent(localPath, containingDirectoryPath -> {
                    Set handlers = ourDominatorsMap.computeIfAbsent((String)containingDirectoryPath, __ -> new HashSet());
                    handlers.add(localPath);
                });
            }
            handler = (ArchiveHandler)record.second;
        }
        ArchiveHandler archiveHandler = handler;
        if (archiveHandler == null) {
            VfsImplUtil.$$$reportNull$$$0(17);
        }
        return (T)archiveHandler;
    }

    private static void forEachDirectoryComponent(@NotNull String rootPath, @NotNull Consumer<? super String> consumer) {
        if (rootPath == null) {
            VfsImplUtil.$$$reportNull$$$0(18);
        }
        if (consumer == null) {
            VfsImplUtil.$$$reportNull$$$0(19);
        }
        int index = rootPath.lastIndexOf(47);
        while (index > 0) {
            String containingDirectoryPath = rootPath.substring(0, index);
            consumer.accept(containingDirectoryPath);
            index = rootPath.lastIndexOf(47, index - 1);
        }
    }

    private static void checkSubscription() {
        if (ourSubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDisposed()) {
            return;
        }
        MessageBusConnection connection = app.getMessageBus().connect((Disposable)app);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                InvalidationState state = null;
                Object object = ourLock;
                synchronized (object) {
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
                        VFileContentChangeEvent contentChangeEvent = (VFileContentChangeEvent)vFileEvent;
                        String path = contentChangeEvent.getPath();
                        VirtualFile file = contentChangeEvent.getFile();
                        if (!file.isDirectory()) {
                            state = VfsImplUtil.invalidate(state, path);
                            continue;
                        }
                        ArrayList affectedPaths = (ArrayList)((Object)ourDominatorsMap.get(path));
                        if (affectedPaths == null) continue;
                        affectedPaths = new ArrayList(affectedPaths);
                        for (String affectedPath : affectedPaths) {
                            state = VfsImplUtil.invalidate(state, affectedPath);
                        }
                    }
                }
                if (state != null) {
                    state.scheduleRefresh();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/newvfs/VfsImplUtil$2", "after"));
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                Object object = ourLock;
                synchronized (object) {
                    ourHandlerCache.clear();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/vfs/newvfs/VfsImplUtil$3", "pluginUnloaded"));
            }
        });
    }

    @Nullable
    private static InvalidationState invalidate(@Nullable InvalidationState state, @NotNull String path) {
        Pair<ArchiveFileSystem, ArchiveHandler> fsAndHandler;
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(20);
        }
        if ((fsAndHandler = ourHandlerCache.remove(path)) != null) {
            ((ArchiveHandler)fsAndHandler.second).clearCaches();
            VfsImplUtil.forEachDirectoryComponent(path, containingDirectoryPath -> {
                Set<String> handlers = ourDominatorsMap.get(containingDirectoryPath);
                if (handlers != null && handlers.remove(path) && handlers.isEmpty()) {
                    ourDominatorsMap.remove(containingDirectoryPath);
                }
            });
            if (state == null) {
                state = new InvalidationState();
            }
            state.registerPathToRefresh(path, (ArchiveFileSystem)fsAndHandler.first);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void releaseHandler(@NotNull String localPath) {
        if (localPath == null) {
            VfsImplUtil.$$$reportNull$$$0(21);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        Object object = ourLock;
        synchronized (object) {
            InvalidationState state = VfsImplUtil.invalidate(null, localPath);
            if (state == null) {
                throw new IllegalArgumentException(localPath + " not in " + String.valueOf(ourHandlerCache.keySet()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<VFileEvent> getJarInvalidationEvents(@NotNull VFileEvent event, @NotNull List<? super Runnable> outApplyActions) {
        String[] jarPaths;
        String path;
        VFilePropertyChangeEvent propertyChangeEvent;
        if (event == null) {
            VfsImplUtil.$$$reportNull$$$0(22);
        }
        if (outApplyActions == null) {
            VfsImplUtil.$$$reportNull$$$0(23);
        }
        if (!(event instanceof VFileDeleteEvent || event instanceof VFileMoveEvent || event instanceof VFilePropertyChangeEvent && "name".equals((propertyChangeEvent = (VFilePropertyChangeEvent)event).getPropertyName()))) {
            List<VFileEvent> list = Collections.emptyList();
            if (list == null) {
                VfsImplUtil.$$$reportNull$$$0(24);
            }
            return list;
        }
        if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent propertyChangeEvent2 = (VFilePropertyChangeEvent)event;
            path = propertyChangeEvent2.getOldPath();
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent moveEvent = (VFileMoveEvent)event;
            path = moveEvent.getOldPath();
        } else {
            path = event.getPath();
        }
        VirtualFile file = event.getFile();
        VirtualFileSystem entryFileSystem = file.getFileSystem();
        VirtualFile local = null;
        if (entryFileSystem instanceof ArchiveFileSystem) {
            local = ((ArchiveFileSystem)entryFileSystem).getLocalByEntry(file);
            path = local == null ? ArchiveFileSystem.getLocalPath((ArchiveFileSystem)entryFileSystem, path) : local.getPath();
        }
        Object object = ourLock;
        synchronized (object) {
            Set<String> handlers = ourDominatorsMap.get(path);
            jarPaths = handlers == null ? new String[]{path} : ArrayUtil.toStringArray(handlers);
        }
        ArrayList<VFileEvent> events = new ArrayList<VFileEvent>(jarPaths.length);
        for (String jarPath : jarPaths) {
            Pair<ArchiveFileSystem, ArchiveHandler> handlerPair = ourHandlerCache.get(jarPath);
            if (handlerPair == null) continue;
            if (entryFileSystem instanceof LocalFileSystem) {
                ArchiveFileSystem fileSystem = (ArchiveFileSystem)handlerPair.first;
                NewVirtualFile root = ManagingFS.getInstance().findRoot(ArchiveFileSystem.composeRootPath(fileSystem, jarPath), fileSystem);
                if (root == null) continue;
                VFileDeleteEvent jarDeleteEvent = new VFileDeleteEvent(event.getRequestor(), (VirtualFile)root);
                Runnable runnable = () -> {
                    Pair<ArchiveFileSystem, ArchiveHandler> pair = ourHandlerCache.remove(jarPath);
                    if (pair != null) {
                        ((ArchiveHandler)pair.second).clearCaches();
                        Object object = ourLock;
                        synchronized (object) {
                            VfsImplUtil.forEachDirectoryComponent(jarPath, containingDirectoryPath -> {
                                Set<String> handlers = ourDominatorsMap.get(containingDirectoryPath);
                                if (handlers != null && handlers.remove(jarPath) && handlers.isEmpty()) {
                                    ourDominatorsMap.remove(containingDirectoryPath);
                                }
                            });
                        }
                    }
                };
                events.add((VFileEvent)jarDeleteEvent);
                outApplyActions.add(runnable);
                continue;
            }
            if (local == null) continue;
            VFileDeleteEvent localJarDeleteEvent = file.getParent() == null ? new VFileDeleteEvent(event.getRequestor(), local) : new VFileContentChangeEvent(event.getRequestor(), local, local.getModificationStamp(), local.getModificationStamp());
            events.add((VFileEvent)localJarDeleteEvent);
        }
        ArrayList<VFileEvent> arrayList = events;
        if (arrayList == null) {
            VfsImplUtil.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
            case 8: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathSegments";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 17: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/VfsImplUtil";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outApplyActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/VfsImplUtil";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarInvalidationEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forceSyncRefresh";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 17: 
            case 24: 
            case 25: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forEachDirectoryComponent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "releaseHandler";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getJarInvalidationEvents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 24, 25 -> new IllegalStateException(string);
        };
    }

    private static final class InvalidationState {
        private Set<Pair<String, ArchiveFileSystem>> myRootsToRefresh;

        private InvalidationState() {
        }

        private void registerPathToRefresh(@NotNull String path, @NotNull ArchiveFileSystem vfs) {
            if (path == null) {
                InvalidationState.$$$reportNull$$$0(0);
            }
            if (vfs == null) {
                InvalidationState.$$$reportNull$$$0(1);
            }
            if (this.myRootsToRefresh == null) {
                this.myRootsToRefresh = new HashSet<Pair<String, ArchiveFileSystem>>();
            }
            this.myRootsToRefresh.add((Pair<String, ArchiveFileSystem>)Pair.create((Object)path, (Object)vfs));
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void scheduleRefresh() {
            if (this.myRootsToRefresh != null) {
                @NotNull List rootsToRefresh = ContainerUtil.mapNotNull(this.myRootsToRefresh, pathAndFs -> ManagingFS.getInstance().findRoot(ArchiveFileSystem.composeRootPath((ArchiveFileSystem)pathAndFs.second, (String)pathAndFs.first), (NewVirtualFileSystem)((Object)((Object)pathAndFs.second))));
                for (NewVirtualFile root : rootsToRefresh) {
                    root.markDirtyRecursively();
                }
                boolean synchronous = ApplicationManager.getApplication().isUnitTestMode();
                RefreshQueue.getInstance().refresh(!synchronous, true, null, rootsToRefresh);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vfs";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/newvfs/VfsImplUtil$InvalidationState";
            objectArray[2] = "registerPathToRefresh";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

