/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveRenameUsageInfo
extends UsageInfo
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(MoveRenameUsageInfo.class);
    private SmartPsiElementPointer<?> myReferencedElementPointer;
    private PsiElement myReferencedElement;
    private PsiReference myReference;
    private RangeMarker myReferenceRangeMarker;

    public MoveRenameUsageInfo(@NotNull PsiReference reference, PsiElement referencedElement) {
        if (reference == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(0);
        }
        this(reference.getElement(), reference, referencedElement);
    }

    public MoveRenameUsageInfo(@NotNull PsiElement element, PsiReference reference, PsiElement referencedElement) {
        if (element == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(1);
        }
        super(element);
        this.init(element, reference, referencedElement);
    }

    public MoveRenameUsageInfo(@NotNull PsiElement element, PsiReference reference, int startOffset, int endOffset, PsiElement referencedElement, boolean nonCodeUsage) {
        if (element == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(2);
        }
        super(element, startOffset, endOffset, nonCodeUsage);
        this.init(element, reference, referencedElement);
    }

    private void init(@NotNull PsiElement element, @Nullable PsiReference reference, @Nullable PsiElement referencedElement) {
        TextRange textRange;
        if (element == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(3);
        }
        Project project = element.getProject();
        this.myReferencedElement = referencedElement;
        if (referencedElement != null) {
            this.myReferencedElementPointer = SmartPointerManager.getInstance((Project)referencedElement.getProject()).createSmartPsiElementPointer(referencedElement);
        }
        if (reference == null) {
            reference = element.getReference();
        }
        PsiFile containingFile = element.getContainingFile();
        if (reference == null && (textRange = element.getTextRange()) != null) {
            reference = containingFile.findReferenceAt(textRange.getStartOffset());
        }
        this.myReference = reference;
        if (reference != null) {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(containingFile);
            if (document != null) {
                TextRange rangeInElement;
                int elementStart = reference.getElement().getTextRange().getStartOffset();
                LOG.assertTrue(elementStart + (rangeInElement = reference.getRangeInElement()).getEndOffset() <= document.getTextLength(), (Object)reference);
                this.myReferenceRangeMarker = document.createRangeMarker(elementStart + rangeInElement.getStartOffset(), elementStart + rangeInElement.getEndOffset());
            }
            this.myDynamicUsage = reference.resolve() == null;
        }
    }

    @Nullable
    public PsiElement getUpToDateReferencedElement() {
        return this.myReferencedElementPointer == null ? null : this.myReferencedElementPointer.getElement();
    }

    @Nullable
    public PsiElement getReferencedElement() {
        return this.myReferencedElement;
    }

    @Nullable
    public PsiReference getReference() {
        PsiElement element;
        if (this.myReference != null && (element = this.myReference.getElement()).isValid()) {
            if (this.myReferenceRangeMarker == null) {
                return this.myReference;
            }
            PsiReference reference = this.checkReferenceRange(element, (Function<? super Integer, ? extends PsiReference>)((Function)start -> this.myReference));
            if (reference != null) {
                return reference;
            }
        }
        if (this.myReferenceRangeMarker == null) {
            return null;
        }
        element = this.getElement();
        if (element == null || !element.isValid()) {
            return null;
        }
        return this.checkReferenceRange(element, (Function<? super Integer, ? extends PsiReference>)((Function)start -> element.findReferenceAt(start.intValue())));
    }

    @NotNull
    protected Segment getReferenceRangeToCheck(@NotNull PsiElement element) {
        if (element == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(4);
        }
        RangeMarker rangeMarker = this.myReferenceRangeMarker;
        if (rangeMarker == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(5);
        }
        return rangeMarker;
    }

    @Nullable
    private PsiReference checkReferenceRange(@NotNull PsiElement element, @NotNull Function<? super Integer, ? extends PsiReference> fn) {
        if (element == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(6);
        }
        if (fn == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(7);
        }
        Segment rangeToCheck = this.getReferenceRangeToCheck(element);
        int start = rangeToCheck.getStartOffset() - element.getTextRange().getStartOffset();
        int end = rangeToCheck.getEndOffset() - element.getTextRange().getStartOffset();
        PsiReference reference = (PsiReference)fn.fun((Object)start);
        if (reference == null) {
            return null;
        }
        TextRange rangeInElement = reference.getRangeInElement();
        if (rangeInElement.getStartOffset() != start || rangeInElement.getEndOffset() != end) {
            return null;
        }
        return reference;
    }

    private static boolean isPackage(PsiElement element) {
        return element instanceof PsiDirectoryContainer && element.getContainingFile() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/MoveRenameUsageInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/MoveRenameUsageInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceRangeToCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceRangeToCheck";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

