/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.AesEncryptionSupport;
import com.intellij.credentialStore.windows.WindowsCryptUtils;
import java.security.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/credentialStore/WindowsCrypt32EncryptionSupport;", "Lcom/intellij/credentialStore/AesEncryptionSupport;", "key", "Ljava/security/Key;", "<init>", "(Ljava/security/Key;)V", "encrypt", "", "Lorg/jetbrains/annotations/NotNull;", "data", "decrypt", "intellij.platform.credentialStore.impl"})
final class WindowsCrypt32EncryptionSupport
extends AesEncryptionSupport {
    public WindowsCrypt32EncryptionSupport(@NotNull Key key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(key);
    }

    @Override
    @NotNull
    public byte[] encrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] byArray = WindowsCryptUtils.protect(super.encrypt(data));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"protect(...)");
        return byArray;
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] byArray = WindowsCryptUtils.unprotect(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"unprotect(...)");
        return super.decrypt(byArray);
    }
}

