/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.kdbx.KdbxEntry;
import com.intellij.credentialStore.kdbx.KdbxGroup;
import com.intellij.credentialStore.kdbx.KdbxGroupKt;
import com.intellij.credentialStore.kdbx.KdbxHeader;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KeePassCredentials;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.credentialStore.kdbx.ProtectedXmlWriter;
import com.intellij.credentialStore.kdbx.StringProtectedByStreamCipher;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Base64;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "", "rootElement", "Lorg/jdom/Element;", "<init>", "(Lorg/jdom/Element;)V", "secureStringCipher", "Lkotlin/Lazy;", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "value", "", "isDirty", "()Z", "setDirty$intellij_platform_credentialStore_impl", "(Z)V", "rootGroup", "Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "getRootGroup$intellij_platform_credentialStore_impl", "()Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "protectValue", "Lcom/intellij/credentialStore/kdbx/StringProtectedByStreamCipher;", "", "protectValue$intellij_platform_credentialStore_impl", "save", "", "credentials", "Lcom/intellij/credentialStore/kdbx/KeePassCredentials;", "outputStream", "Ljava/io/OutputStream;", "secureRandom", "Ljava/security/SecureRandom;", "save$intellij_platform_credentialStore_impl", "createEntry", "Lcom/intellij/credentialStore/kdbx/KdbxEntry;", "title", "", "createEntry$intellij_platform_credentialStore_impl", "intellij.platform.credentialStore.impl"})
public final class KeePassDatabase {
    @NotNull
    private final Element rootElement;
    @NotNull
    private Lazy<? extends SkippingStreamCipher> secureStringCipher;
    private volatile boolean isDirty;
    @NotNull
    private final KdbxGroup rootGroup;

    public KeePassDatabase(@NotNull Element rootElement) {
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        this.rootElement = rootElement;
        this.secureStringCipher = LazyKt.lazy(KeePassDatabase::secureStringCipher$lambda$0);
        Element rootElement2 = this.rootElement.getOrCreateChild("Root");
        Element groupElement = rootElement2.getChild("Group");
        if (groupElement == null) {
            this.rootGroup = KdbxGroupKt.createGroup(this, null);
            this.rootGroup.setName("Root");
            rootElement2.addContent(this.rootGroup.getElement$intellij_platform_credentialStore_impl());
        } else {
            this.rootGroup = new KdbxGroup(groupElement, this, null);
        }
    }

    public /* synthetic */ KeePassDatabase(Element element, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            element = KeePassDatabaseKt.access$createEmptyDatabase();
        }
        this(element);
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty$intellij_platform_credentialStore_impl(boolean bl) {
        this.isDirty = bl;
    }

    @NotNull
    public final KdbxGroup getRootGroup$intellij_platform_credentialStore_impl() {
        return this.rootGroup;
    }

    @NotNull
    public final StringProtectedByStreamCipher protectValue$intellij_platform_credentialStore_impl(@NotNull CharSequence value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new StringProtectedByStreamCipher(value, (SkippingStreamCipher)this.secureStringCipher.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void save$intellij_platform_credentialStore_impl(@NotNull KeePassCredentials credentials, @NotNull OutputStream outputStream, @NotNull SecureRandom secureRandom) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)secureRandom, (String)"secureRandom");
        KdbxHeader kdbxHeader = new KdbxHeader(secureRandom);
        kdbxHeader.writeKdbxHeader(outputStream);
        Element metaElement = this.rootElement.getOrCreateChild("Meta");
        metaElement.getOrCreateChild("HeaderHash").setText(Base64.getEncoder().encodeToString(kdbxHeader.getHeaderHash()));
        metaElement.getOrCreateChild("MemoryProtection").getOrCreateChild("ProtectPassword").setText("True");
        Closeable closeable = kdbxHeader.createEncryptedStream(credentials.getKey(), outputStream);
        Object object = Charsets.UTF_8;
        closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        object = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)closeable;
            boolean bl = false;
            new ProtectedXmlWriter(KdbxKt.createChaCha20StreamCipher(kdbxHeader.getProtectedStreamKey())).printElement(it, this.rootElement, 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        if (this.secureStringCipher.isInitialized()) {
            KeePassDatabaseKt.access$initCipherRandomly(secureRandom, (SkippingStreamCipher)this.secureStringCipher.getValue());
        } else {
            this.secureStringCipher = LazyKt.lazyOf((Object)KeePassDatabaseKt.access$createRandomlyInitializedChaCha7539Engine(secureRandom));
        }
        this.isDirty = false;
    }

    @NotNull
    public final KdbxEntry createEntry$intellij_platform_credentialStore_impl(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Element element = new Element("Entry");
        KeePassDatabaseKt.ensureElements(element, KeePassDatabaseKt.access$getMandatoryEntryElements$p());
        KdbxEntry result = new KdbxEntry(element, this, null);
        result.setTitle(title);
        return result;
    }

    private static final SkippingStreamCipher secureStringCipher$lambda$0() {
        return KeePassDatabaseKt.access$createRandomlyInitializedChaCha7539Engine(CredentialStoreKt.createSecureRandom());
    }

    public KeePassDatabase() {
        this(null, 1, null);
    }
}

