/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.impl;

import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.platform.diagnostic.telemetry.impl.TraceReporter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/DefaultTraceReporter;", "Lcom/intellij/platform/diagnostic/telemetry/impl/TraceReporter;", "reportScheduleTimeForRoot", "", "<init>", "(Z)V", "start", "Lcom/intellij/diagnostic/ActivityImpl;", "coroutineName", "", "scheduleTime", "", "parentActivity", "end", "", "activity", "lastSuspensionTime", "setEndAndAdd", "intellij.platform.diagnostic.telemetry.impl"})
@ApiStatus.Internal
public class DefaultTraceReporter
implements TraceReporter {
    private final boolean reportScheduleTimeForRoot;

    public DefaultTraceReporter(boolean reportScheduleTimeForRoot) {
        this.reportScheduleTimeForRoot = reportScheduleTimeForRoot;
    }

    @Override
    @NotNull
    public ActivityImpl start(@NotNull String coroutineName, long scheduleTime, @Nullable ActivityImpl parentActivity) {
        Intrinsics.checkNotNullParameter((Object)coroutineName, (String)"coroutineName");
        long start2 = System.nanoTime();
        if (this.reportScheduleTimeForRoot || parentActivity != null) {
            this.setEndAndAdd(new ActivityImpl(coroutineName + ": scheduled", scheduleTime, parentActivity), start2);
        }
        return new ActivityImpl(coroutineName, start2, parentActivity);
    }

    @Override
    public void end(@NotNull ActivityImpl activity, @NotNull String coroutineName, long end, long lastSuspensionTime) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)coroutineName, (String)"coroutineName");
        if (lastSuspensionTime != -1L) {
            this.setEndAndAdd(new ActivityImpl(coroutineName + ": completing", lastSuspensionTime, activity), end);
        }
        this.setEndAndAdd(activity, end);
    }

    public void setEndAndAdd(@NotNull ActivityImpl activity, long end) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.setEnd(end);
        StartUpMeasurer.addActivity((ActivityImpl)activity);
    }
}

