/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.impl.DirectoryIndexImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlManagerImpl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.PathUtil;
import com.intellij.util.Query;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.TreeNodeProcessingResult;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.EmptyWorkspaceFileIndexData;
import com.intellij.workspaceModel.core.fileIndex.impl.InfiniteProcessingReportingKt;
import com.intellij.workspaceModel.core.fileIndex.impl.MultipleWorkspaceFileSets;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetKind;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImplKt;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \\2\u00020\u00012\u00020\u0002:\u0001\\B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J:\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0016\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\u0004\u0012\u00020\u00160(H\u0016JB\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0016\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\u0004\u0012\u00020\u00160(2\u0006\u0010*\u001a\u00020+H\u0002JJ\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0016\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\u0004\u0012\u00020\u00160(2\u0006\u0010/\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+H\u0002JB\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u0016H\u0016JF\u00107\u001a\b\u0012\u0004\u0012\u000201082\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u0016H\u0016J\u000e\u00109\u001a\u00020:H\u0096@\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020:H\u0016J\b\u0010=\u001a\u00020>H\u0002Jb\u0010?\u001a\n\u0012\u0004\u0012\u0002H@\u0018\u00010)\"\b\b\u0000\u0010@*\u00020A2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u00162\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u0002H@0CH\u0016Jf\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H@0)08\"\b\b\u0000\u0010@*\u00020A2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u00162\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u0002H@0CH\u0016J@\u0010E\u001a\u00020F2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u0016H\u0016J^\u0010G\u001a\b\u0012\u0004\u0012\u0002HI0H\"\b\b\u0000\u0010I*\u00020J2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HI0C2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u0016H\u0016JF\u0010G\u001a\b\u0012\u0004\u0012\u00020J0H2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u0016H\u0016J\u0012\u0010L\u001a\u0004\u0018\u00010J2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020:2\u0006\u0010P\u001a\u00020QH\u0017J\u0012\u0010R\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020\u0018H\u0016J\u001e\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00180T2\u0006\u0010U\u001a\u00020 2\u0006\u0010V\u001a\u00020\u0016H\u0016J\u001e\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00180T2\u0006\u0010U\u001a\u00020 2\u0006\u0010W\u001a\u00020XH\u0016J\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00180T2\u0006\u0010U\u001a\u00020 H\u0016J\b\u0010Z\u001a\u00020\nH\u0002J\b\u0010[\u001a\u00020:H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006]"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexEx;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "indexData", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;)V", "indexDataReference", "Ljava/util/concurrent/atomic/AtomicReference;", "throttledLogger", "Lcom/intellij/openapi/diagnostic/ThrottledLogger;", "newValue", "getIndexData", "()Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;", "setIndexData", "(Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;)V", "isInWorkspace", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInContent", "isIndexable", "getContentFileSetRoot", "honorExclusion", "isUrlInContent", "Lcom/intellij/util/ThreeState;", "url", "", "processContentUnderDirectory", "fileOrDir", "processor", "Lcom/intellij/openapi/roots/ContentIteratorEx;", "customFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "fileSetFilter", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetWithCustomData;", "numberOfExcludedParentDirectories", "", "processContentFilesUnderExcludedDirectory", "Lcom/intellij/openapi/vfs/VirtualFileVisitor$Result;", "dir", "rootDir", "findFileSet", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSet;", "includeContentSets", "includeContentNonIndexableSets", "includeExternalSets", "includeExternalSourceSets", "includeCustomKindSets", "findFileSets", "", "initialize", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeBlocking", "doInitializeBlocking", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl;", "findFileSetWithCustomData", "D", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "customDataClass", "Ljava/lang/Class;", "findFileSetsWithCustomData", "getFileInfo", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileInternalInfo;", "findContainingEntities", "", "E", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityClass", "resolveEntity", "fileSet", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSet;", "visitFileSets", "visitor", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetVisitor;", "getPackageName", "getDirectoriesByPackageName", "Lcom/intellij/util/Query;", "packageName", "includeLibrarySources", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getFilesByPackageName", "getMainIndexData", "reset", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nWorkspaceFileIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceFileIndexImpl.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,430:1\n23#2:431\n23#2:452\n1#3:432\n1#3:449\n774#4:433\n865#4,2:434\n774#4:436\n865#4,2:437\n1617#4,9:439\n1869#4:448\n1870#4:450\n1626#4:451\n*S KotlinDebug\n*F\n+ 1 WorkspaceFileIndexImpl.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexImpl\n*L\n45#1:431\n413#1:452\n372#1:449\n343#1:433\n343#1:434,2\n366#1:436\n366#1:437,2\n372#1:439,9\n372#1:448\n372#1:450\n372#1:451\n*E\n"})
public final class WorkspaceFileIndexImpl
implements WorkspaceFileIndexEx,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<WorkspaceFileIndexData> indexDataReference;
    @NotNull
    private final ThrottledLogger throttledLogger;
    @NotNull
    private static final ExtensionPointName<WorkspaceFileIndexContributor<?>> EP_NAME = new ExtensionPointName("com.intellij.workspaceModel.fileIndexContributor");

    public WorkspaceFileIndexImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.indexDataReference = new AtomicReference<EmptyWorkspaceFileIndexData>(EmptyWorkspaceFileIndexData.Companion.getNOT_INITIALIZED());
        WorkspaceFileIndexImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(WorkspaceFileIndexImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.throttledLogger = new ThrottledLogger(logger, TimeUnit.MINUTES.toMillis(1L));
        this.project = project;
        SimpleMessageBusConnection simpleMessageBusConnection = project.getMessageBus().simpleConnect();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        simpleMessageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                if (DirectoryIndexImpl.shouldResetOnEvents(events)) {
                    boolean bl;
                    block5: {
                        this.getIndexData().clearPackageDirectoryCache();
                        Iterable $this$any$iv = events;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                VFileEvent p0 = (VFileEvent)element$iv;
                                boolean bl2 = false;
                                if (!DirectoryIndexImpl.isIgnoredFileCreated(p0)) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.getIndexData().resetFileCache();
                    }
                }
            }
        });
        LowMemoryWatcher.register(() -> WorkspaceFileIndexImpl._init_$lambda$0(this), (Disposable)((Disposable)project));
        EP_NAME.addChangeListener(coroutineScope, () -> WorkspaceFileIndexImpl._init_$lambda$1(this));
    }

    @NonInjectable
    public WorkspaceFileIndexImpl(@NotNull Project project, @NotNull WorkspaceFileIndexData indexData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indexData, (String)"indexData");
        this.indexDataReference = new AtomicReference<EmptyWorkspaceFileIndexData>(EmptyWorkspaceFileIndexData.Companion.getNOT_INITIALIZED());
        WorkspaceFileIndexImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(WorkspaceFileIndexImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.throttledLogger = new ThrottledLogger(logger, TimeUnit.MINUTES.toMillis(1L));
        this.project = project;
        this.indexDataReference.set(indexData);
    }

    @Override
    @NotNull
    public WorkspaceFileIndexData getIndexData() {
        WorkspaceFileIndexData workspaceFileIndexData = this.indexDataReference.get();
        Intrinsics.checkNotNullExpressionValue((Object)workspaceFileIndexData, (String)"get(...)");
        return workspaceFileIndexData;
    }

    public void setIndexData(@NotNull WorkspaceFileIndexData newValue) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        WorkspaceFileIndexData current = this.indexDataReference.get();
        if (this.indexDataReference.compareAndSet(current, newValue)) {
            Intrinsics.checkNotNull((Object)current);
            WorkspaceFileIndexImpl._set_indexData_$dispose(current);
        } else {
            WorkspaceFileIndexImpl._set_indexData_$dispose(newValue);
        }
    }

    @Override
    public boolean isInWorkspace(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.findFileSet(file, true, true, true, true, true, true) != null;
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.findFileSet(file, true, true, true, false, false, false) != null;
    }

    @Override
    public boolean isIndexable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.findFileSet(file, true, true, false, true, true, true) != null;
    }

    @Override
    @Nullable
    public VirtualFile getContentFileSetRoot(@NotNull VirtualFile file, boolean honorExclusion) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        WorkspaceFileSet workspaceFileSet = this.findFileSet(file, honorExclusion, true, true, false, false, false);
        return workspaceFileSet != null ? workspaceFileSet.getRoot() : null;
    }

    @Override
    @NotNull
    public ThreeState isUrlInContent(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String currentUrl = url;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager fileManager = virtualFileManager;
        VirtualFileUrlManager urlManager = WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager();
        while (((CharSequence)currentUrl).length() > 0) {
            VirtualFile file = fileManager.findFileByUrl(currentUrl);
            if (file != null) {
                return ThreeState.Companion.fromBoolean(this.isInContent(file));
            }
            VirtualFileUrl virtualFileUrl = urlManager.findByUrl(currentUrl);
            if (virtualFileUrl != null) {
                Set<NonExistingFileSetKind> kinds = this.getMainIndexData().getNonExistentFileSetKinds(virtualFileUrl);
                if (kinds.contains((Object)NonExistingFileSetKind.EXCLUDED_FROM_CONTENT)) {
                    return ThreeState.NO;
                }
                if (kinds.contains((Object)NonExistingFileSetKind.EXCLUDED_OTHER)) {
                    return ThreeState.UNSURE;
                }
                if (kinds.contains((Object)NonExistingFileSetKind.INCLUDED_CONTENT)) {
                    return ThreeState.YES;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getParentPath((String)currentUrl), (String)"getParentPath(...)");
        }
        return ThreeState.NO;
    }

    @Override
    public boolean processContentUnderDirectory(@NotNull VirtualFile fileOrDir, @NotNull ContentIteratorEx processor, @Nullable VirtualFileFilter customFilter, @NotNull Function1<? super WorkspaceFileSetWithCustomData<?>, Boolean> fileSetFilter) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter(fileSetFilter, (String)"fileSetFilter");
        return this.processContentUnderDirectory(fileOrDir, processor, customFilter, fileSetFilter, 0);
    }

    private final boolean processContentUnderDirectory(VirtualFile fileOrDir, ContentIteratorEx processor, VirtualFileFilter customFilter, Function1<? super WorkspaceFileSetWithCustomData<?>, Boolean> fileSetFilter, int numberOfExcludedParentDirectories) {
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VirtualFileVisitor<Void> visitor2 = new VirtualFileVisitor<Void>(this, processor, customFilter, fileSetFilter, fileOrDir, numberOfExcludedParentDirectories, optionArray){
            final /* synthetic */ WorkspaceFileIndexImpl this$0;
            final /* synthetic */ ContentIteratorEx $processor;
            final /* synthetic */ VirtualFileFilter $customFilter;
            final /* synthetic */ Function1<WorkspaceFileSetWithCustomData<?>, Boolean> $fileSetFilter;
            final /* synthetic */ VirtualFile $fileOrDir;
            final /* synthetic */ int $numberOfExcludedParentDirectories;
            {
                this.this$0 = $receiver;
                this.$processor = $processor;
                this.$customFilter = $customFilter;
                this.$fileSetFilter = $fileSetFilter;
                this.$fileOrDir = $fileOrDir;
                this.$numberOfExcludedParentDirectories = $numberOfExcludedParentDirectories;
                super($super_call_param$1);
            }

            public VirtualFileVisitor.Result visitFileEx(VirtualFile file) {
                VirtualFileVisitor.Result result;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                WorkspaceFileInternalInfo fileInfo = (WorkspaceFileInternalInfo)ApplicationManager.getApplication().runReadAction(() -> processContentUnderDirectory.visitor.1.visitFileEx$lambda$0(this.this$0, file));
                if (file.isDirectory() && fileInfo instanceof WorkspaceFileInternalInfo.NonWorkspace) {
                    return switch (processContentUnderDirectory.visitor.WhenMappings.$EnumSwitchMapping$0[((WorkspaceFileInternalInfo.NonWorkspace)fileInfo).ordinal()]) {
                        case 1, 2 -> WorkspaceFileIndexImpl.access$processContentFilesUnderExcludedDirectory(this.this$0, file, this.$processor, this.$customFilter, this.$fileSetFilter, this.$fileOrDir, this.$numberOfExcludedParentDirectories);
                        case 3, 4 -> {
                            VirtualFileVisitor.Result var5_3 = VirtualFileVisitor.SKIP_CHILDREN;
                            Intrinsics.checkNotNull((Object)var5_3);
                            yield var5_3;
                        }
                        default -> throw new NoWhenBranchMatchedException();
                    };
                }
                Boolean accepted = (Boolean)ApplicationManager.getApplication().runReadAction(() -> processContentUnderDirectory.visitor.1.visitFileEx$lambda$1(fileInfo, this.$fileSetFilter, this.$customFilter, file));
                TreeNodeProcessingResult treeNodeProcessingResult = accepted != false ? this.$processor.processFileEx(file) : TreeNodeProcessingResult.CONTINUE;
                Intrinsics.checkNotNull((Object)treeNodeProcessingResult);
                TreeNodeProcessingResult status = treeNodeProcessingResult;
                switch (processContentUnderDirectory.visitor.WhenMappings.$EnumSwitchMapping$1[status.ordinal()]) {
                    case 1: {
                        VirtualFileVisitor.Result result2 = VirtualFileVisitor.CONTINUE;
                        result = result2;
                        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"CONTINUE");
                        break;
                    }
                    case 2: {
                        VirtualFileVisitor.Result result3 = VirtualFileVisitor.SKIP_CHILDREN;
                        result = result3;
                        Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"SKIP_CHILDREN");
                        break;
                    }
                    case 3: {
                        VirtualFileVisitor.Result result4 = VirtualFileVisitor.skipTo((VirtualFile)file.getParent());
                        result = result4;
                        Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"skipTo(...)");
                        break;
                    }
                    case 4: {
                        VirtualFileVisitor.Result result5 = VirtualFileVisitor.skipTo((VirtualFile)this.$fileOrDir);
                        result = result5;
                        Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"skipTo(...)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return result;
            }

            private static final WorkspaceFileInternalInfo visitFileEx$lambda$0(WorkspaceFileIndexImpl this$0, VirtualFile $file) {
                return this$0.getFileInfo($file, true, true, true, false, false, false);
            }

            private static final Boolean visitFileEx$lambda$1(WorkspaceFileInternalInfo $fileInfo, Function1 $fileSetFilter, VirtualFileFilter $customFilter, VirtualFile $file) {
                return $fileInfo.findFileSet($fileSetFilter) != null && ($customFilter == null || $customFilter.accept($file));
            }
        };
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively((VirtualFile)fileOrDir, (VirtualFileVisitor)((VirtualFileVisitor)visitor2));
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"visitChildrenRecursively(...)");
        VirtualFileVisitor.Result result2 = result;
        return !Intrinsics.areEqual((Object)result2.skipToParent, (Object)fileOrDir);
    }

    private final VirtualFileVisitor.Result processContentFilesUnderExcludedDirectory(VirtualFile dir, ContentIteratorEx processor, VirtualFileFilter customFilter, Function1<? super WorkspaceFileSetWithCustomData<?>, Boolean> fileSetFilter, VirtualFile rootDir, int numberOfExcludedParentDirectories) {
        VirtualFileVisitor.Result result;
        if (numberOfExcludedParentDirectories > 5) {
            InfiniteProcessingReportingKt.reportInfiniteRecursion(dir, this);
            VirtualFileVisitor.Result result2 = VirtualFileVisitor.SKIP_CHILDREN;
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"SKIP_CHILDREN");
            return result2;
        }
        VirtualFileUrlManager virtualFileUrlManager = WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager();
        Intrinsics.checkNotNull((Object)virtualFileUrlManager, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlManagerImpl");
        VirtualFileUrlManagerImpl virtualFileUrlManager2 = (VirtualFileUrlManagerImpl)virtualFileUrlManager;
        String string = dir.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        VirtualFileUrl virtualFileUrl = virtualFileUrlManager2.findByUrl(string);
        if (virtualFileUrl == null) {
            VirtualFileVisitor.Result result3 = VirtualFileVisitor.SKIP_CHILDREN;
            Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"SKIP_CHILDREN");
            return result3;
        }
        VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
        boolean processed = virtualFileUrlManager2.processChildrenRecursively(virtualFileUrl2, arg_0 -> WorkspaceFileIndexImpl.processContentFilesUnderExcludedDirectory$lambda$0(this, processor, customFilter, fileSetFilter, numberOfExcludedParentDirectories, arg_0));
        if (!processed) {
            VirtualFileVisitor.Result result4 = VirtualFileVisitor.skipTo((VirtualFile)rootDir);
            Intrinsics.checkNotNull((Object)result4);
            result = result4;
        } else {
            VirtualFileVisitor.Result result5 = VirtualFileVisitor.SKIP_CHILDREN;
            result = result5;
            Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"SKIP_CHILDREN");
        }
        return result;
    }

    @Override
    @Nullable
    public WorkspaceFileSet findFileSet(@NotNull VirtualFile file, boolean honorExclusion, boolean includeContentSets, boolean includeContentNonIndexableSets, boolean includeExternalSets, boolean includeExternalSourceSets, boolean includeCustomKindSets) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        WorkspaceFileInternalInfo info = this.getFileInfo(file, honorExclusion, includeContentSets, includeContentNonIndexableSets, includeExternalSets, includeExternalSourceSets, includeCustomKindSets);
        return info instanceof WorkspaceFileSetImpl ? (WorkspaceFileSet)((Object)info) : (info instanceof MultipleWorkspaceFileSets ? (WorkspaceFileSet)((MultipleWorkspaceFileSets)info).find(null) : null);
    }

    @Override
    @NotNull
    public List<WorkspaceFileSet> findFileSets(@NotNull VirtualFile file, boolean honorExclusion, boolean includeContentSets, boolean includeContentNonIndexableSets, boolean includeExternalSets, boolean includeExternalSourceSets, boolean includeCustomKindSets) {
        WorkspaceFileInternalInfo info;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        WorkspaceFileInternalInfo workspaceFileInternalInfo = info = this.getFileInfo(file, honorExclusion, includeContentSets, includeContentNonIndexableSets, includeExternalSets, includeExternalSourceSets, includeCustomKindSets);
        return workspaceFileInternalInfo instanceof WorkspaceFileSetImpl ? CollectionsKt.listOf((Object)info) : (workspaceFileInternalInfo instanceof MultipleWorkspaceFileSets ? ((MultipleWorkspaceFileSets)info).getFileSets() : CollectionsKt.emptyList());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object initialize(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof initialize.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ WorkspaceFileIndexImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.initialize((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(this.getIndexData() instanceof EmptyWorkspaceFileIndexData)) ** GOTO lbl29
                contributors = WorkspaceFileIndexImpl.EP_NAME.getExtensionList();
                var3_7 = this.project;
                var4_8 = this;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)contributors);
                $continuation.L$1 = var4_8;
                $continuation.label = 1;
                v0 = WorkspaceFileIndexDataImplKt.initWorkspaceFileIndexData(var3_7, contributors, (Continuation<? super WorkspaceFileIndexDataImpl>)$continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                var4_8 = (WorkspaceFileIndexImpl)$continuation.L$1;
                contributors = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                var4_8.setIndexData((WorkspaceFileIndexData)v0);
lbl29:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void initializeBlocking() {
        if (this.getIndexData() instanceof EmptyWorkspaceFileIndexData) {
            this.setIndexData(this.doInitializeBlocking());
        }
    }

    private final WorkspaceFileIndexDataImpl doInitializeBlocking() {
        List list = EP_NAME.getExtensionList();
        return WorkspaceFileIndexDataImplKt.blockingInitWorkspaceFileIndexData(this.project, (Disposable)this, list);
    }

    @Override
    @Nullable
    public <D extends WorkspaceFileSetData> WorkspaceFileSetWithCustomData<D> findFileSetWithCustomData(@NotNull VirtualFile file, boolean honorExclusion, boolean includeContentSets, boolean includeContentNonIndexableSets, boolean includeExternalSets, boolean includeExternalSourceSets, boolean includeCustomKindSets, @NotNull Class<? extends D> customDataClass) {
        WorkspaceFileSetWithCustomData result;
        WorkspaceFileSetWithCustomData workspaceFileSetWithCustomData;
        WorkspaceFileSetWithCustomData workspaceFileSetWithCustomData2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(customDataClass, (String)"customDataClass");
        WorkspaceFileInternalInfo info = this.getFileInfo(file, honorExclusion, includeContentSets, includeContentNonIndexableSets, includeExternalSets, includeExternalSourceSets, includeCustomKindSets);
        if (info instanceof WorkspaceFileSetWithCustomData) {
            WorkspaceFileInternalInfo workspaceFileInternalInfo;
            WorkspaceFileInternalInfo it = workspaceFileInternalInfo = info;
            boolean bl = false;
            workspaceFileSetWithCustomData2 = (WorkspaceFileSetWithCustomData)((Object)(customDataClass.isInstance(((WorkspaceFileSetWithCustomData)((Object)it)).getData()) ? workspaceFileInternalInfo : null));
        } else {
            workspaceFileSetWithCustomData2 = info instanceof MultipleWorkspaceFileSets ? ((MultipleWorkspaceFileSets)info).find(customDataClass) : null;
        }
        if ((workspaceFileSetWithCustomData = (result = workspaceFileSetWithCustomData2)) == null) {
            workspaceFileSetWithCustomData = null;
        }
        return workspaceFileSetWithCustomData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <D extends WorkspaceFileSetData> List<WorkspaceFileSetWithCustomData<D>> findFileSetsWithCustomData(@NotNull VirtualFile file, boolean honorExclusion, boolean includeContentSets, boolean includeContentNonIndexableSets, boolean includeExternalSets, boolean includeExternalSourceSets, boolean includeCustomKindSets, @NotNull Class<? extends D> customDataClass) {
        List list;
        WorkspaceFileInternalInfo info;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(customDataClass, (String)"customDataClass");
        WorkspaceFileInternalInfo workspaceFileInternalInfo = info = this.getFileInfo(file, honorExclusion, includeContentSets, includeContentNonIndexableSets, includeExternalSets, includeExternalSourceSets, includeCustomKindSets);
        if (workspaceFileInternalInfo instanceof WorkspaceFileSetWithCustomData) {
            WorkspaceFileInternalInfo workspaceFileInternalInfo2;
            WorkspaceFileInternalInfo it = workspaceFileInternalInfo2 = info;
            boolean bl = false;
            list = CollectionsKt.listOfNotNull((Object)(customDataClass.isInstance(((WorkspaceFileSetWithCustomData)((Object)it)).getData()) ? workspaceFileInternalInfo2 : null));
        } else if (workspaceFileInternalInfo instanceof MultipleWorkspaceFileSets) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ((MultipleWorkspaceFileSets)info).getFileSets();
            boolean $i$f$filter = false;
            Iterable bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                WorkspaceFileSetWithCustomData it = (WorkspaceFileSetWithCustomData)element$iv$iv;
                boolean bl2 = false;
                if (!customDataClass.isInstance(it.getData())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List result = list;
        Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type kotlin.collections.List<com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData<D of com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexImpl.findFileSetsWithCustomData>>");
        return result;
    }

    @Override
    @NotNull
    public WorkspaceFileInternalInfo getFileInfo(@NotNull VirtualFile file, boolean honorExclusion, boolean includeContentSets, boolean includeContentNonIndexableSets, boolean includeExternalSets, boolean includeExternalSourceSets, boolean includeCustomKindSets) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFileWindow virtualFileWindow = file instanceof VirtualFileWindow ? (VirtualFileWindow)file : null;
        if (virtualFileWindow == null || (virtualFileWindow = virtualFileWindow.getDelegate()) == null) {
            virtualFileWindow = file;
        }
        VirtualFile virtualFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)virtualFileWindow);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOriginFileIfBacked(...)");
        VirtualFile unwrappedFile = virtualFile;
        return this.getMainIndexData().getFileInfo(unwrappedFile, honorExclusion, includeContentSets, includeContentNonIndexableSets, includeExternalSets, includeExternalSourceSets, includeCustomKindSets);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <E extends WorkspaceEntity> Collection<E> findContainingEntities(@NotNull VirtualFile file, @NotNull Class<E> entityClass, boolean honorExclusion, boolean includeContentSets, boolean includeContentNonIndexableSets, boolean includeExternalSets, boolean includeExternalSourceSets, boolean includeCustomKindSets) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Collection<WorkspaceEntity> allEntities = this.findContainingEntities(file, honorExclusion, includeContentSets, includeContentNonIndexableSets, includeExternalSets, includeExternalSourceSets, includeCustomKindSets);
        Iterable $this$filter$iv = allEntities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WorkspaceEntity entity = (WorkspaceEntity)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)entity.getEntityInterface(), entityClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<WorkspaceEntity> findContainingEntities(@NotNull VirtualFile file, boolean honorExclusion, boolean includeContentSets, boolean includeContentNonIndexableSets, boolean includeExternalSets, boolean includeExternalSourceSets, boolean includeCustomKindSets) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        WorkspaceFileInternalInfo fileInfo = this.getFileInfo(file, honorExclusion, includeContentSets, includeContentNonIndexableSets, includeExternalSets, includeExternalSourceSets, includeCustomKindSets);
        if (fileInfo instanceof WorkspaceFileSetImpl) {
            collection = CollectionsKt.listOfNotNull((Object)this.resolveEntity((StoredFileSet)((Object)fileInfo)));
        } else if (fileInfo instanceof MultipleWorkspaceFileSets) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = ((MultipleWorkspaceFileSets)fileInfo).getFileSets();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                WorkspaceEntity workspaceEntity;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                WorkspaceFileSetWithCustomData fileSet = (WorkspaceFileSetWithCustomData)element$iv$iv;
                boolean bl2 = false;
                if ((fileSet instanceof StoredFileSet ? (StoredFileSet)((Object)fileSet) : null) != null) {
                    StoredFileSet it;
                    it = it;
                    boolean bl3 = false;
                    workspaceEntity = this.resolveEntity(it);
                } else {
                    workspaceEntity = null;
                }
                if (workspaceEntity == null) continue;
                WorkspaceEntity it$iv$iv = workspaceEntity;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            if (fileInfo instanceof WorkspaceFileInternalInfo.NonWorkspace) {
                return CollectionsKt.emptyList();
            }
            throw new NoWhenBranchMatchedException();
        }
        return collection;
    }

    private final WorkspaceEntity resolveEntity(StoredFileSet fileSet) {
        if (fileSet.getEntityStorageKind() != EntityStorageKind.MAIN) {
            return null;
        }
        return fileSet.getEntityPointer().resolve((EntityStorage)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot());
    }

    @Override
    @RequiresReadLock
    public void visitFileSets(@NotNull WorkspaceFileSetVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        this.getMainIndexData().visitFileSets(visitor2);
    }

    @Override
    @Nullable
    public String getPackageName(@NotNull VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return this.getMainIndexData().getPackageName(fileOrDir);
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.getMainIndexData().getDirectoriesByPackageName(packageName, includeLibrarySources);
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.getDirectoriesByPackageName(packageName, true).filtering(arg_0 -> WorkspaceFileIndexImpl.getDirectoriesByPackageName$lambda$1(arg_0 -> WorkspaceFileIndexImpl.getDirectoriesByPackageName$lambda$0(scope, arg_0), arg_0));
    }

    @Override
    @NotNull
    public Query<VirtualFile> getFilesByPackageName(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.getMainIndexData().getFilesByPackageName(packageName);
    }

    private final WorkspaceFileIndexData getMainIndexData() {
        WorkspaceFileIndexData indexData = this.getIndexData();
        WorkspaceFileIndexData workspaceFileIndexData = indexData;
        if (Intrinsics.areEqual((Object)workspaceFileIndexData, (Object)EmptyWorkspaceFileIndexData.Companion.getNOT_INITIALIZED())) {
            if (this.project.isDefault()) {
                this.throttledLogger.warn("WorkspaceFileIndex must not be queried for the default project", new Throwable());
            } else {
                WorkspaceFileIndexImpl $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(WorkspaceFileIndexImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("WorkspaceFileIndex is not initialized yet, empty data is returned. Activities which use the project configuration must be postponed until the project is fully loaded.It is possible to check Project.isInitialized to verify that the project is fully loaded.");
            }
        } else if (Intrinsics.areEqual((Object)workspaceFileIndexData, (Object)EmptyWorkspaceFileIndexData.Companion.getRESET())) {
            WorkspaceFileIndexDataImpl workspaceFileIndexDataImpl;
            WorkspaceFileIndexDataImpl it = workspaceFileIndexDataImpl = this.doInitializeBlocking();
            boolean bl = false;
            this.setIndexData(it);
            return workspaceFileIndexDataImpl;
        }
        return indexData;
    }

    @Override
    public void reset() {
        this.setIndexData(EmptyWorkspaceFileIndexData.Companion.getRESET());
    }

    private static final void _init_$lambda$0(WorkspaceFileIndexImpl this$0) {
        this$0.getIndexData().onLowMemory();
    }

    private static final void _init_$lambda$1(WorkspaceFileIndexImpl this$0) {
        this$0.setIndexData(EmptyWorkspaceFileIndexData.Companion.getRESET());
    }

    private static final void _set_indexData_$dispose(WorkspaceFileIndexData $this$_set_indexData__u24dispose) {
        if ($this$_set_indexData__u24dispose instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)$this$_set_indexData__u24dispose));
        }
    }

    private static final TreeNodeProcessingResult processContentFilesUnderExcludedDirectory$lambda$0(WorkspaceFileIndexImpl this$0, ContentIteratorEx $processor, VirtualFileFilter $customFilter, Function1 $fileSetFilter, int $numberOfExcludedParentDirectories, VirtualFileUrl childUrl) {
        Intrinsics.checkNotNullParameter((Object)childUrl, (String)"childUrl");
        VirtualFile virtualFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)childUrl);
        if (virtualFile == null) {
            return TreeNodeProcessingResult.SKIP_CHILDREN;
        }
        VirtualFile childFile = virtualFile;
        boolean isChildInIndexableContent = (Boolean)ActionsKt.runReadAction(() -> WorkspaceFileIndexImpl.processContentFilesUnderExcludedDirectory$lambda$0$0(this$0, childFile));
        return isChildInIndexableContent ? (this$0.processContentUnderDirectory(childFile, $processor, $customFilter, $fileSetFilter, $numberOfExcludedParentDirectories + 1) ? TreeNodeProcessingResult.SKIP_CHILDREN : TreeNodeProcessingResult.STOP) : TreeNodeProcessingResult.CONTINUE;
    }

    private static final boolean processContentFilesUnderExcludedDirectory$lambda$0$0(WorkspaceFileIndexImpl this$0, VirtualFile $childFile) {
        return this$0.findFileSet($childFile, true, true, false, false, false, false) != null;
    }

    private static final boolean getDirectoriesByPackageName$lambda$0(GlobalSearchScope $scope, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $scope.contains(it);
    }

    private static final boolean getDirectoriesByPackageName$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ VirtualFileVisitor.Result access$processContentFilesUnderExcludedDirectory(WorkspaceFileIndexImpl $this, VirtualFile dir, ContentIteratorEx processor, VirtualFileFilter customFilter, Function1 fileSetFilter, VirtualFile rootDir, int numberOfExcludedParentDirectories) {
        return $this.processContentFilesUnderExcludedDirectory(dir, processor, customFilter, fileSetFilter, rootDir, numberOfExcludedParentDirectories);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexImpl$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<WorkspaceFileIndexContributor<?>> getEP_NAME() {
            return EP_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

