/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.serialization.impl.LibraryNameGenerator;
import com.intellij.platform.workspace.storage.CachedValue;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ExternalEntityMapping;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableExternalEntityMapping;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedEntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.EventDispatcher;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryOrigin;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImplKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectModifiableLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.ProjectLibraryTableBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0011H\u0016J\u0012\u0010\u001c\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0011H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u001eH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0015H\u0016J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u000bH\u0016J\u0018\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0002H\u0016J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u000bH\u0016J\b\u0010.\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectLibraryTableBridgeImpl;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ProjectLibraryTableBridge;", "Lcom/intellij/openapi/Disposable;", "parentProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "entityStorage", "Lcom/intellij/platform/workspace/storage/VersionedEntityStorage;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/roots/libraries/LibraryTable$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "libraryArrayValue", "Lcom/intellij/platform/workspace/storage/CachedValue;", "", "Lcom/intellij/openapi/roots/libraries/Library;", "loadLibraries", "", "targetBuilder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "workspaceModel", "Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl;", "(Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getProject", "getLibraries", "()[Lcom/intellij/openapi/roots/libraries/Library;", "createLibrary", "name", "", "removeLibrary", "library", "getLibraryIterator", "", "getLibraryByName", "getTableLevel", "getPresentation", "Lcom/intellij/openapi/roots/libraries/LibraryTablePresentation;", "getModifiableModel", "Lcom/intellij/openapi/roots/libraries/LibraryTable$ModifiableModel;", "diff", "addListener", "listener", "parentDisposable", "removeListener", "dispose", "Companion", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProjectLibraryTableBridgeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectLibraryTableBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectLibraryTableBridgeImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,292:1\n37#2,2:293\n13#3:295\n*S KotlinDebug\n*F\n+ 1 ProjectLibraryTableBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectLibraryTableBridgeImpl\n*L\n68#1:293,2\n278#1:295\n*E\n"})
public class ProjectLibraryTableBridgeImpl
implements ProjectLibraryTableBridge,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project parentProject;
    @NotNull
    private final VersionedEntityStorage entityStorage;
    @NotNull
    private final EventDispatcher<LibraryTable.Listener> dispatcher;
    @NotNull
    private final CachedValue<Library[]> libraryArrayValue;
    @NotNull
    private static final LibraryTablePresentation PROJECT_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

        public String getDisplayName(boolean plural) {
            Object[] objectArray = new Object[]{plural ? 2 : 1};
            String string = ProjectModelBundle.message((String)"project.library.display.name", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public String getDescription() {
            String string = ProjectModelBundle.message((String)"libraries.node.text.project", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public String getLibraryTableEditorTitle() {
            String string = ProjectModelBundle.message((String)"library.configure.project.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    };
    @NotNull
    private static final ExternalMappingKey<LibraryBridge> LIBRARY_BRIDGE_MAPPING_ID = ExternalMappingKey.Companion.create("intellij.libraries.bridge");
    @NotNull
    private static final Logger LOG;

    public ProjectLibraryTableBridgeImpl(@NotNull Project parentProject) {
        Intrinsics.checkNotNullParameter((Object)parentProject, (String)"parentProject");
        this.parentProject = parentProject;
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.parentProject);
        Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
        this.entityStorage = (VersionedEntityStorage)((WorkspaceModelInternal)workspaceModel).getEntityStorage();
        EventDispatcher eventDispatcher = EventDispatcher.create(LibraryTable.Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
        this.libraryArrayValue = new CachedValue(ProjectLibraryTableBridgeImpl::libraryArrayValue$lambda$0);
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){
            private boolean beforeCalled;

            /*
             * WARNING - void declaration
             */
            public void beforeChanged(VersionedStorageChange event) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.beforeCalled = true;
                List libraryChanges = event.getChanges(LibraryEntity.class);
                Iterable $this$filterIsInstance$iv = ProjectLibraryTableBridgeImplKt.access$filterProjectLibraryChanges(libraryChanges);
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof EntityChange.Removed)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List removeChanges = (List)destination$iv$iv;
                if (removeChanges.isEmpty()) {
                    return;
                }
                for (EntityChange.Removed change : removeChanges) {
                    LibraryBridge library = (LibraryBridge)Companion.getLibraryMap((EntityStorage)event.getStorageBefore()).getDataByEntity(change.getOldEntity());
                    Logger $this$debug_u24default$iv = LOG;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Fire 'beforeLibraryRemoved' event for " + ((LibraryEntity)change.getOldEntity()).getName() + ", library = " + library, t$iv);
                    }
                    if (library == null) continue;
                    ((LibraryTable.Listener)dispatcher.getMulticaster()).beforeLibraryRemoved((Library)library);
                }
            }

            public void changed(VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!this.beforeCalled) {
                    return;
                }
                this.beforeCalled = false;
                List changes = ProjectLibraryTableBridgeImplKt.access$filterProjectLibraryChanges(event.getChanges(LibraryEntity.class));
                if (changes.isEmpty()) {
                    return;
                }
                for (EntityChange change : changes) {
                    Logger $this$debug_u24default$iv = LOG;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Process library change " + change, t$iv);
                    }
                    EntityChange entityChange = change;
                    if (entityChange instanceof EntityChange.Added) {
                        LibraryBridgeImpl alreadyCreatedLibrary;
                        Object bl = Companion.getLibraryMap((EntityStorage)event.getStorageAfter()).getDataByEntity(((EntityChange.Added)change).getNewEntity());
                        if ((bl instanceof LibraryBridgeImpl ? (LibraryBridgeImpl)bl : null) == null) {
                            throw new IllegalStateException("Library bridge should be created in `before` method".toString());
                        }
                        alreadyCreatedLibrary = alreadyCreatedLibrary;
                        alreadyCreatedLibrary.setEntityStorage(entityStorage);
                        alreadyCreatedLibrary.clearTargetBuilder();
                        ((LibraryTable.Listener)dispatcher.getMulticaster()).afterLibraryAdded((Library)alreadyCreatedLibrary);
                        continue;
                    }
                    if (entityChange instanceof EntityChange.Removed) {
                        LibraryBridge library = (LibraryBridge)Companion.getLibraryMap((EntityStorage)event.getStorageBefore()).getDataByEntity(((EntityChange.Removed)change).getOldEntity());
                        if (library == null) continue;
                        ((LibraryTable.Listener)dispatcher.getMulticaster()).afterLibraryRemoved((Library)library);
                        LibraryBridgeImpl.Companion.disposeLibrary((Library)library);
                        continue;
                    }
                    if (entityChange instanceof EntityChange.Replaced) {
                        Object object;
                        LibraryBridgeImpl library;
                        LibraryId idAfter;
                        LibraryId idBefore = ((LibraryEntity)((EntityChange.Replaced)change).getOldEntity()).getSymbolicId();
                        if (Intrinsics.areEqual((Object)idBefore, (Object)(idAfter = ((LibraryEntity)((EntityChange.Replaced)change).getNewEntity()).getSymbolicId())) || (library = (object = Companion.getLibraryMap((EntityStorage)event.getStorageBefore()).getDataByEntity(((EntityChange.Replaced)change).getOldEntity())) instanceof LibraryBridgeImpl ? (LibraryBridgeImpl)object : null) == null) continue;
                        library.setEntityId(idAfter);
                        ((LibraryTable.Listener)dispatcher.getMulticaster()).afterLibraryRenamed((Library)library, LibraryNameGenerator.INSTANCE.getLegacyLibraryName(idBefore));
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        });
    }

    @Nullable
    public final Object loadLibraries(@Nullable MutableEntityStorage targetBuilder, @NotNull WorkspaceModelImpl workspaceModel, @NotNull Continuation<? super Unit> $completion) {
        MutableEntityStorage mutableEntityStorage = targetBuilder;
        EntityStorage storage = mutableEntityStorage != null ? (EntityStorage)mutableEntityStorage : this.entityStorage.getCurrent();
        List libraries = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)storage.entities(LibraryEntity.class), ProjectLibraryTableBridgeImpl::loadLibraries$lambda$0), arg_0 -> ProjectLibraryTableBridgeImpl.loadLibraries$lambda$1(storage, arg_0)), arg_0 -> ProjectLibraryTableBridgeImpl.loadLibraries$lambda$2(this, targetBuilder, arg_0)));
        LOG.info("Initial load of project-level (project=" + this.getProject().getName() + ") libraries. There are " + libraries.size() + " libraries to load.");
        if (libraries.isEmpty()) {
            return Unit.INSTANCE;
        }
        if (targetBuilder == null) {
            LOG.info("Applying project-level (project=" + this.getProject().getName() + ") libraries directly to project WSM.");
            Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(workspaceModel, (List<? extends Pair<? extends LibraryEntity, LibraryBridgeImpl>>)libraries, this, null){
                int label;
                final /* synthetic */ WorkspaceModelImpl $workspaceModel;
                final /* synthetic */ List<Pair<LibraryEntity, LibraryBridgeImpl>> $libraries;
                final /* synthetic */ ProjectLibraryTableBridgeImpl this$0;
                {
                    this.$workspaceModel = $workspaceModel;
                    this.$libraries = $libraries;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.$workspaceModel.updateProjectModelSilent("Add project library mapping", (Function1<? super MutableEntityStorage, Unit>)((Function1)arg_0 -> loadLibraries.2.invokeSuspend$lambda$0(this.$libraries, arg_0)));
                            this.label = 1;
                            Object object2 = CoroutinesKt.edtWriteAction(() -> loadLibraries.2.invokeSuspend$lambda$1(this.$libraries, this.this$0), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0(List $libraries, MutableEntityStorage it) {
                    for (Pair pair : $libraries) {
                        LibraryEntity entity = (LibraryEntity)pair.component1();
                        LibraryBridgeImpl library = (LibraryBridgeImpl)pair.component2();
                        ProjectLibraryTableBridgeImpl.Companion.getMutableLibraryMap(it).addIfAbsent((WorkspaceEntity)entity, (Object)library);
                    }
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$1(List $libraries, ProjectLibraryTableBridgeImpl this$0) {
                    Iterator<E> iterator = $libraries.iterator();
                    while (iterator.hasNext()) {
                        LibraryBridgeImpl library = (LibraryBridgeImpl)((Pair)iterator.next()).component2();
                        ((LibraryTable.Listener)ProjectLibraryTableBridgeImpl.access$getDispatcher$p(this$0).getMulticaster()).afterLibraryAdded((Library)library);
                    }
                    return Unit.INSTANCE;
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        LOG.info("Applying project-level (project=" + this.getProject().getName() + ") libraries to the provided builder.");
        for (Pair pair : libraries) {
            LibraryEntity entity = (LibraryEntity)pair.component1();
            LibraryBridgeImpl library = (LibraryBridgeImpl)pair.component2();
            Companion.getMutableLibraryMap(targetBuilder).addIfAbsent((WorkspaceEntity)entity, (Object)library);
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.parentProject;
    }

    @NotNull
    public Library[] getLibraries() {
        return (Library[])this.entityStorage.cachedValue(this.libraryArrayValue);
    }

    @NotNull
    public Library createLibrary() {
        return this.createLibrary(null);
    }

    @NotNull
    public Library createLibrary(@Nullable String name) {
        if (name == null) {
            throw new IllegalStateException("Creating unnamed project libraries is unsupported".toString());
        }
        if (this.getLibraryByName(name) != null) {
            throw new IllegalStateException(("Project library named " + name + " already exists").toString());
        }
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.createLibrary(name);
        modifiableModel.commit();
        Library newLibrary = this.getLibraryByName(name);
        if (newLibrary == null) {
            throw new IllegalStateException(("Library " + name + " was not created").toString());
        }
        return newLibrary;
    }

    public void removeLibrary(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.removeLibrary(library);
        modifiableModel.commit();
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        return ArrayIteratorKt.iterator((Object[])this.getLibraries());
    }

    @Nullable
    public Library getLibraryByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LibraryEntity libraryEntity = (LibraryEntity)this.entityStorage.getCurrent().resolve((SymbolicEntityId)new LibraryId(name, (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE));
        if (libraryEntity == null) {
            return null;
        }
        LibraryEntity entity = libraryEntity;
        return (Library)Companion.getLibraryMap(this.entityStorage.getCurrent()).getDataByEntity((WorkspaceEntity)entity);
    }

    @NotNull
    public String getTableLevel() {
        return "project";
    }

    @NotNull
    public LibraryTablePresentation getPresentation() {
        return PROJECT_LIBRARY_TABLE_PRESENTATION;
    }

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        Project project = this.getProject();
        EntityStorage entityStorage = this.entityStorage.getCurrent();
        return new ProjectModifiableLibraryTableBridgeImpl(entityStorage, this, project, null, false, 24, null);
    }

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel(@NotNull MutableEntityStorage diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        Project project = this.getProject();
        EntityStorage entityStorage = this.entityStorage.getCurrent();
        return new ProjectModifiableLibraryTableBridgeImpl(entityStorage, this, project, diff, false);
    }

    public void addListener(@NotNull LibraryTable.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.dispatcher.addListener((EventListener)listener);
    }

    public void addListener(@NotNull LibraryTable.Listener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.dispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void removeListener(@NotNull LibraryTable.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.dispatcher.removeListener((EventListener)listener);
    }

    public void dispose() {
        for (Library library : this.getLibraries()) {
            LibraryBridgeImpl.Companion.disposeLibrary(library);
        }
    }

    private static final Library[] libraryArrayValue$lambda$0(EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)storage.entities(LibraryEntity.class), ProjectLibraryTableBridgeImpl::libraryArrayValue$lambda$0$0), arg_0 -> ProjectLibraryTableBridgeImpl.libraryArrayValue$lambda$0$1(storage, arg_0)));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Library[0]);
    }

    private static final boolean libraryArrayValue$lambda$0$0(LibraryEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getTableId(), (Object)LibraryTableId.ProjectLibraryTableId.INSTANCE);
    }

    private static final LibraryBridge libraryArrayValue$lambda$0$1(EntityStorage $storage, LibraryEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LibraryBridge)Companion.getLibraryMap($storage).getDataByEntity((WorkspaceEntity)it);
    }

    private static final boolean loadLibraries$lambda$0(LibraryEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTableId() instanceof LibraryTableId.ProjectLibraryTableId;
    }

    private static final boolean loadLibraries$lambda$1(EntityStorage $storage, LibraryEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.getLibraryMap($storage).getDataByEntity((WorkspaceEntity)it) == null;
    }

    private static final Pair loadLibraries$lambda$2(ProjectLibraryTableBridgeImpl this$0, MutableEntityStorage $targetBuilder, LibraryEntity libraryEntity) {
        Intrinsics.checkNotNullParameter((Object)libraryEntity, (String)"libraryEntity");
        return new Pair((Object)libraryEntity, (Object)new LibraryBridgeImpl(this$0, new LibraryOrigin.OfProject(this$0.getProject()), libraryEntity.getSymbolicId(), this$0.entityStorage, $targetBuilder));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectLibraryTableBridgeImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\r2\u0006\u0010\u0017\u001a\u00020\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectLibraryTableBridgeImpl$Companion;", "", "<init>", "()V", "PROJECT_LIBRARY_TABLE_PRESENTATION", "Lcom/intellij/openapi/roots/libraries/LibraryTablePresentation;", "getPROJECT_LIBRARY_TABLE_PRESENTATION$intellij_platform_projectModel_impl", "()Lcom/intellij/openapi/roots/libraries/LibraryTablePresentation;", "LIBRARY_BRIDGE_MAPPING_ID", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryBridge;", "libraryMap", "Lcom/intellij/platform/workspace/storage/ExternalEntityMapping;", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "getLibraryMap", "(Lcom/intellij/platform/workspace/storage/EntityStorage;)Lcom/intellij/platform/workspace/storage/ExternalEntityMapping;", "mutableLibraryMap", "Lcom/intellij/platform/workspace/storage/MutableExternalEntityMapping;", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "getMutableLibraryMap", "(Lcom/intellij/platform/workspace/storage/MutableEntityStorage;)Lcom/intellij/platform/workspace/storage/MutableExternalEntityMapping;", "findLibraryEntity", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "library", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LibraryTablePresentation getPROJECT_LIBRARY_TABLE_PRESENTATION$intellij_platform_projectModel_impl() {
            return PROJECT_LIBRARY_TABLE_PRESENTATION;
        }

        @NotNull
        public final ExternalEntityMapping<LibraryBridge> getLibraryMap(@NotNull EntityStorage $this$libraryMap) {
            Intrinsics.checkNotNullParameter((Object)$this$libraryMap, (String)"<this>");
            return $this$libraryMap.getExternalMapping(LIBRARY_BRIDGE_MAPPING_ID);
        }

        @NotNull
        public final MutableExternalEntityMapping<LibraryBridge> getMutableLibraryMap(@NotNull MutableEntityStorage $this$mutableLibraryMap) {
            Intrinsics.checkNotNullParameter((Object)$this$mutableLibraryMap, (String)"<this>");
            return $this$mutableLibraryMap.getMutableExternalMapping(LIBRARY_BRIDGE_MAPPING_ID);
        }

        @Nullable
        public final LibraryEntity findLibraryEntity(@NotNull EntityStorage $this$findLibraryEntity, @NotNull LibraryBridge library) {
            Intrinsics.checkNotNullParameter((Object)$this$findLibraryEntity, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            return (LibraryEntity)SequencesKt.firstOrNull((Sequence)this.getLibraryMap($this$findLibraryEntity).getEntities((Object)library));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

