/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.metrics.ExponentialHistogramStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.GaugeStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.HistogramStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.SumStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.SummaryStatelessMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.Metric;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

final class MetricStatelessMarshaler
implements StatelessMarshaler<MetricData> {
    static final MetricStatelessMarshaler INSTANCE = new MetricStatelessMarshaler();
    private static final Map<MetricDataType, StatelessMarshaler<MetricData>> METRIC_MARSHALERS = new EnumMap<MetricDataType, StatelessMarshaler<MetricData>>(MetricDataType.class);

    private MetricStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
        StatelessMarshaler<MetricData> metricMarshaler = METRIC_MARSHALERS.get(metric.getType());
        if (metricMarshaler == null) {
            return;
        }
        output.serializeStringWithContext(Metric.NAME, metric.getName(), context);
        output.serializeStringWithContext(Metric.DESCRIPTION, metric.getDescription(), context);
        output.serializeStringWithContext(Metric.UNIT, metric.getUnit(), context);
        metricMarshaler.writeTo(output, metric, context);
    }

    @Override
    public int getBinarySerializedSize(MetricData metric, MarshalerContext context) {
        StatelessMarshaler<MetricData> metricMarshaler = METRIC_MARSHALERS.get(metric.getType());
        if (metricMarshaler == null) {
            return 0;
        }
        int size = 0;
        size += StatelessMarshalerUtil.sizeStringWithContext(Metric.NAME, metric.getName(), context);
        size += StatelessMarshalerUtil.sizeStringWithContext(Metric.DESCRIPTION, metric.getDescription(), context);
        size += StatelessMarshalerUtil.sizeStringWithContext(Metric.UNIT, metric.getUnit(), context);
        return size += metricMarshaler.getBinarySerializedSize(metric, context);
    }

    static {
        METRIC_MARSHALERS.put(MetricDataType.LONG_GAUGE, new StatelessMarshaler<MetricData>(){

            @Override
            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext(Metric.GAUGE, metricData.getLongGaugeData(), GaugeStatelessMarshaler.INSTANCE, context);
            }

            @Override
            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.GAUGE, metric.getLongGaugeData(), GaugeStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.DOUBLE_GAUGE, new StatelessMarshaler<MetricData>(){

            @Override
            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext(Metric.GAUGE, metricData.getDoubleGaugeData(), GaugeStatelessMarshaler.INSTANCE, context);
            }

            @Override
            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.GAUGE, metric.getDoubleGaugeData(), GaugeStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.LONG_SUM, new StatelessMarshaler<MetricData>(){

            @Override
            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext(Metric.SUM, metricData.getLongSumData(), SumStatelessMarshaler.INSTANCE, context);
            }

            @Override
            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.SUM, metric.getLongSumData(), SumStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.DOUBLE_SUM, new StatelessMarshaler<MetricData>(){

            @Override
            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext(Metric.SUM, metricData.getDoubleSumData(), SumStatelessMarshaler.INSTANCE, context);
            }

            @Override
            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.SUM, metric.getDoubleSumData(), SumStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.SUMMARY, new StatelessMarshaler<MetricData>(){

            @Override
            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext(Metric.SUMMARY, metricData.getSummaryData(), SummaryStatelessMarshaler.INSTANCE, context);
            }

            @Override
            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.SUMMARY, metric.getSummaryData(), SummaryStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.HISTOGRAM, new StatelessMarshaler<MetricData>(){

            @Override
            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext(Metric.HISTOGRAM, metricData.getHistogramData(), HistogramStatelessMarshaler.INSTANCE, context);
            }

            @Override
            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.HISTOGRAM, metric.getHistogramData(), HistogramStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.EXPONENTIAL_HISTOGRAM, new StatelessMarshaler<MetricData>(){

            @Override
            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext(Metric.EXPONENTIAL_HISTOGRAM, metricData.getExponentialHistogramData(), ExponentialHistogramStatelessMarshaler.INSTANCE, context);
            }

            @Override
            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.EXPONENTIAL_HISTOGRAM, metric.getExponentialHistogramData(), ExponentialHistogramStatelessMarshaler.INSTANCE, context);
            }
        });
    }
}

