/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend.vm;

import com.intellij.ide.rpc.ThrottledItems;
import com.intellij.ide.rpc.ThrottlingUtilsKt;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.platform.searchEverywhere.SeItemData;
import com.intellij.platform.searchEverywhere.SeProviderId;
import com.intellij.platform.searchEverywhere.SeResultAddedEvent;
import com.intellij.platform.searchEverywhere.SeResultEndEvent;
import com.intellij.platform.searchEverywhere.SeResultEvent;
import com.intellij.platform.searchEverywhere.SeResultReplacedEvent;
import com.intellij.platform.searchEverywhere.providers.SeLog;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.flow.Flow;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a,\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006*\b\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\f\u0010\f\u001a\u00020\u000b*\u00020\bH\u0002\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\bH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"ESSENTIALS_THROTTLE_DELAY", "", "ESSENTIALS_ENOUGH_COUNT", "", "FAST_PASS_THROTTLE", "throttleUntilEssentialsArrive", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/ide/rpc/ThrottledItems;", "Lcom/intellij/platform/searchEverywhere/SeResultEvent;", "essentialProviderIds", "", "Lcom/intellij/platform/searchEverywhere/SeProviderId;", "providerId", "itemDataOrNull", "Lcom/intellij/platform/searchEverywhere/SeItemData;", "shouldIgnoreThrottling", "", "intellij.platform.searchEverywhere.frontend"})
@SourceDebugExtension(value={"SMAP\nSeTabVm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeTabVm.kt\ncom/intellij/platform/searchEverywhere/frontend/vm/SeTabVmKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,381:1\n1285#2,2:382\n1299#2,4:384\n1740#2,3:388\n1740#2,3:391\n*S KotlinDebug\n*F\n+ 1 SeTabVm.kt\ncom/intellij/platform/searchEverywhere/frontend/vm/SeTabVmKt\n*L\n294#1:382,2\n294#1:384,4\n322#1:388,3\n323#1:391,3\n*E\n"})
public final class SeTabVmKt {
    private static final long ESSENTIALS_THROTTLE_DELAY = 100L;
    private static final int ESSENTIALS_ENOUGH_COUNT = 15;
    private static final long FAST_PASS_THROTTLE = 100L;

    /*
     * WARNING - void declaration
     */
    private static final Flow<ThrottledItems<SeResultEvent>> throttleUntilEssentialsArrive(Flow<? extends SeResultEvent> $this$throttleUntilEssentialsArrive, Set<SeProviderId> essentialProviderIds2) {
        void $this$associateWithTo$iv$iv;
        Iterable $this$associateWith$iv = essentialProviderIds2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            SeProviderId seProviderId = (SeProviderId)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Integer n = 0;
            map2.put(t, n);
        }
        Map essentialProvidersCounts = MapsKt.toMutableMap((Map)destination$iv$iv);
        long essentialWaitingTimeout = AdvancedSettings.Companion.getInt("search.everywhere.contributors.wait.timeout");
        SeLog.Companion.log(SeLog.THROTTLING, () -> SeTabVmKt.throttleUntilEssentialsArrive$lambda$1(essentialProviderIds2));
        return ThrottlingUtilsKt.throttledWithAccumulation($this$throttleUntilEssentialsArrive, (long)essentialWaitingTimeout, SeTabVmKt::throttleUntilEssentialsArrive$lambda$2, (long)100L, SeTabVmKt::throttleUntilEssentialsArrive$lambda$3, (arg_0, arg_1) -> SeTabVmKt.throttleUntilEssentialsArrive$lambda$4(essentialProvidersCounts, arg_0, arg_1));
    }

    private static final SeProviderId providerId(SeResultEvent $this$providerId) {
        SeProviderId seProviderId;
        SeResultEvent seResultEvent = $this$providerId;
        if (seResultEvent instanceof SeResultAddedEvent) {
            seProviderId = ((SeResultAddedEvent)$this$providerId).getItemData().getProviderId();
        } else if (seResultEvent instanceof SeResultReplacedEvent) {
            seProviderId = ((SeResultReplacedEvent)$this$providerId).getNewItemData().getProviderId();
        } else if (seResultEvent instanceof SeResultEndEvent) {
            seProviderId = ((SeResultEndEvent)$this$providerId).getProviderId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return seProviderId;
    }

    private static final SeItemData itemDataOrNull(SeResultEvent $this$itemDataOrNull) {
        SeItemData seItemData;
        SeResultEvent seResultEvent = $this$itemDataOrNull;
        if (seResultEvent instanceof SeResultAddedEvent) {
            seItemData = ((SeResultAddedEvent)$this$itemDataOrNull).getItemData();
        } else if (seResultEvent instanceof SeResultReplacedEvent) {
            seItemData = ((SeResultReplacedEvent)$this$itemDataOrNull).getNewItemData();
        } else if (seResultEvent instanceof SeResultEndEvent) {
            seItemData = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return seItemData;
    }

    private static final boolean shouldIgnoreThrottling(SeItemData $this$shouldIgnoreThrottling) {
        return AdvancedSettings.Companion.getBoolean("search.everywhere.recent.at.top") && Intrinsics.areEqual((Object)$this$shouldIgnoreThrottling.getProviderId().getValue(), (Object)"RecentFilesSEContributor") || $this$shouldIgnoreThrottling.isCommand();
    }

    private static final String throttleUntilEssentialsArrive$lambda$1(Set $essentialProviderIds) {
        return "Will start throttle with essential providers: " + $essentialProviderIds;
    }

    private static final boolean throttleUntilEssentialsArrive$lambda$2(SeResultEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof SeResultEndEvent);
    }

    private static final boolean throttleUntilEssentialsArrive$lambda$3(SeResultEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SeItemData seItemData = SeTabVmKt.itemDataOrNull(it);
        return seItemData != null ? SeTabVmKt.shouldIgnoreThrottling(seItemData) : false;
    }

    private static final Long throttleUntilEssentialsArrive$lambda$4(Map $essentialProvidersCounts, SeResultEvent event, int n) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SeProviderId providerId = SeTabVmKt.providerId(event);
        if (event instanceof SeResultEndEvent) {
            if ($essentialProvidersCounts.remove(providerId) != null) {
                SeLog.Companion.log(SeLog.THROTTLING, () -> SeTabVmKt.throttleUntilEssentialsArrive$lambda$4$0(providerId));
            }
        } else {
            Integer n2 = (Integer)$essentialProvidersCounts.get(providerId);
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl = false;
                SeLog.Companion.log(SeLog.THROTTLING, () -> SeTabVmKt.throttleUntilEssentialsArrive$lambda$4$1$0(providerId, it));
                $essentialProvidersCounts.put(providerId, it + 1);
            }
        }
        if ($essentialProvidersCounts.isEmpty()) {
            l = 0L;
        } else {
            int it;
            boolean bl;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block14: {
                $this$all$iv = $essentialProvidersCounts.values();
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = ((Number)element$iv).intValue();
                        boolean bl2 = false;
                        if (it >= 15) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
            }
            if (bl) {
                l = 0L;
            } else {
                boolean bl3;
                block15: {
                    $this$all$iv = $essentialProvidersCounts.values();
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = ((Number)element$iv).intValue();
                            boolean bl4 = false;
                            if (it > 0) continue;
                            bl3 = false;
                            break block15;
                        }
                        bl3 = true;
                    }
                }
                l = bl3 ? Long.valueOf(100L) : null;
            }
        }
        return l;
    }

    private static final String throttleUntilEssentialsArrive$lambda$4$0(SeProviderId $providerId) {
        return "Ended: " + $providerId;
    }

    private static final String throttleUntilEssentialsArrive$lambda$4$1$0(SeProviderId $providerId, int $it) {
        return "Arrived: " + $providerId + " (" + $it + ")";
    }

    public static final /* synthetic */ SeItemData access$itemDataOrNull(SeResultEvent $receiver) {
        return SeTabVmKt.itemDataOrNull($receiver);
    }

    public static final /* synthetic */ Flow access$throttleUntilEssentialsArrive(Flow $receiver, Set essentialProviderIds2) {
        return SeTabVmKt.throttleUntilEssentialsArrive((Flow<? extends SeResultEvent>)$receiver, essentialProviderIds2);
    }
}

