/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.IconState;
import com.intellij.ui.LayeredIconKt;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.CompositeIconUtilKt;
import com.intellij.ui.icons.DarkIconProvider;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.IconWithToolTip;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 P2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001PB\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tB\u001d\b\u0017\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\rB\u001f\b\u0012\u0012\u0014\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\u000e\u00a2\u0006\u0004\b\u0007\u0010\u000fB\u001b\b\u0012\u0012\u0006\u0010\u0010\u001a\u00020\u0000\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0007\u0010\u0013J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010&\u001a\u00020\u0000H\u0016J\b\u0010'\u001a\u00020\u0000H\u0016J\u0015\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0002\u00a2\u0006\u0002\u0010$J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020!H\u0016J\u0013\u0010+\u001a\u00020!2\b\u0010,\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020\u0006H\u0016J\u0018\u0010/\u001a\u0002002\b\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u00101\u001a\u00020\u0006J\u0012\u00102\u001a\u0004\u0018\u00010\f2\u0006\u00101\u001a\u00020\u0006H\u0016J\b\u00103\u001a\u00020\u0006H\u0016J(\u0010/\u001a\u0002002\b\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u00101\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006J\u001e\u0010/\u001a\u0002002\u0006\u0010\u0010\u001a\u00020\f2\u0006\u00101\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0006J\u0010\u00107\u001a\u0002002\u0006\u0010\u0010\u001a\u00020\fH\u0002J\b\u00108\u001a\u00020!H\u0002J*\u00109\u001a\u0002002\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u0006H\u0016J\u000e\u0010@\u001a\u00020!2\u0006\u00101\u001a\u00020\u0006J\u0016\u0010A\u001a\u0002002\u0006\u00101\u001a\u00020\u00062\u0006\u0010B\u001a\u00020!J\b\u0010C\u001a\u00020\u0006H\u0016J\b\u0010D\u001a\u00020\u0006H\u0016J\u000e\u0010E\u001a\u00020\u00062\u0006\u0010F\u001a\u00020\u0006J\u000e\u0010G\u001a\u00020\u00062\u0006\u0010F\u001a\u00020\u0006J\u001d\u0010H\u001a\u0002002\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010I\u001a\u00020\f2\u0006\u0010J\u001a\u00020!H\u0016J\b\u0010K\u001a\u00020LH\u0016J\u0017\u0010M\u001a\t\u0018\u00010L\u00a2\u0006\u0002\bN2\u0006\u0010O\u001a\u00020!H\u0016R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006Q"}, d2={"Lcom/intellij/ui/LayeredIcon;", "Lcom/intellij/util/ui/JBCachingScalableIcon;", "Lcom/intellij/ui/icons/DarkIconProvider;", "Lcom/intellij/ui/icons/CompositeIcon;", "Lcom/intellij/ui/icons/IconWithToolTip;", "layerCount", "", "<init>", "(I)V", "()V", "icons", "", "Ljavax/swing/Icon;", "([Ljavax/swing/Icon;)V", "Ljava/util/function/Supplier;", "(Ljava/util/function/Supplier;)V", "icon", "replacer", "Lcom/intellij/ui/icons/IconReplacer;", "(Lcom/intellij/ui/LayeredIcon;Lcom/intellij/ui/icons/IconReplacer;)V", "iconListSupplier", "Lcom/intellij/ui/IconState;", "scaledIcons", "[Ljavax/swing/Icon;", "hShifts", "", "vShifts", "xShift", "yShift", "width", "height", "deferredMask", "sizeIsDirty", "", "allLayers", "getAllLayers", "()[Ljavax/swing/Icon;", "replaceBy", "copy", "deepCopy", "getOrComputeScaledIcons", "withIconPreScaled", "preScaled", "equals", "other", "", "hashCode", "setIcon", "", "layer", "getIcon", "getIconCount", "hShift", "vShift", "constraint", "checkIHaventIconInsideMe", "isSizeDirty", "paintIcon", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "isLayerEnabled", "setLayerEnabled", "enabled", "getIconWidth", "getIconHeight", "getHShift", "i", "getVShift", "updateSize", "getDarkIcon", "isDark", "toString", "", "getToolTip", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "composite", "Companion", "intellij.platform.core.ui"})
@SourceDebugExtension(value={"SMAP\nLayeredIcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayeredIcon.kt\ncom/intellij/ui/LayeredIcon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,432:1\n1#2:433\n*E\n"})
public class LayeredIcon
extends JBCachingScalableIcon<LayeredIcon>
implements DarkIconProvider,
CompositeIcon,
IconWithToolTip {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<IconState> iconListSupplier;
    @Nullable
    private Icon[] scaledIcons;
    @NotNull
    private int[] hShifts;
    @NotNull
    private int[] vShifts;
    private int xShift;
    private int yShift;
    private int width;
    private int height;
    private int deferredMask;
    private boolean sizeIsDirty;
    @JvmField
    @NotNull
    public static final Icon ADD_WITH_DROPDOWN = (Icon)((Object)new LayeredIcon(LayeredIcon::ADD_WITH_DROPDOWN$lambda$0));
    @JvmField
    @NotNull
    public static final Icon EDIT_WITH_DROPDOWN = (Icon)((Object)new LayeredIcon(LayeredIcon::EDIT_WITH_DROPDOWN$lambda$0));
    @JvmField
    @NotNull
    public static final Icon GEAR_WITH_DROPDOWN = (Icon)((Object)new LayeredIcon(LayeredIcon::GEAR_WITH_DROPDOWN$lambda$0));

    public LayeredIcon(int layerCount) {
        this.sizeIsDirty = true;
        this.getScaleContext().addUpdateListener(() -> LayeredIcon._init_$lambda$0(this));
        this.setAutoUpdateScaleContext(false);
        IconState state = new IconState(new Icon[layerCount], new boolean[layerCount]);
        this.iconListSupplier = () -> LayeredIcon._init_$lambda$1(state);
        this.hShifts = new int[layerCount];
        this.vShifts = new int[layerCount];
        this.scaledIcons = null;
    }

    public LayeredIcon() {
        this(0);
    }

    @Deprecated(message="Use [layeredIcon]")
    public LayeredIcon(Icon ... icons) {
        Intrinsics.checkNotNullParameter((Object)icons, (String)"icons");
        this.sizeIsDirty = true;
        this.getScaleContext().addUpdateListener(() -> LayeredIcon._init_$lambda$0(this));
        this.setAutoUpdateScaleContext(false);
        int layerCount = icons.length;
        IconState state = new IconState(new Icon[layerCount], new boolean[layerCount]);
        ArraysKt.copyInto$default((Object[])icons, (Object[])state.icons, (int)0, (int)0, (int)0, (int)14, null);
        this.iconListSupplier = () -> LayeredIcon._init_$lambda$2(state);
        this.hShifts = new int[layerCount];
        this.vShifts = new int[layerCount];
        this.scaledIcons = null;
    }

    private LayeredIcon(Supplier<Icon[]> icons) {
        this.sizeIsDirty = true;
        this.getScaleContext().addUpdateListener(() -> LayeredIcon._init_$lambda$0(this));
        this.setAutoUpdateScaleContext(false);
        this.iconListSupplier = (Supplier)new SynchronizedClearableLazy(() -> LayeredIcon._init_$lambda$3(icons, this));
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_INT_ARRAY, (String)"EMPTY_INT_ARRAY");
        this.hShifts = ArrayUtilRt.EMPTY_INT_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_INT_ARRAY, (String)"EMPTY_INT_ARRAY");
        this.vShifts = ArrayUtilRt.EMPTY_INT_ARRAY;
        this.scaledIcons = null;
    }

    private LayeredIcon(LayeredIcon icon, IconReplacer replacer2) {
        super((JBCachingScalableIcon)icon);
        this.sizeIsDirty = true;
        this.getScaleContext().addUpdateListener(() -> LayeredIcon._init_$lambda$0(this));
        this.setAutoUpdateScaleContext(false);
        IconState iconState = icon.iconListSupplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)iconState, (String)"get(...)");
        IconState otherState = iconState;
        Icon[] iconArray = Arrays.copyOf(otherState.icons, otherState.icons.length);
        Intrinsics.checkNotNullExpressionValue((Object)iconArray, (String)"copyOf(...)");
        Icon[] icons = iconArray;
        if (replacer2 != null) {
            int n = icons.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                Icon subIcon = icons[i];
                icons[i2] = replacer2.replaceIcon(subIcon);
            }
        }
        IconState state = new IconState(icons, otherState.disabledLayers);
        this.iconListSupplier = () -> LayeredIcon._init_$lambda$4(state);
        this.scaledIcons = null;
        int[] nArray = Arrays.copyOf(icon.hShifts, icon.hShifts.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.hShifts = nArray;
        int[] nArray2 = Arrays.copyOf(icon.vShifts, icon.vShifts.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        this.vShifts = nArray2;
        this.xShift = icon.xShift;
        this.yShift = icon.yShift;
        this.width = icon.width;
        this.height = icon.height;
    }

    @NotNull
    public final Icon[] getAllLayers() {
        return this.iconListSupplier.get().icons;
    }

    @NotNull
    public LayeredIcon replaceBy(@NotNull IconReplacer replacer2) {
        Intrinsics.checkNotNullParameter((Object)replacer2, (String)"replacer");
        return new LayeredIcon(this, replacer2);
    }

    @NotNull
    public LayeredIcon copy() {
        return new LayeredIcon(this, null);
    }

    @NotNull
    public LayeredIcon deepCopy() {
        return new LayeredIcon(this, new IconReplacer(){

            public Icon replaceIcon(Icon icon) {
                Icon icon2;
                Icon icon3 = icon;
                if (icon3 != null) {
                    Icon it = icon3;
                    boolean bl = false;
                    icon2 = IconUtil.copy(it, null);
                } else {
                    icon2 = null;
                }
                return icon2;
            }
        });
    }

    private final Icon[] getOrComputeScaledIcons() {
        Icon[] iconArray;
        if (this.scaledIcons != null) {
            Icon[] it = this.scaledIcons;
            boolean bl = false;
            return it;
        }
        Icon[] it = iconArray = LayeredIconKt.scaleIcons(this.getAllLayers(), this.getScale());
        boolean bl = false;
        this.scaledIcons = it;
        return iconArray;
    }

    @NotNull
    public LayeredIcon withIconPreScaled(boolean preScaled) {
        super.withIconPreScaled(preScaled);
        this.updateSize(this.getAllLayers());
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayeredIcon)) {
            return false;
        }
        if (this.height != ((LayeredIcon)((Object)other)).height) {
            return false;
        }
        if (this.width != ((LayeredIcon)((Object)other)).width) {
            return false;
        }
        if (this.xShift != ((LayeredIcon)((Object)other)).xShift) {
            return false;
        }
        if (this.yShift != ((LayeredIcon)((Object)other)).yShift) {
            return false;
        }
        if (!Arrays.equals(this.hShifts, ((LayeredIcon)((Object)other)).hShifts)) {
            return false;
        }
        if (!Arrays.equals(this.getAllLayers(), ((LayeredIcon)((Object)other)).getAllLayers())) {
            return false;
        }
        return Arrays.equals(this.vShifts, ((LayeredIcon)((Object)other)).vShifts);
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public final void setIcon(@Nullable Icon icon, int layer) {
        this.setIcon(icon, layer, 0, 0);
    }

    @Nullable
    public Icon getIcon(int layer) {
        return this.getAllLayers()[layer];
    }

    public int getIconCount() {
        return this.getAllLayers().length;
    }

    public final void setIcon(@Nullable Icon icon, int layer, int hShift, int vShift) {
        if (icon instanceof LayeredIcon) {
            ((LayeredIcon)((Object)icon)).checkIHaventIconInsideMe((Icon)((Object)this));
        }
        Icon[] allLayers = this.getAllLayers();
        allLayers[layer] = icon;
        this.scaledIcons = null;
        this.hShifts[layer] = hShift;
        this.vShifts[layer] = vShift;
        this.sizeIsDirty = true;
    }

    public final void setIcon(@NotNull Icon icon, int layer, int constraint) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        if (width <= 1 || height <= 1) {
            this.setIcon(icon, layer);
            return;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int x = 0;
        int y = 0;
        switch (constraint) {
            case 0: {
                x = (width - w) / 2;
                y = (height - h) / 2;
                break;
            }
            case 1: {
                x = (width - w) / 2;
                y = 0;
                break;
            }
            case 2: {
                x = width - w;
                y = 0;
                break;
            }
            case 3: {
                x = width - w;
                y = (height - h) / 2;
                break;
            }
            case 4: {
                x = width - w;
                y = height - h;
                break;
            }
            case 5: {
                x = (width - w) / 2;
                y = height - h;
                break;
            }
            case 6: {
                x = 0;
                y = height - h;
                break;
            }
            case 7: {
                x = 0;
                y = (height - h) / 2;
                break;
            }
            case 8: {
                x = 0;
                y = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("The constraint should be one of SwingConstants' compass-directions [1..8] or CENTER [0], actual value is " + constraint);
            }
        }
        this.setIcon(icon, layer, x, y);
    }

    private final void checkIHaventIconInsideMe(Icon icon) {
        LayeredIconKt.access$getLOG$p().assertTrue(icon != this);
        for (Icon child : this.getAllLayers()) {
            if (!(child instanceof LayeredIcon)) continue;
            ((LayeredIcon)((Object)child)).checkIHaventIconInsideMe(icon);
        }
    }

    private final boolean isSizeDirty() {
        if (this.sizeIsDirty) {
            return true;
        }
        if (CompositeIconUtilKt.deferredMask(this) != this.deferredMask) {
            this.sizeIsDirty = true;
            return true;
        }
        return false;
    }

    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.getScaleContext().update();
        if (this.isSizeDirty()) {
            this.updateSize(this.getAllLayers());
        }
        Icon[] icons = this.getOrComputeScaledIcons();
        boolean[] disabledLayers = this.iconListSupplier.get().disabledLayers;
        int n = icons.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            Icon icon = icons[i];
            if (icon == null || disabledLayers[i2]) continue;
            int xOffset = (int)Math.floor((double)x + this.scaleVal(this.xShift + this.getHShift(i2), ScaleType.OBJ_SCALE));
            int yOffset = (int)Math.floor((double)y + this.scaleVal(this.yShift + this.getVShift(i2), ScaleType.OBJ_SCALE));
            icon.paintIcon(c, g, xOffset, yOffset);
        }
    }

    public final boolean isLayerEnabled(int layer) {
        return !this.iconListSupplier.get().disabledLayers[layer];
    }

    public final void setLayerEnabled(int layer, boolean enabled) {
        boolean[] disabledLayers = this.iconListSupplier.get().disabledLayers;
        if (disabledLayers[layer] == enabled) {
            disabledLayers[layer] = !enabled;
            this.clearCachedScaledValue();
        }
    }

    public int getIconWidth() {
        this.getScaleContext().update();
        if (this.isSizeDirty()) {
            this.updateSize(this.getAllLayers());
        }
        return (int)Math.ceil(this.scaleVal(this.width, ScaleType.OBJ_SCALE));
    }

    public int getIconHeight() {
        this.getScaleContext().update();
        if (this.isSizeDirty()) {
            this.updateSize(this.getAllLayers());
        }
        return (int)Math.ceil(this.scaleVal(this.height, ScaleType.OBJ_SCALE));
    }

    public final int getHShift(int i) {
        return (int)Math.floor(this.scaleVal(this.hShifts[i], ScaleType.USR_SCALE));
    }

    public final int getVShift(int i) {
        return (int)Math.floor(this.scaleVal(this.vShifts[i], ScaleType.USR_SCALE));
    }

    private final void updateSize(Icon[] allLayers) {
        this.sizeIsDirty = false;
        this.deferredMask = CompositeIconUtilKt.deferredMask(this);
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        boolean allIconsAreNull = true;
        int n = allLayers.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            Icon icon = allLayers[i];
            if (icon == null) continue;
            allIconsAreNull = false;
            int hShift = this.getHShift(i2);
            int vShift = this.getVShift(i2);
            minX = Math.min(minX, hShift);
            maxX = Math.max(maxX, hShift + icon.getIconWidth());
            minY = Math.min(minY, vShift);
            maxY = Math.max(maxY, vShift + icon.getIconHeight());
        }
        if (allIconsAreNull) {
            return;
        }
        this.width = maxX - minX;
        this.height = maxY - minY;
        if (allLayers.length > 1) {
            this.xShift = -minX;
            this.yShift = -minY;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Icon getDarkIcon(boolean isDark) {
        LayeredIcon newIcon = this.copy();
        Icon[] iconArray = newIcon.getAllLayers();
        int n = iconArray.length;
        for (int i = 0; i < n; ++i) {
            Icon icon;
            int i2 = i;
            Icon icon2 = iconArray[i];
            Icon[] iconArray2 = newIcon.getAllLayers();
            int n2 = i2;
            if (icon2 != null) {
                void it;
                int n3 = n2;
                Icon[] iconArray3 = iconArray2;
                boolean bl = false;
                Icon icon3 = IconLoader.getDarkIcon((Icon)it, (boolean)isDark);
                iconArray2 = iconArray3;
                n2 = n3;
                icon = icon3;
            } else {
                icon = null;
            }
            iconArray2[n2] = icon;
        }
        return (Icon)((Object)newIcon);
    }

    @NotNull
    public String toString() {
        return "LayeredIcon(w=" + this.width + ", h=" + this.height + ", icons=[" + ArraysKt.joinToString$default((Object[])this.getAllLayers(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]";
    }

    @Nullable
    public String getToolTip(boolean composite) {
        return LayeredIconKt.combineIconTooltips(this.getAllLayers());
    }

    private static final void _init_$lambda$0(LayeredIcon this$0) {
        this$0.updateSize(this$0.getAllLayers());
    }

    private static final IconState _init_$lambda$1(IconState $state) {
        return $state;
    }

    private static final IconState _init_$lambda$2(IconState $state) {
        return $state;
    }

    private static final IconState _init_$lambda$3(Supplier $icons, LayeredIcon this$0) {
        Icon[] result = (Icon[])$icons.get();
        this$0.hShifts = new int[result.length];
        this$0.vShifts = new int[result.length];
        this$0.sizeIsDirty = true;
        return new IconState(result, new boolean[result.length]);
    }

    private static final IconState _init_$lambda$4(IconState $state) {
        return $state;
    }

    private static final Icon[] ADD_WITH_DROPDOWN$lambda$0() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.General.Add, (String)"Add");
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.General.Dropdown, (String)"Dropdown");
        return iconArray;
    }

    private static final Icon[] EDIT_WITH_DROPDOWN$lambda$0() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Actions.Edit, (String)"Edit");
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.General.Dropdown, (String)"Dropdown");
        return iconArray;
    }

    private static final Icon[] GEAR_WITH_DROPDOWN$lambda$0() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.General.GearPlain, (String)"GearPlain");
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.General.Dropdown, (String)"Dropdown");
        return iconArray;
    }

    @JvmStatic
    @NotNull
    public static final LayeredIcon layeredIcon(@NotNull Supplier<Icon[]> icons) {
        return Companion.layeredIcon(icons);
    }

    @JvmStatic
    @NotNull
    public static final LayeredIcon layeredIcon(@NotNull Icon[] icons) {
        return Companion.layeredIcon(icons);
    }

    @JvmStatic
    @NotNull
    public static final Icon create(@Nullable Icon backgroundIcon, @Nullable Icon foregroundIcon) {
        return Companion.create(backgroundIcon, foregroundIcon);
    }

    public /* synthetic */ LayeredIcon(Supplier icons, DefaultConstructorMarker $constructor_marker) {
        this(icons);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f0\u000bH\u0007J\u001d\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\fH\u0007\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/LayeredIcon$Companion;", "", "<init>", "()V", "ADD_WITH_DROPDOWN", "Ljavax/swing/Icon;", "EDIT_WITH_DROPDOWN", "GEAR_WITH_DROPDOWN", "layeredIcon", "Lcom/intellij/ui/LayeredIcon;", "icons", "Ljava/util/function/Supplier;", "", "([Ljavax/swing/Icon;)Lcom/intellij/ui/LayeredIcon;", "create", "backgroundIcon", "foregroundIcon", "intellij.platform.core.ui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LayeredIcon layeredIcon(@NotNull Supplier<Icon[]> icons) {
            Intrinsics.checkNotNullParameter(icons, (String)"icons");
            return new LayeredIcon(icons, null);
        }

        @JvmStatic
        @NotNull
        public final LayeredIcon layeredIcon(@NotNull Icon[] icons) {
            Intrinsics.checkNotNullParameter((Object)icons, (String)"icons");
            return new LayeredIcon(Arrays.copyOf(icons, icons.length));
        }

        @JvmStatic
        @NotNull
        public final Icon create(@Nullable Icon backgroundIcon, @Nullable Icon foregroundIcon) {
            LayeredIcon layeredIcon = new LayeredIcon(2);
            layeredIcon.setIcon(backgroundIcon, 0);
            layeredIcon.setIcon(foregroundIcon, 1);
            return (Icon)((Object)layeredIcon);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

