/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a3\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0007\u001a5\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"scaleIconOrLoadCustomVersion", "Ljavax/swing/Icon;", "icon", "scale", "", "loadIconCustomVersion", "Lcom/intellij/ui/icons/CachedImageIcon;", "width", "", "height", "isDark", "", "(Lcom/intellij/ui/icons/CachedImageIcon;IILjava/lang/Boolean;)Ljavax/swing/Icon;", "loadIconCustomVersionOrScale", "Lcom/intellij/openapi/util/ScalableIcon;", "size", "isDarkForScale", "(Lcom/intellij/ui/icons/CachedImageIcon;ILjava/lang/Boolean;Ljava/lang/Boolean;)Ljavax/swing/Icon;", "intellij.platform.core.ui"})
public final class CustomIconUtilKt {
    @ApiStatus.Internal
    @NotNull
    public static final Icon scaleIconOrLoadCustomVersion(@NotNull Icon icon, float scale2) {
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (icon instanceof CachedImageIcon) {
            int oldWidth = ((CachedImageIcon)icon).getRawIconWidth();
            int oldHeight = ((CachedImageIcon)icon).getRawIconWidth();
            int newWidth = MathKt.roundToInt((float)(scale2 * (float)oldWidth));
            int newHeight = MathKt.roundToInt((float)(scale2 * (float)oldHeight));
            if (oldWidth == newWidth && oldHeight == newHeight) {
                return icon;
            }
            Icon version = CustomIconUtilKt.loadIconCustomVersion$default((CachedImageIcon)icon, newWidth, newHeight, null, 8, null);
            if (version != null) {
                return version;
            }
        }
        if (icon instanceof ScalableIcon) {
            Icon icon3 = ((ScalableIcon)icon).scale(scale2);
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"scale(...)");
        } else {
            icon2 = IconUtil.scale(icon, null, scale2);
        }
        return icon2;
    }

    private static final Icon loadIconCustomVersion(CachedImageIcon icon, int width, int height, Boolean isDark) {
        Pair pair = icon.getCoords();
        if (pair == null) {
            return null;
        }
        Pair coords = pair;
        String path = (String)coords.getFirst();
        if (!StringsKt.endsWith$default((String)path, (String)".svg", (boolean)false, (int)2, null)) {
            return null;
        }
        String string = path.substring(0, path.length() - 4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String modifiedPath = string + "@" + width + "x" + height + ".svg";
        Icon icon2 = IconLoaderKt.findIconUsingNewImplementation$default((String)modifiedPath, (ClassLoader)((ClassLoader)coords.getSecond()), null, (int)4, null);
        if (icon2 == null) {
            return null;
        }
        Icon foundIcon = icon2;
        if (foundIcon instanceof CachedImageIcon && ((CachedImageIcon)foundIcon).getIconWidth() == JBUIScale.scale((int)width) && ((CachedImageIcon)foundIcon).getIconHeight() == JBUIScale.scale((int)height)) {
            if (isDark == null) {
                return ((CachedImageIcon)foundIcon).withAnotherIconModifications(icon);
            }
            return (Icon)((CachedImageIcon)foundIcon).getDarkIcon(isDark.booleanValue());
        }
        return null;
    }

    static /* synthetic */ Icon loadIconCustomVersion$default(CachedImageIcon cachedImageIcon, int n, int n2, Boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = null;
        }
        return CustomIconUtilKt.loadIconCustomVersion(cachedImageIcon, n, n2, bl);
    }

    @ApiStatus.Internal
    @NotNull
    public static final Icon loadIconCustomVersionOrScale(@NotNull ScalableIcon icon, int size) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (icon.getIconWidth() == JBUIScale.scale((int)size)) {
            return (Icon)icon;
        }
        Icon cachedIcon = (Icon)icon;
        if (!(cachedIcon instanceof CachedImageIcon)) {
            if (cachedIcon instanceof RetrievableIcon) {
                Icon icon2 = ((RetrievableIcon)cachedIcon).retrieveIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"retrieveIcon(...)");
                cachedIcon = icon2;
            }
            if (!(cachedIcon instanceof CachedImageIcon)) {
                Icon icon3 = icon.scale(JBUIScale.scale((float)1.0f) * (float)size / (float)icon.getIconWidth() * icon.getScale());
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"scale(...)");
                Icon result = icon3;
                return result;
            }
        }
        return CustomIconUtilKt.loadIconCustomVersionOrScale$default((CachedImageIcon)cachedIcon, size, null, null, 8, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static final Icon loadIconCustomVersionOrScale(@NotNull CachedImageIcon icon, int size, @Nullable Boolean isDark, @Nullable Boolean isDarkForScale) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (icon.getIconWidth() == JBUIScale.scale((int)size)) {
            Boolean bl = isDark;
            return bl == null ? (Icon)icon : (Icon)icon.getDarkIcon(bl.booleanValue());
        }
        Icon icon2 = CustomIconUtilKt.loadIconCustomVersion(icon, size, size, isDark);
        if (icon2 != null) {
            Icon it = icon2;
            boolean bl = false;
            return it;
        }
        return (Icon)CachedImageIcon.scale$default((CachedImageIcon)icon, (float)(JBUIScale.scale((float)1.0f) * (float)size / (float)icon.getRawIconWidth()), null, (Boolean)isDarkForScale, (int)2, null);
    }

    public static /* synthetic */ Icon loadIconCustomVersionOrScale$default(CachedImageIcon cachedImageIcon, int n, Boolean bl, Boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = null;
        }
        if ((n2 & 8) != 0) {
            bl2 = null;
        }
        return CustomIconUtilKt.loadIconCustomVersionOrScale(cachedImageIcon, n, bl, bl2);
    }
}

