/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.IconWithOverlay;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.util.IconUtil;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0000H\u0016J\b\u0010\r\u001a\u00020\u0000H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ui/icons/IconWithRectangularOverlay;", "Lcom/intellij/ui/icons/IconWithOverlay;", "main", "Ljavax/swing/Icon;", "overlay", "overlayArea", "Ljava/awt/Rectangle;", "<init>", "(Ljavax/swing/Icon;Ljavax/swing/Icon;Ljava/awt/Rectangle;)V", "replaceBy", "replacer", "Lcom/intellij/ui/icons/IconReplacer;", "copy", "deepCopy", "getOverlayShape", "Ljava/awt/Shape;", "x", "", "y", "intellij.platform.core.ui"})
public final class IconWithRectangularOverlay
extends IconWithOverlay {
    @NotNull
    private final Rectangle overlayArea;

    public IconWithRectangularOverlay(@NotNull Icon main, @NotNull Icon overlay, @NotNull Rectangle overlayArea) {
        Intrinsics.checkNotNullParameter((Object)main, (String)"main");
        Intrinsics.checkNotNullParameter((Object)overlay, (String)"overlay");
        Intrinsics.checkNotNullParameter((Object)overlayArea, (String)"overlayArea");
        super(main, overlay);
        this.overlayArea = overlayArea;
    }

    @Override
    @NotNull
    public IconWithRectangularOverlay replaceBy(@NotNull IconReplacer replacer2) {
        Intrinsics.checkNotNullParameter((Object)replacer2, (String)"replacer");
        Icon icon = replacer2.replaceIcon(this.getMainIcon());
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"replaceIcon(...)");
        Icon icon2 = replacer2.replaceIcon(this.getOverlayIcon());
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"replaceIcon(...)");
        return new IconWithRectangularOverlay(icon, icon2, this.overlayArea);
    }

    @Override
    @NotNull
    public IconWithRectangularOverlay copy() {
        Icon icon = this.getMainIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getMainIcon(...)");
        Icon icon2 = this.getOverlayIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getOverlayIcon(...)");
        return new IconWithRectangularOverlay(icon, icon2, this.overlayArea);
    }

    @Override
    @NotNull
    public IconWithRectangularOverlay deepCopy() {
        Icon icon = this.getMainIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getMainIcon(...)");
        Icon icon2 = IconUtil.copy(icon, null);
        Icon icon3 = this.getOverlayIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getOverlayIcon(...)");
        return new IconWithRectangularOverlay(icon2, IconUtil.copy(icon3, null), this.overlayArea);
    }

    @Override
    @NotNull
    public Shape getOverlayShape(int x, int y) {
        float scale2 = (float)this.getScale(DerivedScaleType.EFF_USR_SCALE);
        return new Rectangle2D.Float((float)x + scale2 * (float)this.overlayArea.x, (float)y + scale2 * (float)this.overlayArea.y, scale2 * (float)this.overlayArea.width, scale2 * (float)this.overlayArea.height);
    }
}

