/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.ui.BadgeShapeProvider;
import com.intellij.ui.icons.HoledIcon;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ui/icons/TextHoledIcon;", "Lcom/intellij/ui/icons/HoledIcon;", "icon", "Ljavax/swing/Icon;", "text", "", "fontSize", "", "plainColor", "Ljava/awt/Color;", "provider", "Lcom/intellij/ui/BadgeShapeProvider;", "<init>", "(Ljavax/swing/Icon;Ljava/lang/String;FLjava/awt/Color;Lcom/intellij/ui/BadgeShapeProvider;)V", "getText", "()Ljava/lang/String;", "getFontSize", "()F", "copyWith", "createHole", "Ljava/awt/Shape;", "width", "", "height", "paintHole", "", "g", "Ljava/awt/Graphics2D;", "replaceBy", "replacer", "Lcom/intellij/ui/icons/IconReplacer;", "intellij.platform.core.ui"})
@ApiStatus.Internal
public final class TextHoledIcon
extends HoledIcon {
    @NotNull
    private final String text;
    private final float fontSize;
    @NotNull
    private final Color plainColor;
    @NotNull
    private final BadgeShapeProvider provider;

    public TextHoledIcon(@NotNull Icon icon, @NotNull String text, float fontSize, @NotNull Color plainColor, @NotNull BadgeShapeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)plainColor, (String)"plainColor");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super(icon);
        this.text = text;
        this.fontSize = fontSize;
        this.plainColor = plainColor;
        this.provider = provider;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final float getFontSize() {
        return this.fontSize;
    }

    @Override
    @NotNull
    protected Icon copyWith(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Nullable
    protected Shape createHole(int width, int height) {
        return this.provider.createShape(width, height, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintHole(@NotNull Graphics2D g, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Shape shape = this.provider.createShape(width, height, false);
        if (shape == null) {
            return;
        }
        Shape shape2 = shape;
        Rectangle bounds = shape2.getBounds();
        Pair pair = TuplesKt.to((Object)bounds.x, (Object)bounds.y);
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D customG = (Graphics2D)graphics;
        try {
            JBFont jBFont = JBFont.create((Font)((Font)JBFont.label().deriveFont((float)this.scaleVal(this.fontSize, ScaleType.OBJ_SCALE)).asBold()));
            Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"create(...)");
            JBFont font = jBFont;
            LineMetrics lineMetrics = font.getLineMetrics(this.text, customG.getFontRenderContext());
            lineMetrics.getAscent();
            GraphicsUtil.setupAntialiasing((Graphics)customG);
            customG.setFont((Font)font);
            int xText = (int)this.scaleVal(x, ScaleType.OBJ_SCALE);
            int textHeight = (int)lineMetrics.getAscent();
            int yText = (int)this.scaleVal(y, ScaleType.OBJ_SCALE) + textHeight;
            customG.setColor(this.plainColor);
            customG.drawString(this.text, xText, yText);
        }
        finally {
            customG.dispose();
        }
    }

    @NotNull
    public Icon replaceBy(@NotNull IconReplacer replacer2) {
        Intrinsics.checkNotNullParameter((Object)replacer2, (String)"replacer");
        Icon icon = replacer2.replaceIcon(this.getIcon());
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"replaceIcon(...)");
        return (Icon)((Object)new TextHoledIcon(icon, this.text, this.fontSize, this.plainColor, this.provider));
    }
}

