/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.ui.JBColor;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020!H\u0016J\b\u0010$\u001a\u00020!H\u0016J\b\u0010%\u001a\u00020\u001cH\u0002J\u0013\u0010&\u001a\u00020\u00162\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00050\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lcom/intellij/ui/icons/TextIcon;", "Lcom/intellij/util/ui/JBScalableIcon;", "text", "", "component", "Ljava/awt/Component;", "fontSize", "", "<init>", "(Ljava/lang/String;Ljava/awt/Component;F)V", "getText", "()Ljava/lang/String;", "getFontSize", "()F", "font", "Ljava/awt/Font;", "metrics", "Ljava/awt/FontMetrics;", "componentRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "highlight", "", "getHighlight", "()Z", "setHighlight", "(Z)V", "paintIcon", "", "c", "g", "Ljava/awt/Graphics;", "x", "", "y", "getIconWidth", "getIconHeight", "update", "equals", "other", "", "hashCode", "intellij.platform.core.ui"})
public final class TextIcon
extends JBScalableIcon {
    @NotNull
    private final String text;
    private final float fontSize;
    @Nullable
    private Font font;
    @Nullable
    private FontMetrics metrics;
    @NotNull
    private final WeakReference<Component> componentRef;
    private boolean highlight;

    public TextIcon(@NotNull String text, @NotNull Component component2, float fontSize) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.text = text;
        this.fontSize = fontSize;
        this.componentRef = new WeakReference<Component>(component2);
        this.highlight = true;
        this.setIconPreScaled(false);
        this.getScaleContext().addUpdateListener(() -> TextIcon._init_$lambda$0(this));
        this.update();
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final float getFontSize() {
        return this.fontSize;
    }

    public final boolean getHighlight() {
        return this.highlight;
    }

    public final void setHighlight(boolean bl) {
        this.highlight = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics customG = g.create();
        try {
            GraphicsUtil.setupAntialiasing((Graphics)customG);
            customG.setFont(this.font);
            int strX = (int)this.scaleVal(x, ScaleType.OBJ_SCALE) + (int)this.scaleVal(2.0);
            int n = (int)this.scaleVal(y, ScaleType.OBJ_SCALE) + this.getIconHeight();
            FontMetrics fontMetrics = this.metrics;
            Intrinsics.checkNotNull((Object)fontMetrics);
            int strY = n - fontMetrics.getDescent() - (int)this.scaleVal(1.0);
            if (this.highlight) {
                UIUtil.drawStringWithHighlighting((Graphics)customG, (String)this.text, (int)strX, (int)strY, (Color)JBColor.foreground(), (Color)JBColor.background());
            } else {
                customG.setColor(JBColor.foreground());
                customG.drawString(this.text, strX, strY);
            }
        }
        finally {
            customG.dispose();
        }
    }

    public int getIconWidth() {
        FontMetrics fontMetrics = this.metrics;
        Intrinsics.checkNotNull((Object)fontMetrics);
        return fontMetrics.stringWidth(this.text) + (int)this.scaleVal(4.0);
    }

    public int getIconHeight() {
        FontMetrics fontMetrics = this.metrics;
        Intrinsics.checkNotNull((Object)fontMetrics);
        return fontMetrics.getHeight();
    }

    private final void update() {
        this.font = (Font)JBFont.create((Font)((Font)JBFont.label().deriveFont((float)this.scaleVal(this.fontSize, ScaleType.OBJ_SCALE))));
        Component component2 = (Component)this.componentRef.get();
        if (component2 == null) {
            component2 = new Component(){};
        }
        this.metrics = component2.getFontMetrics(this.font);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextIcon)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((TextIcon)((Object)other)).text)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.font, (Object)((TextIcon)((Object)other)).font);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + Float.hashCode(this.fontSize);
        Font font = this.font;
        result = 31 * result + (font != null ? font.hashCode() : 0);
        FontMetrics fontMetrics = this.metrics;
        result = 31 * result + (fontMetrics != null ? fontMetrics.hashCode() : 0);
        result = 31 * result + this.componentRef.hashCode();
        return result;
    }

    private static final void _init_$lambda$0(TextIcon this$0) {
        this$0.update();
    }
}

