/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.awt.Color;
import java.awt.image.RGBImageFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/ColorFilter;", "Ljava/awt/image/RGBImageFilter;", "color", "Ljava/awt/Color;", "keepGray", "", "keepBrightness", "<init>", "(Ljava/awt/Color;ZZ)V", "getColor", "()Ljava/awt/Color;", "getKeepGray", "()Z", "getKeepBrightness", "base", "", "kotlin.jvm.PlatformType", "filterRGB", "", "x", "y", "rgba", "intellij.platform.core.ui"})
@ApiStatus.Internal
public final class ColorFilter
extends RGBImageFilter {
    @NotNull
    private final Color color;
    private final boolean keepGray;
    private final boolean keepBrightness;
    private final float[] base;

    public ColorFilter(@NotNull Color color, boolean keepGray, boolean keepBrightness) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.color = color;
        this.keepGray = keepGray;
        this.keepBrightness = keepBrightness;
        this.base = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final boolean getKeepGray() {
        return this.keepGray;
    }

    public final boolean getKeepBrightness() {
        return this.keepBrightness;
    }

    @Override
    public int filterRGB(int x, int y, int rgba) {
        int r = rgba >> 16 & 0xFF;
        int g = rgba >> 8 & 0xFF;
        int b = rgba & 0xFF;
        float[] hsb = new float[3];
        Color.RGBtoHSB(r, g, b, hsb);
        int rgb = Color.HSBtoRGB(this.base[0], this.base[1] * (this.keepGray ? hsb[1] : 1.0f), this.base[2] * (this.keepBrightness ? hsb[2] : 1.0f));
        return rgba & 0xFF000000 | rgb & 0xFFFFFF;
    }
}

