/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.icons.AllIcons;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LastComputedIconCache;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.IconManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.ReplaceableIcon;
import com.intellij.ui.icons.RgbImageFilterSupplier;
import com.intellij.ui.icons.TextIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextAware;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.BrighterFilter;
import com.intellij.util.ColorFilter;
import com.intellij.util.CropIcon;
import com.intellij.util.DarkerFilter;
import com.intellij.util.DesaturationFilter;
import com.intellij.util.FileIconKey;
import com.intellij.util.IconSizeWrapper;
import com.intellij.util.IconUtilKt;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.MainColorFilter;
import com.intellij.util.PlatformIcons;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J$\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J$\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\"\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0015H\u0007J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0012H\u0007J\u001c\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u001a\u0010#\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010%\u001a\u00020\u0012H\u0007J\"\u0010#\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010%\u001a\u00020\u0012H\u0007J \u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\"\u0010N\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010O\u001a\u00020\u00062\u0006\u0010P\u001a\u00020\u0006H\u0007J:\u0010Q\u001a\u00020I2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010L\u001a\u00020M2\u0006\u0010T\u001a\u00020\u00062\u0006\u0010U\u001a\u00020\u00062\u0006\u0010V\u001a\u00020\u0012H\u0007J\u0014\u0010W\u001a\u0004\u0018\u00010\n2\b\u0010X\u001a\u0004\u0018\u00010\nH\u0007J\u0018\u0010Y\u001a\u00020\n2\u0006\u0010Z\u001a\u00020\n2\u0006\u0010Y\u001a\u00020[H\u0007J\u0018\u0010\\\u001a\u00020\n2\u0006\u0010Z\u001a\u00020\n2\u0006\u0010]\u001a\u00020\u0006H\u0007J \u0010^\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010_\u001a\u00020\u00062\u0006\u0010`\u001a\u00020\u0006H\u0007J\u001a\u0010a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010b\u001a\u0004\u0018\u00010KH\u0007J\u0018\u0010c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010b\u001a\u0004\u0018\u00010KJ\"\u0010Y\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010b\u001a\u0004\u0018\u00010K2\u0006\u0010Y\u001a\u00020dH\u0007J\u0018\u0010Y\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010e\u001a\u00020\"H\u0007J\"\u0010f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010b\u001a\u0004\u0018\u00010K2\u0006\u0010g\u001a\u00020dH\u0007J$\u0010h\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010b\u001a\u0004\u0018\u00010K2\u0006\u0010i\u001a\u00020\nH\u0007J,\u0010j\u001a\u00020\n2\u0006\u0010Z\u001a\u00020\n2\u0006\u0010k\u001a\u00020l2\b\b\u0002\u0010m\u001a\u00020\u00122\b\b\u0002\u0010n\u001a\u00020\u0012H\u0007J6\u0010j\u001a\u00020\n2\b\u0010L\u001a\u0004\u0018\u00010o2\u0006\u0010Z\u001a\u00020\n2\u0006\u0010k\u001a\u00020l2\b\b\u0002\u0010m\u001a\u00020\u00122\b\b\u0002\u0010n\u001a\u00020\u0012H\u0007J\u0010\u0010p\u001a\u00020\n2\u0006\u0010Z\u001a\u00020\nH\u0007J\u0018\u0010q\u001a\u00020\n2\u0006\u0010Z\u001a\u00020\n2\u0006\u0010r\u001a\u00020\u0006H\u0007J\u0018\u0010s\u001a\u00020\n2\u0006\u0010Z\u001a\u00020\n2\u0006\u0010r\u001a\u00020\u0006H\u0007J\u0010\u0010t\u001a\u00020l2\u0006\u0010Z\u001a\u00020\nH\u0007J\u0010\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020 H\u0007J \u0010x\u001a\u00020\n2\u0006\u0010y\u001a\u00020z2\u0006\u0010R\u001a\u00020K2\u0006\u0010g\u001a\u00020dH\u0007J\u0018\u0010{\u001a\u00020\n2\u0006\u0010|\u001a\u00020\n2\u0006\u0010y\u001a\u00020zH\u0007J+\u0010}\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u000f\u0010~\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u0080\u00010\u007f2\b\u0010b\u001a\u0004\u0018\u00010KH\u0007J'\u0010\u0081\u0001\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0007\u0010\u0082\u0001\u001a\u00020\n2\u0007\u0010\u0083\u0001\u001a\u00020\nH\u0007J!\u0010\u0084\u0001\u001a\u0004\u0018\u00010\n2\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010\n2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010\nH\u0007J\u0011\u0010\u0087\u0001\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010&\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b'\u0010\u0003\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010\u0003\u001a\u0004\b,\u0010)R\u001a\u0010-\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010\u0003\u001a\u0004\b/\u0010)R\u001a\u00100\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b1\u0010\u0003\u001a\u0004\b2\u0010)R\u001a\u00103\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010\u0003\u001a\u0004\b5\u0010)R\u001a\u00106\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b7\u0010\u0003\u001a\u0004\b8\u0010)R\u001a\u00109\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b:\u0010\u0003\u001a\u0004\b;\u0010)R\u001a\u0010<\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b=\u0010\u0003\u001a\u0004\b>\u0010)R\u001a\u0010?\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b@\u0010\u0003\u001a\u0004\bA\u0010)R\u001a\u0010B\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bC\u0010\u0003\u001a\u0004\bD\u0010)R\u001a\u0010E\u001a\u00020\n8GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bF\u0010\u0003\u001a\u0004\bG\u0010)\u00a8\u0006\u0088\u0001"}, d2={"Lcom/intellij/util/IconUtil;", "", "<init>", "()V", "ICON_FLAG_IGNORE_MASK", "Lcom/intellij/openapi/util/Key;", "", "getICON_FLAG_IGNORE_MASK", "()Lcom/intellij/openapi/util/Key;", "cropIcon", "Ljavax/swing/Icon;", "icon", "maxWidth", "maxHeight", "area", "Ljava/awt/Rectangle;", "flip", "horizontal", "", "computeFileIcon", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "flags", "project", "Lcom/intellij/openapi/project/Project;", "getIcon", "getIconImpl", "computeBaseFileIcon", "vFile", "getEmptyIcon", "showVisibility", "toImage", "Ljava/awt/Image;", "context", "Lcom/intellij/ui/scale/ScaleContext;", "toBufferedImage", "Ljava/awt/image/BufferedImage;", "inUserScale", "addIcon", "getAddIcon$annotations", "getAddIcon", "()Ljavax/swing/Icon;", "removeIcon", "getRemoveIcon$annotations", "getRemoveIcon", "moveUpIcon", "getMoveUpIcon$annotations", "getMoveUpIcon", "moveDownIcon", "getMoveDownIcon$annotations", "getMoveDownIcon", "editIcon", "getEditIcon$annotations", "getEditIcon", "addClassIcon", "getAddClassIcon$annotations", "getAddClassIcon", "addPatternIcon", "getAddPatternIcon$annotations", "getAddPatternIcon", "addBlankLineIcon", "getAddBlankLineIcon$annotations", "getAddBlankLineIcon", "addPackageIcon", "getAddPackageIcon$annotations", "getAddPackageIcon", "addLinkIcon", "getAddLinkIcon$annotations", "getAddLinkIcon", "analyzeIcon", "getAnalyzeIcon$annotations", "getAnalyzeIcon", "paintInCenterOf", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "toSize", "width", "height", "paintSelectionAwareIcon", "component", "Ljavax/swing/JComponent;", "x", "y", "selected", "wrapToSelectionAwareIcon", "iconUnderSelection", "scale", "source", "", "resizeSquared", "size", "downscaleIconToSize", "maxIconWidth", "maxIconHeight", "copy", "ancestor", "deepCopy", "", "scaleContext", "scaleByFont", "fontSize", "scaleByIconWidth", "defaultIcon", "colorize", "color", "Ljava/awt/Color;", "keepGray", "keepBrightness", "Ljava/awt/Graphics2D;", "desaturate", "brighter", "tones", "darker", "mainColor", "createImageIcon", "Lcom/intellij/util/ui/JBImageIcon;", "image", "textToIcon", "text", "", "addText", "base", "filterIcon", "filterSupplier", "Ljava/util/function/Supplier;", "Ljava/awt/image/RGBImageFilter;", "replaceInnerIcon", "toCheck", "toReplace", "rowIcon", "left", "right", "deepRetrieveIconNow", "intellij.platform.core.ui"})
public final class IconUtil {
    @NotNull
    public static final IconUtil INSTANCE = new IconUtil();
    @NotNull
    private static final Key<Integer> ICON_FLAG_IGNORE_MASK = new Key("ICON_FLAG_IGNORE_MASK");

    private IconUtil() {
    }

    @NotNull
    public final Key<Integer> getICON_FLAG_IGNORE_MASK() {
        return ICON_FLAG_IGNORE_MASK;
    }

    @JvmStatic
    @NotNull
    public static final Icon cropIcon(@NotNull Icon icon, int maxWidth, int maxHeight) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        int maxWidth2 = maxWidth;
        int maxHeight2 = maxHeight;
        if (icon.getIconHeight() <= maxHeight2 && icon.getIconWidth() <= maxWidth2) {
            return icon;
        }
        Image image = null;
        Image image2 = IconLoader.toImage((Icon)icon, null);
        if (image2 == null) {
            return icon;
        }
        image = image2;
        double scale2 = 1.0;
        if (image instanceof JBHiDPIScaledImage) {
            Image hdpi = image;
            scale2 = ((JBHiDPIScaledImage)hdpi).getScale();
            Image image3 = ((JBHiDPIScaledImage)hdpi).getDelegate();
            if (image3 != null) {
                Image it = image3;
                boolean bl = false;
                image = it;
            }
        }
        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(...)");
        BufferedImage bi = bufferedImage;
        Graphics2D g = bi.createGraphics();
        int imageWidth = ImageUtil.getRealWidth((Image)image);
        int imageHeight = ImageUtil.getRealHeight((Image)image);
        maxWidth2 = maxWidth2 == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)MathKt.roundToLong((double)((double)maxWidth2 * scale2));
        maxHeight2 = maxHeight2 == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)MathKt.roundToLong((double)((double)maxHeight2 * scale2));
        int w = Math.min(imageWidth, maxWidth2);
        int h = Math.min(imageHeight, maxHeight2);
        BufferedImage bufferedImage2 = ImageUtil.createImage((Graphics)g, (int)w, (int)h, (int)3);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"createImage(...)");
        BufferedImage img = bufferedImage2;
        int offX = imageWidth > maxWidth2 ? (imageWidth - maxWidth2) / 2 : 0;
        int offY = imageHeight > maxHeight2 ? (imageHeight - maxHeight2) / 2 : 0;
        for (int col = 0; col < w; ++col) {
            for (int row = 0; row < h; ++row) {
                img.setRGB(col, row, bi.getRGB(col + offX, row + offY));
            }
        }
        g.dispose();
        Image image4 = RetinaImage.createFrom((Image)img, (double)scale2, null);
        Intrinsics.checkNotNullExpressionValue((Object)image4, (String)"createFrom(...)");
        return (Icon)new JBImageIcon(image4);
    }

    @JvmStatic
    @NotNull
    public static final Icon cropIcon(@NotNull Icon icon, @NotNull Rectangle area) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        return new Rectangle(icon.getIconWidth(), icon.getIconHeight()).contains(area) ? (Icon)new CropIcon(icon, area) : icon;
    }

    @JvmStatic
    @NotNull
    public static final Icon flip(@NotNull Icon icon, boolean horizontal) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return new Icon(horizontal, icon){
            final /* synthetic */ boolean $horizontal;
            final /* synthetic */ Icon $icon;
            {
                this.$horizontal = $horizontal;
                this.$icon = $icon;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2d = (Graphics2D)graphics;
                try {
                    AffineTransform transform = AffineTransform.getTranslateInstance(this.$horizontal ? x + this.getIconWidth() : x, this.$horizontal ? y : y + this.getIconHeight());
                    transform.concatenate(AffineTransform.getScaleInstance(this.$horizontal ? -1 : 1, this.$horizontal ? 1 : -1));
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    this.$icon.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            public int getIconWidth() {
                return this.$icon.getIconWidth();
            }

            public int getIconHeight() {
                return this.$icon.getIconHeight();
            }

            public String toString() {
                return "IconUtil.flip for " + this.$icon;
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final Icon computeFileIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isValid() || project != null && project.isDisposed()) {
            Icon icon = AllIcons.FileTypes.Unknown;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Unknown");
            return icon;
        }
        VirtualFile virtualFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOriginFileIfBacked(...)");
        return IconUtilKt.computeFileIconImpl(virtualFile, project, flags);
    }

    @JvmStatic
    @NotNull
    public static final Icon getIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOriginFileIfBacked(...)");
        return INSTANCE.getIconImpl(virtualFile, flags, project);
    }

    private final Icon getIconImpl(VirtualFile file, int flags, Project project) {
        Icon lastIcon = LastComputedIconCache.get((UserDataHolder)((UserDataHolder)file), (int)flags);
        Icon icon = lastIcon;
        if (icon == null) {
            icon = IconUtil.computeBaseFileIcon(file);
        }
        Icon base = icon;
        return IconManager.Companion.getInstance().createDeferredIcon(base, (Object)new FileIconKey(file, project, flags), IconUtilKt.access$getICON_NULLABLE_FUNCTION$p());
    }

    @JvmStatic
    @NotNull
    public static final Icon computeBaseFileIcon(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        return IconUtilKt.access$computeFileTypeIcon(vFile, true);
    }

    @JvmStatic
    @NotNull
    public static final Icon getEmptyIcon(boolean showVisibility) {
        RowIcon baseIcon = new RowIcon(2, null, 2, null);
        baseIcon.setIcon((Icon)EmptyIcon.create((Icon)IconManager.Companion.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Class)), 0);
        if (showVisibility) {
            baseIcon.setIcon((Icon)EmptyIcon.create((Icon)PlatformIcons.PUBLIC_ICON), 1);
        }
        return (Icon)((Object)baseIcon);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Image toImage(@NotNull Icon icon, @Nullable ScaleContext context) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Image image = IconLoader.toImage((Icon)icon, (ScaleContext)context);
        if (image == null) {
            image = new BufferedImage(1, 0, 2);
        }
        return image;
    }

    public static /* synthetic */ Image toImage$default(Icon icon, ScaleContext scaleContext, int n, Object object) {
        if ((n & 2) != 0) {
            scaleContext = null;
        }
        return IconUtil.toImage(icon, scaleContext);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BufferedImage toBufferedImage(@NotNull Icon icon, boolean inUserScale) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return IconUtil.toBufferedImage(icon, null, inUserScale);
    }

    public static /* synthetic */ BufferedImage toBufferedImage$default(Icon icon, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return IconUtil.toBufferedImage(icon, bl);
    }

    @JvmStatic
    @NotNull
    public static final BufferedImage toBufferedImage(@NotNull Icon icon, @Nullable ScaleContext context, boolean inUserScale) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Image image = IconLoader.toImage((Icon)icon, (ScaleContext)context);
        if (image == null) {
            image = new BufferedImage(1, 0, 2);
        }
        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image, (boolean)inUserScale);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(...)");
        return bufferedImage;
    }

    @NotNull
    public static final Icon getAddIcon() {
        Icon icon = AllIcons.General.Add;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Add");
        return icon;
    }

    @JvmStatic
    public static /* synthetic */ void getAddIcon$annotations() {
    }

    @NotNull
    public static final Icon getRemoveIcon() {
        Icon icon = AllIcons.General.Remove;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Remove");
        return icon;
    }

    @JvmStatic
    public static /* synthetic */ void getRemoveIcon$annotations() {
    }

    @NotNull
    public static final Icon getMoveUpIcon() {
        Icon icon = AllIcons.Actions.MoveUp;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MoveUp");
        return icon;
    }

    @JvmStatic
    public static /* synthetic */ void getMoveUpIcon$annotations() {
    }

    @NotNull
    public static final Icon getMoveDownIcon() {
        Icon icon = AllIcons.Actions.MoveDown;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MoveDown");
        return icon;
    }

    @JvmStatic
    public static /* synthetic */ void getMoveDownIcon$annotations() {
    }

    @NotNull
    public static final Icon getEditIcon() {
        Icon icon = AllIcons.Actions.Edit;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Edit");
        return icon;
    }

    @JvmStatic
    public static /* synthetic */ void getEditIcon$annotations() {
    }

    @NotNull
    public static final Icon getAddClassIcon() {
        Icon icon = AllIcons.ToolbarDecorator.AddClass;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AddClass");
        return icon;
    }

    @JvmStatic
    public static /* synthetic */ void getAddClassIcon$annotations() {
    }

    @NotNull
    public static final Icon getAddPatternIcon() {
        Icon icon = AllIcons.ToolbarDecorator.AddPattern;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AddPattern");
        return icon;
    }

    @JvmStatic
    public static /* synthetic */ void getAddPatternIcon$annotations() {
    }

    @NotNull
    public static final Icon getAddBlankLineIcon() {
        Icon icon = AllIcons.ToolbarDecorator.AddBlankLine;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AddBlankLine");
        return icon;
    }

    @JvmStatic
    public static /* synthetic */ void getAddBlankLineIcon$annotations() {
    }

    @NotNull
    public static final Icon getAddPackageIcon() {
        Icon icon = AllIcons.ToolbarDecorator.AddFolder;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AddFolder");
        return icon;
    }

    @JvmStatic
    public static /* synthetic */ void getAddPackageIcon$annotations() {
    }

    @NotNull
    public static final Icon getAddLinkIcon() {
        Icon icon = AllIcons.ToolbarDecorator.AddLink;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AddLink");
        return icon;
    }

    @JvmStatic
    public static /* synthetic */ void getAddLinkIcon$annotations() {
    }

    @Deprecated(message="This icon is not used by platform anymore.")
    @NotNull
    public static final Icon getAnalyzeIcon() {
        String string = IconUtilKt.access$getToolbarDecoratorIconsFolder() + "analyze.png";
        ClassLoader classLoader = IconUtil.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return IconLoader.getIcon((String)string, (ClassLoader)classLoader);
    }

    @JvmStatic
    public static /* synthetic */ void getAnalyzeIcon$annotations() {
    }

    @JvmStatic
    public static final void paintInCenterOf(@NotNull Component c, @NotNull Graphics g, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        int x = (c.getWidth() - icon.getIconWidth()) / 2;
        int y = (c.getHeight() - icon.getIconHeight()) / 2;
        icon.paintIcon(c, g, x, y);
    }

    @JvmStatic
    @NotNull
    public static final Icon toSize(@Nullable Icon icon, int width, int height) {
        return new IconSizeWrapper(icon, width, height);
    }

    @JvmStatic
    public static final void paintSelectionAwareIcon(@NotNull Icon icon, @Nullable JComponent component2, @NotNull Graphics g, int x, int y, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (selected) {
            SvgKt.paintIconWithSelection((Icon)icon, (Component)component2, (Graphics)g, (int)x, (int)y);
        } else {
            icon.paintIcon(component2, g, x, y);
        }
    }

    @JvmStatic
    @ApiStatus.Internal
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final Icon wrapToSelectionAwareIcon(@Nullable Icon iconUnderSelection) {
        if (iconUnderSelection == null) {
            return null;
        }
        return new Icon(iconUnderSelection){
            final /* synthetic */ Icon $iconUnderSelection;
            {
                this.$iconUnderSelection = $iconUnderSelection;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                SvgKt.paintIconWithSelection((Icon)this.$iconUnderSelection, (Component)c, (Graphics)g, (int)x, (int)y);
            }

            public int getIconWidth() {
                return this.$iconUnderSelection.getIconWidth();
            }

            public int getIconHeight() {
                return this.$iconUnderSelection.getIconHeight();
            }

            public String toString() {
                return "IconUtil.wrapToSelectionAwareIcon for " + this.$iconUnderSelection;
            }
        };
    }

    @Deprecated(message="use {@link #scale(Icon, Component, float)}")
    @JvmStatic
    @NotNull
    public static final Icon scale(@NotNull Icon source, double scale2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new Icon(scale2, source){
            private final double clampedScale;
            final /* synthetic */ Icon $source;
            {
                this.$source = $source;
                this.clampedScale = IconUtilKt.access$clampScale($scale);
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                IconUtilKt.access$paintScaled(c, g, x, y, this.clampedScale, this.$source);
            }

            public int getIconWidth() {
                return (int)((double)this.$source.getIconWidth() * this.clampedScale);
            }

            public int getIconHeight() {
                return (int)((double)this.$source.getIconHeight() * this.clampedScale);
            }

            public String toString() {
                return "IconUtil.scale for " + this.$source;
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final Icon resizeSquared(@NotNull Icon source, int size) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new Icon(size, source){
            private final JBValue sizeValue;
            final /* synthetic */ Icon $source;
            {
                this.$source = $source;
                JBValue jBValue = JBUI.uiIntValue((String)"ResizedIcon", (int)$size);
                Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"uiIntValue(...)");
                this.sizeValue = jBValue;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                double scale2 = IconUtilKt.access$clampScale((double)this.sizeValue.get() / (double)this.$source.getIconWidth());
                IconUtilKt.access$paintScaled(c, g, x, y, scale2, this.$source);
            }

            public int getIconWidth() {
                return this.sizeValue.get();
            }

            public int getIconHeight() {
                return this.sizeValue.get();
            }

            public String toString() {
                return "IconUtil.resizeSquared for " + this.$source;
            }
        };
    }

    @JvmStatic
    @ApiStatus.Experimental
    @NotNull
    public static final Icon downscaleIconToSize(@NotNull Icon icon, int maxIconWidth, int maxIconHeight) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        float scale2 = Math.min((float)maxIconWidth / (float)icon.getIconWidth(), (float)maxIconHeight / (float)icon.getIconHeight());
        if ((double)scale2 >= 1.0) {
            return icon;
        }
        if (Math.abs(scale2 - 1.0f) < 0.01f) {
            return icon;
        }
        float currentScale = icon instanceof ScalableIcon ? ((ScalableIcon)icon).getScale() : 1.0f;
        return IconUtil.scale(icon, null, scale2 * currentScale);
    }

    @JvmStatic
    @NotNull
    public static final Icon copy(@NotNull Icon icon, @Nullable Component ancestor) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return com.intellij.ui.icons.IconUtilKt.copyIcon((Icon)icon, (Component)ancestor, (boolean)false);
    }

    @NotNull
    public final Icon deepCopy(@NotNull Icon icon, @Nullable Component ancestor) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return com.intellij.ui.icons.IconUtilKt.copyIcon((Icon)icon, (Component)ancestor, (boolean)true);
    }

    @JvmStatic
    @NotNull
    public static final Icon scale(@NotNull Icon icon, @Nullable Component ancestor, float scale2) {
        ScaleContext scaleContext;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (icon instanceof CachedImageIcon) {
            return (Icon)CachedImageIcon.scale$default((CachedImageIcon)((CachedImageIcon)icon), (float)scale2, (Component)ancestor, null, (int)4, null);
        }
        if (ancestor == null && icon instanceof ScaleContextAware) {
            UserScaleContext userScaleContext = ((ScaleContextAware)icon).getScaleContext();
            Intrinsics.checkNotNullExpressionValue((Object)userScaleContext, (String)"getScaleContext(...)");
            scaleContext = ScaleContext.Companion.create(userScaleContext);
        } else {
            scaleContext = ScaleContext.Companion.create(ancestor);
        }
        ScaleContext scaleContext2 = scaleContext;
        scaleContext2.setScale(ScaleType.OBJ_SCALE.of(scale2));
        return IconUtil.scale(icon, scaleContext2);
    }

    @JvmStatic
    @NotNull
    public static final Icon scale(@NotNull Icon icon, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        double scale2 = scaleContext.getScale(ScaleType.OBJ_SCALE);
        if (!(icon instanceof CopyableIcon)) {
            return IconUtil.scale(icon, scale2);
        }
        Icon icon2 = ((CopyableIcon)icon).deepCopy();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"deepCopy(...)");
        Icon copiedIcon = icon2;
        if (!(copiedIcon instanceof ScalableIcon)) {
            return IconUtil.scale(copiedIcon, scale2);
        }
        if (copiedIcon instanceof ScaleContextAware) {
            ScaleContext newScaleContext = (ScaleContext)scaleContext.copy();
            newScaleContext.setScale(ScaleType.OBJ_SCALE.of(1.0f));
            ((ScaleContextAware)copiedIcon).updateScaleContext((UserScaleContext)newScaleContext);
        }
        Icon icon3 = ((ScalableIcon)copiedIcon).scale((float)scale2);
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"scale(...)");
        return icon3;
    }

    @JvmStatic
    @NotNull
    public static final Icon scaleByFont(@NotNull Icon icon, @Nullable Component ancestor, float fontSize) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        float scale2 = JBUIScale.getFontScale((float)fontSize);
        if (icon instanceof ScaleContextAware) {
            Component component2 = ancestor;
            UserScaleContext userScaleContext = component2 == null ? ((ScaleContextAware)icon).getScaleContext() : (UserScaleContext)ScaleContext.Companion.create(component2);
            Intrinsics.checkNotNull((Object)userScaleContext);
            UserScaleContext scaleContext = userScaleContext;
            scale2 /= (float)scaleContext.getScale(ScaleType.USR_SCALE);
        }
        return IconUtil.scale(icon, ancestor, scale2);
    }

    @JvmStatic
    @NotNull
    public static final Icon scaleByIconWidth(@Nullable Icon icon, @Nullable Component ancestor, @NotNull Icon defaultIcon) {
        Intrinsics.checkNotNullParameter((Object)defaultIcon, (String)"defaultIcon");
        return IconUtilKt.access$scaleByIcon(icon, ancestor, defaultIcon, arg_0 -> IconUtil.scaleByIconWidth$lambda$1(IconUtil::scaleByIconWidth$lambda$0, arg_0));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon colorize(@NotNull Icon source, @NotNull Color color, boolean keepGray, boolean keepBrightness) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return IconLoader.INSTANCE.filterIcon(source, new RgbImageFilterSupplier(color, keepGray, keepBrightness){
            final /* synthetic */ Color $color;
            final /* synthetic */ boolean $keepGray;
            final /* synthetic */ boolean $keepBrightness;
            {
                this.$color = $color;
                this.$keepGray = $keepGray;
                this.$keepBrightness = $keepBrightness;
            }

            public ColorFilter getFilter() {
                return new ColorFilter(this.$color, this.$keepGray, this.$keepBrightness);
            }
        });
    }

    public static /* synthetic */ Icon colorize$default(Icon icon, Color color, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return IconUtil.colorize(icon, color, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon colorize(@Nullable Graphics2D g, @NotNull Icon source, @NotNull Color color, boolean keepGray, boolean keepBrightness) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return IconUtilKt.access$filterIcon(g, source, new ColorFilter(color, keepGray, keepBrightness));
    }

    public static /* synthetic */ Icon colorize$default(Graphics2D graphics2D, Icon icon, Color color, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return IconUtil.colorize(graphics2D, icon, color, bl, bl2);
    }

    @JvmStatic
    @NotNull
    public static final Icon desaturate(@NotNull Icon source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return IconLoader.INSTANCE.filterIcon(source, new RgbImageFilterSupplier(){

            public RGBImageFilter getFilter() {
                return new DesaturationFilter();
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final Icon brighter(@NotNull Icon source, int tones) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return IconLoader.INSTANCE.filterIcon(source, new RgbImageFilterSupplier(tones){
            final /* synthetic */ int $tones;
            {
                this.$tones = $tones;
            }

            public BrighterFilter getFilter() {
                return new BrighterFilter(this.$tones);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final Icon darker(@NotNull Icon source, int tones) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return IconLoader.INSTANCE.filterIcon(source, new RgbImageFilterSupplier(tones){
            final /* synthetic */ int $tones;
            {
                this.$tones = $tones;
            }

            public DarkerFilter getFilter() {
                return new DarkerFilter(this.$tones);
            }
        });
    }

    @ApiStatus.Internal
    @NotNull
    public final Color mainColor(@NotNull Icon source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object object = source instanceof DeferredIcon ? (DeferredIcon)((Object)source) : null;
        if (object == null || (object = object.evaluate()) == null) {
            object = source;
        }
        Object icon = object;
        BufferedImage iconImage = IconUtil.toBufferedImage$default((Icon)icon, false, 2, null);
        MainColorFilter filter = new MainColorFilter();
        int n = iconImage.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = iconImage.getHeight();
            for (int y = 0; y < n2; ++y) {
                int color = iconImage.getRGB(x, y);
                filter.filterRGB(x, y, color);
            }
        }
        return filter.getMainColor();
    }

    @JvmStatic
    @NotNull
    public static final JBImageIcon createImageIcon(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return new JBImageIcon(image){
            final /* synthetic */ Image $image;
            {
                this.$image = $image;
                super($image);
            }

            public int getIconWidth() {
                return ImageUtil.getUserWidth((Image)this.$image);
            }

            public int getIconHeight() {
                return ImageUtil.getUserHeight((Image)this.$image);
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final Icon textToIcon(@NotNull String text, @NotNull Component component2, float fontSize) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        return (Icon)((Object)new TextIcon(text, component2, fontSize));
    }

    @JvmStatic
    @NotNull
    public static final Icon addText(@NotNull Icon base, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(base, 0);
        Component component2 = EDT.isCurrentThreadEdt() ? (Component)new JLabel() : (Component)new Component(){};
        icon.setIcon(IconUtil.textToIcon(text, component2, JBUIScale.scale((float)6.0f)), 1, 4);
        return (Icon)((Object)icon);
    }

    @JvmStatic
    @Deprecated(message="Please use `IconLoader.filterIcon` instead", replaceWith=@ReplaceWith(expression="IconLoader.filterIcon", imports={"com.intellij.openapi.util.IconLoader"}))
    @NotNull
    public static final Icon filterIcon(@NotNull Icon icon, @NotNull Supplier<? extends RGBImageFilter> filterSupplier, @Nullable Component ancestor) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter(filterSupplier, (String)"filterSupplier");
        return IconLoader.INSTANCE.filterIcon(icon, new RgbImageFilterSupplier(filterSupplier){
            final /* synthetic */ Supplier<? extends RGBImageFilter> $filterSupplier;
            {
                this.$filterSupplier = $filterSupplier;
            }

            public RGBImageFilter getFilter() {
                RGBImageFilter rGBImageFilter = this.$filterSupplier.get();
                Intrinsics.checkNotNullExpressionValue((Object)rGBImageFilter, (String)"get(...)");
                return rGBImageFilter;
            }
        });
    }

    @JvmStatic
    @Nullable
    public static final Icon replaceInnerIcon(@Nullable Icon icon, @NotNull Icon toCheck, @NotNull Icon toReplace) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)toCheck, (String)"toCheck");
                Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
                if (!(icon instanceof LayeredIcon)) break block4;
                for (Icon layer : ((LayeredIcon)((Object)icon)).getAllLayers()) {
                    if (layer == toCheck) {
                        layers[i] = toReplace;
                        continue;
                    }
                    IconUtil.replaceInnerIcon(layer, toCheck, toReplace);
                }
                break block5;
            }
            if (!(icon instanceof RowIcon)) break block5;
            List<Icon> allIcons = ((RowIcon)((Object)icon)).getAllIcons();
            Iterator iterator = ((Iterable)allIcons).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                Icon anIcon = (Icon)iterator.next();
                if (anIcon == toCheck) {
                    ((RowIcon)((Object)icon)).setIcon(toReplace, i);
                    continue;
                }
                IconUtil.replaceInnerIcon(anIcon, toCheck, toReplace);
            }
        }
        return icon;
    }

    @JvmStatic
    @Nullable
    public static final Icon rowIcon(@Nullable Icon left, @Nullable Icon right) {
        Icon icon;
        if (left != null && right != null) {
            Icon[] iconArray = new Icon[]{left, right};
            icon = (Icon)((Object)new RowIcon(iconArray));
        } else {
            icon = left;
            if (icon == null) {
                icon = right;
            }
        }
        return icon;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final Icon deepRetrieveIconNow(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        IconReplacer replacer2 = new IconReplacer(){

            public Icon replaceIcon(Icon icon) {
                Icon icon2;
                Icon icon3 = icon;
                if (icon3 instanceof RetrievableIcon) {
                    Icon it = ((RetrievableIcon)icon).retrieveIcon();
                    boolean bl = false;
                    icon2 = it == icon ? it : this.replaceIcon(it);
                } else {
                    icon2 = icon3 instanceof ReplaceableIcon ? ((ReplaceableIcon)icon).replaceBy((IconReplacer)this) : icon;
                }
                return icon2;
            }
        };
        Icon icon2 = replacer2.replaceIcon(icon);
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"replaceIcon(...)");
        return icon2;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Image toImage(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return IconUtil.toImage$default(icon, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BufferedImage toBufferedImage(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return IconUtil.toBufferedImage$default(icon, false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon colorize(@NotNull Icon source, @NotNull Color color, boolean keepGray) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return IconUtil.colorize$default(source, color, keepGray, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon colorize(@NotNull Icon source, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return IconUtil.colorize$default(source, color, false, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon colorize(@Nullable Graphics2D g, @NotNull Icon source, @NotNull Color color, boolean keepGray) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return IconUtil.colorize$default(g, source, color, keepGray, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon colorize(@Nullable Graphics2D g, @NotNull Icon source, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return IconUtil.colorize$default(g, source, color, false, false, 24, null);
    }

    private static final int scaleByIconWidth$lambda$0(Icon it) {
        return it.getIconWidth();
    }

    private static final int scaleByIconWidth$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }
}

