/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.FileIconUtil;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.fileTypes.DirectoryFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.LastComputedIconCache;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.ui.IconManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.icons.PredefinedIconOverlayService;
import com.intellij.util.BitUtil;
import com.intellij.util.ColorFilter;
import com.intellij.util.FileIconKey;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.function.ToIntFunction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u001a\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0003\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u001a:\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0003H\u0002\u001a4\u0010!\u001a\u00020\u00032\b\u0010\"\u001a\u0004\u0018\u00010\u00032\b\u0010#\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020\u00032\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00030&H\u0002\u001a\"\u0010'\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010(2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010)\u001a\u00020*H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006+"}, d2={"ICON_NULLABLE_FUNCTION", "Lkotlin/Function1;", "Lcom/intellij/util/FileIconKey;", "Ljavax/swing/Icon;", "toolbarDecoratorIconsFolder", "", "Lorg/jetbrains/annotations/NonNls;", "getToolbarDecoratorIconsFolder", "()Ljava/lang/String;", "computeFileIconImpl", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "flags", "", "computeFileTypeIcon", "vFile", "onlyFastChecks", "", "filterFileIconFlags", "clampScale", "", "scale", "paintScaled", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "source", "scaleByIcon", "icon", "ancestor", "defaultIcon", "size", "Ljava/util/function/ToIntFunction;", "filterIcon", "Ljava/awt/Graphics2D;", "filter", "Lcom/intellij/util/ColorFilter;", "intellij.platform.core.ui"})
public final class IconUtilKt {
    @NotNull
    private static final Function1<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = IconUtilKt::ICON_NULLABLE_FUNCTION$lambda$0;

    private static final String getToolbarDecoratorIconsFolder() {
        return "toolbarDecorator/" + (SystemInfoRt.isMac ? "mac/" : "");
    }

    @ApiStatus.Internal
    @NotNull
    public static final Icon computeFileIconImpl(@NotNull VirtualFile file, @Nullable Project project, int flags) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int flags2 = IconUtilKt.filterFileIconFlags(file, flags);
        Icon icon = FileIconUtil.INSTANCE.getIconFromProviders(file, flags2, project);
        if (icon == null) {
            icon = IconUtilKt.computeFileTypeIcon(file, false);
        }
        Object icon2 = icon;
        icon2 = FileIconUtil.INSTANCE.patchIconByIconPatchers((Icon)icon2, file, flags2 & 0xFFFFFFFD, project);
        if (file.is(VFileProperty.SYMLINK) && ((object = PredefinedIconOverlayService.Companion.getInstanceOrNull()) == null || (object = object.createSymlinkIcon((Icon)icon2)) == null)) {
            object = icon2 = icon2;
        }
        if (BitUtil.isSet((int)flags2, (int)2) && Registry.Companion.is("ide.locked.icon.enabled", false) && (!file.isWritable() || !WritingAccessProvider.isPotentiallyWritable((VirtualFile)file, (Project)project))) {
            Icon[] iconArray = new Icon[2];
            iconArray[0] = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)PlatformIcons.LOCKED_ICON, (String)"LOCKED_ICON");
            icon2 = (Icon)((Object)LayeredIcon.Companion.layeredIcon(iconArray));
        }
        LastComputedIconCache.put((UserDataHolder)((UserDataHolder)file), (Icon)icon2, (int)flags2);
        return icon2;
    }

    private static final Icon computeFileTypeIcon(VirtualFile vFile, boolean onlyFastChecks) {
        Icon icon = TypePresentationService.getService().getIcon((Object)vFile);
        if (icon != null) {
            Icon it = icon;
            boolean bl = false;
            return it;
        }
        FileType fileType = onlyFastChecks ? FileTypeRegistry.getInstance().getFileTypeByFileName(vFile.getName()) : vFile.getFileType();
        Intrinsics.checkNotNull((Object)fileType);
        FileType fileType2 = fileType;
        if (vFile.isDirectory() && !(fileType2 instanceof DirectoryFileType)) {
            IconManager iconManager = IconManager.Companion.getInstance();
            Icon icon2 = PlatformIcons.FOLDER_ICON;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FOLDER_ICON");
            return iconManager.tooltipOnlyIfComposite(icon2);
        }
        Icon icon3 = fileType2.getIcon();
        if (icon3 == null) {
            EmptyIcon emptyIcon = EmptyIcon.create((Icon)IconManager.Companion.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Class));
            Intrinsics.checkNotNullExpressionValue((Object)emptyIcon, (String)"create(...)");
            icon3 = (Icon)emptyIcon;
        }
        return icon3;
    }

    @Iconable.IconFlags
    private static final int filterFileIconFlags(VirtualFile file, @Iconable.IconFlags int flags) {
        FileType fileType = file.getFileType();
        UserDataHolder fileTypeDataHolder = fileType instanceof UserDataHolder ? (UserDataHolder)fileType : null;
        Integer fileTypeFlagIgnoreMask = (Integer)IconUtil.INSTANCE.getICON_FLAG_IGNORE_MASK().get(fileTypeDataHolder, (Object)0);
        Integer flagIgnoreMask = (Integer)IconUtil.INSTANCE.getICON_FLAG_IGNORE_MASK().get((UserDataHolder)file, (Object)fileTypeFlagIgnoreMask);
        return flags & ~flagIgnoreMask.intValue();
    }

    private static final double clampScale(double scale2) {
        return RangesKt.coerceIn((double)scale2, (double)0.1, (double)32.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void paintScaled(Component c, Graphics g, int x, int y, double scale2, Icon source) {
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            g2d.translate(x, y);
            AffineTransform transform = AffineTransform.getScaleInstance(scale2, scale2);
            transform.preConcatenate(g2d.getTransform());
            g2d.setTransform(transform);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            source.paintIcon(c, g2d, 0, 0);
        }
        finally {
            g2d.dispose();
        }
    }

    private static final Icon scaleByIcon(Icon icon, Component ancestor, Icon defaultIcon, ToIntFunction<? super Icon> size) {
        if (icon == null || icon == defaultIcon) {
            return defaultIcon;
        }
        int actual = size.applyAsInt(icon);
        int expected = size.applyAsInt(defaultIcon);
        return expected == actual ? icon : IconUtil.scale(icon, ancestor, (float)expected / (float)actual);
    }

    private static final Icon filterIcon(Graphics2D g, Icon source, ColorFilter filter) {
        BufferedImage bufferedImage = g == null ? ImageUtil.createImage((int)source.getIconWidth(), (int)source.getIconHeight(), (int)2) : ImageUtil.createImage((Graphics)g, (int)source.getIconWidth(), (int)source.getIconHeight(), (int)2);
        Intrinsics.checkNotNull((Object)bufferedImage);
        BufferedImage src = bufferedImage;
        Graphics2D g2d = src.createGraphics();
        source.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        BufferedImage bufferedImage2 = g == null ? ImageUtil.createImage((int)source.getIconWidth(), (int)source.getIconHeight(), (int)2) : ImageUtil.createImage((Graphics)g, (int)source.getIconWidth(), (int)source.getIconHeight(), (int)2);
        Intrinsics.checkNotNull((Object)bufferedImage2);
        BufferedImage image = bufferedImage2;
        int rgba = 0;
        int n = src.getRaster().getHeight();
        for (int y = 0; y < n; ++y) {
            int n2 = src.getRaster().getWidth();
            for (int x = 0; x < n2; ++x) {
                rgba = src.getRGB(x, y);
                if ((rgba & 0xFF000000) == 0) continue;
                image.setRGB(x, y, filter.filterRGB(x, y, rgba));
            }
        }
        return new ImageIcon(image){
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super($image);
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Image image = this.$image;
                ImageObserver imageObserver = this.getImageObserver();
                if (imageObserver == null) {
                    imageObserver = c;
                }
                StartupUiUtil.drawImage((Graphics)g, (Image)image, (int)x, (int)y, (ImageObserver)imageObserver);
            }

            public int getIconWidth() {
                return ImageUtil.getUserWidth((Image)this.$image);
            }

            public int getIconHeight() {
                return ImageUtil.getUserHeight((Image)this.$image);
            }
        };
    }

    private static final Icon ICON_NULLABLE_FUNCTION$lambda$0(FileIconKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        VirtualFile virtualFile = key.file;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
        return IconUtil.computeFileIcon(virtualFile, key.flags, key.project);
    }

    public static final /* synthetic */ Function1 access$getICON_NULLABLE_FUNCTION$p() {
        return ICON_NULLABLE_FUNCTION;
    }

    public static final /* synthetic */ Icon access$computeFileTypeIcon(VirtualFile vFile, boolean onlyFastChecks) {
        return IconUtilKt.computeFileTypeIcon(vFile, onlyFastChecks);
    }

    public static final /* synthetic */ String access$getToolbarDecoratorIconsFolder() {
        return IconUtilKt.getToolbarDecoratorIconsFolder();
    }

    public static final /* synthetic */ double access$clampScale(double scale2) {
        return IconUtilKt.clampScale(scale2);
    }

    public static final /* synthetic */ void access$paintScaled(Component c, Graphics g, int x, int y, double scale2, Icon source) {
        IconUtilKt.paintScaled(c, g, x, y, scale2, source);
    }

    public static final /* synthetic */ Icon access$scaleByIcon(Icon icon, Component ancestor, Icon defaultIcon, ToIntFunction size) {
        return IconUtilKt.scaleByIcon(icon, ancestor, defaultIcon, size);
    }

    public static final /* synthetic */ Icon access$filterIcon(Graphics2D g, Icon source, ColorFilter filter) {
        return IconUtilKt.filterIcon(g, source, filter);
    }
}

