/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.provider.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.eel.EelConnectionError;
import com.intellij.platform.eel.EelTunnelsApi;
import com.intellij.platform.eel.EelTunnelsApiHelpers;
import com.intellij.platform.eel.EelTunnelsApiHelpersKt;
import com.intellij.platform.eel.EelTunnelsApiKt;
import com.intellij.platform.eel.channels.EelReceiveChannel;
import com.intellij.platform.eel.channels.EelSendChannel;
import com.intellij.platform.eel.provider.utils.CopyError;
import com.intellij.platform.eel.provider.utils.EelChannelUtilsKt;
import com.intellij.platform.eel.provider.utils.OnError;
import com.intellij.util.io.BlockingKt;
import com.intellij.util.io.IoKt;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.ChannelIterator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u001a*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u001a$\u0010\u000e\u001a\u00020\u000f*\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a$\u0010\u0015\u001a\u00020\u000f*\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\rH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "forwardLocalPort", "", "Lkotlinx/coroutines/CoroutineScope;", "tunnels", "Lcom/intellij/platform/eel/EelTunnelsApi;", "localPort", "", "address", "Lcom/intellij/platform/eel/EelTunnelsApi$HostAddress;", "forwardLocalServer", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/platform/eel/EelTunnelsApi$ResolvedSocketAddress;", "redirectClientConnectionDataToIJent", "Lkotlinx/coroutines/Job;", "connectionId", "socket", "Ljava/net/Socket;", "channelToIJent", "Lcom/intellij/platform/eel/channels/EelSendChannel;", "redirectIJentDataToClientConnection", "backChannel", "Lcom/intellij/platform/eel/channels/EelReceiveChannel;", "asInetAddress", "Ljava/net/InetSocketAddress;", "intellij.platform.eel.provider"})
@JvmName(name="IjentTunnelsUtil")
public final class IjentTunnelsUtil {
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Experimental
    public static final void forwardLocalPort(@NotNull CoroutineScope $this$forwardLocalPort, @NotNull EelTunnelsApi tunnels, int localPort, @NotNull EelTunnelsApi.HostAddress address) {
        Intrinsics.checkNotNullParameter((Object)$this$forwardLocalPort, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tunnels, (String)"tunnels");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.bind(new InetSocketAddress("localhost", localPort), 1024);
        serverSocket.setSoTimeout(Duration.toInt-impl((long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), (DurationUnit)DurationUnit.MILLISECONDS));
        JobKt.getJob((CoroutineContext)$this$forwardLocalPort.getCoroutineContext()).invokeOnCompletion(arg_0 -> IjentTunnelsUtil.forwardLocalPort$lambda$0(serverSocket, arg_0));
        LOG.info("Accepting a connection within IDE client on port " + localPort + "; Conections go to remote address " + address);
        Ref.IntRef connectionCounter = new Ref.IntRef();
        BuildersKt.launch$default((CoroutineScope)$this$forwardLocalPort, (CoroutineContext)BlockingKt.getBlockingDispatcher().plus((CoroutineContext)new CoroutineName("Local port forwarding server")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connectionCounter, serverSocket, tunnels, address, localPort, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Ref.IntRef $connectionCounter;
            final /* synthetic */ ServerSocket $serverSocket;
            final /* synthetic */ EelTunnelsApi $tunnels;
            final /* synthetic */ EelTunnelsApi.HostAddress $address;
            final /* synthetic */ int $localPort;
            {
                this.$connectionCounter = $connectionCounter;
                this.$serverSocket = $serverSocket;
                this.$tunnels = $tunnels;
                this.$address = $address;
                this.$localPort = $localPort;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl7:
                        // 2 sources

                        while (true) {
                            IjentTunnelsUtil.access$getLOG$p().debug("Accepting a coroutine on server socket");
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = InterruptibleKt.runInterruptible$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(java.net.ServerSocket ), ()Ljava/net/Socket;)((ServerSocket)this.$serverSocket), (Continuation)((Continuation)this), (int)1, null);
                            ** if (v0 != var6_3) goto lbl16
lbl15:
                            // 1 sources

                            return var6_3;
lbl16:
                            // 1 sources

                            ** GOTO lbl22
                            break;
                        }
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 2 sources

                            socket = (Socket)v0;
                            socket.setSoTimeout(Duration.toInt-impl((long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), (DurationUnit)DurationUnit.MILLISECONDS));
                            currentConnection = this.$connectionCounter.element;
                            var5_7 = this.$connectionCounter.element;
                            this.$connectionCounter.element = var5_7 + 1;
                            BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(socket, this.$tunnels, this.$address, this.$connectionCounter, this.$localPort, currentConnection, null){
                                Object L$0;
                                Object L$1;
                                int I$0;
                                int label;
                                final /* synthetic */ Socket $socket;
                                final /* synthetic */ EelTunnelsApi $tunnels;
                                final /* synthetic */ EelTunnelsApi.HostAddress $address;
                                final /* synthetic */ Ref.IntRef $connectionCounter;
                                final /* synthetic */ int $localPort;
                                final /* synthetic */ int $currentConnection;
                                {
                                    this.$socket = $socket;
                                    this.$tunnels = $tunnels;
                                    this.$address = $address;
                                    this.$connectionCounter = $connectionCounter;
                                    this.$localPort = $localPort;
                                    this.$currentConnection = $currentConnection;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var2_3 = this.$socket;
                                            var3_4 = this.$tunnels;
                                            var4_5 = this.$address;
                                            var5_6 = this.$connectionCounter;
                                            var6_7 = this.$localPort;
                                            var7_8 = this.$currentConnection;
                                            var8_9 = this.$socket;
                                            var9_10 = null;
                                            it = (Socket)var2_3;
                                            $i$a$-use-IjentTunnelsUtil$forwardLocalPort$2$1$1 = 0;
                                            this.L$0 = var2_3;
                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)it);
                                            this.I$0 = $i$a$-use-IjentTunnelsUtil$forwardLocalPort$2$1$1;
                                            this.label = 1;
                                            v0 = EelTunnelsApiKt.withConnectionToRemotePort((EelTunnelsApiHelpers.GetConnectionToRemotePort)EelTunnelsApiKt.hostAddress((EelTunnelsApiHelpers.GetConnectionToRemotePort)EelTunnelsApiHelpersKt.getConnectionToRemotePort((EelTunnelsApi)var3_4), (EelTunnelsApi.HostAddress)var4_5), (Function2)((Function2)new Function2<EelConnectionError, Continuation<? super Unit>, Object>(var5_6, var6_7, var4_5, null){
                                                int label;
                                                /* synthetic */ Object L$0;
                                                final /* synthetic */ Ref.IntRef $connectionCounter;
                                                final /* synthetic */ int $localPort;
                                                final /* synthetic */ EelTunnelsApi.HostAddress $address;
                                                {
                                                    this.$connectionCounter = $connectionCounter;
                                                    this.$localPort = $localPort;
                                                    this.$address = $address;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - void declaration
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    EelConnectionError eelConnectionError = (EelConnectionError)this.L$0;
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            void it;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            if (it instanceof EelConnectionError.ConnectionProblem) {
                                                                IjentTunnelsUtil.access$getLOG$p().debug("Failed to establish connection " + this.$connectionCounter.element + " (" + this.$localPort + " - " + this.$address + ": " + (EelConnectionError)it + "); closing socket");
                                                            } else {
                                                                IjentTunnelsUtil.access$getLOG$p().error("Failed to connect to remote port " + this.$localPort + " - " + this.$address + ": " + (EelConnectionError)it);
                                                            }
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                    var3_3.L$0 = value;
                                                    return (Continuation)var3_3;
                                                }

                                                public final Object invoke(EelConnectionError p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Function3)((Function3)new Function3<CoroutineScope, EelTunnelsApi.Connection, Continuation<? super Unit>, Object>(var7_8, var8_9, null){
                                                int label;
                                                private /* synthetic */ Object L$0;
                                                /* synthetic */ Object L$1;
                                                final /* synthetic */ int $currentConnection;
                                                final /* synthetic */ Socket $socket;
                                                {
                                                    this.$currentConnection = $currentConnection;
                                                    this.$socket = $socket;
                                                    super(3, $completion);
                                                }

                                                /*
                                                 * WARNING - void declaration
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                                    EelTunnelsApi.Connection connection = (EelTunnelsApi.Connection)this.L$1;
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            void $this$withConnectionToRemotePort;
                                                            void <destruct>;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            EelSendChannel channelTo = EelTunnelsApiKt.component1((EelTunnelsApi.Connection)<destruct>);
                                                            EelReceiveChannel channelFrom = EelTunnelsApiKt.component2((EelTunnelsApi.Connection)<destruct>);
                                                            Socket socket = this.$socket;
                                                            Intrinsics.checkNotNull((Object)socket);
                                                            IjentTunnelsUtil.access$redirectClientConnectionDataToIJent((CoroutineScope)$this$withConnectionToRemotePort, this.$currentConnection, socket, channelTo);
                                                            socket = this.$socket;
                                                            Intrinsics.checkNotNull((Object)socket);
                                                            IjentTunnelsUtil.access$redirectIJentDataToClientConnection((CoroutineScope)$this$withConnectionToRemotePort, this.$currentConnection, socket, channelFrom);
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Object invoke(CoroutineScope p1, EelTunnelsApi.Connection p2, Continuation<? super Unit> p3) {
                                                    var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                                    var4_4.L$0 = p1;
                                                    var4_4.L$1 = p2;
                                                    return var4_4.invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)this);
                                            ** if (v0 != var12_2) goto lbl24
lbl23:
                                            // 1 sources

                                            return var12_2;
lbl24:
                                            // 1 sources

                                            ** GOTO lbl34
                                        }
                                        case 1: {
                                            $i$a$-use-IjentTunnelsUtil$forwardLocalPort$2$1$1 = this.I$0;
                                            it = (Socket)this.L$1;
                                            var9_10 = null;
                                            var2_3 = (Closeable)this.L$0;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl34:
                                                // 2 sources

                                                var10_11 = Unit.INSTANCE;
                                                ** GOTO lbl44
                                            }
                                            catch (Throwable var11_14) {
                                                var9_10 = var11_14;
                                                throw var11_14;
                                            }
                                        }
                                        catch (Throwable var11_15) {
                                            throw var11_15;
                                        }
                                        {
                                            finally {
                                                CloseableKt.closeFinally((Closeable)var2_3, (Throwable)var9_10);
                                            }
lbl44:
                                            // 1 sources

                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }
                        catch (SocketTimeoutException e) {
                            CoroutineScopeKt.ensureActive((CoroutineScope)$this$launch);
                        }
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Socket invokeSuspend$lambda$0(ServerSocket $serverSocket) {
                return $serverSocket.accept();
            }
        }), (int)2, null).invokeOnCompletion(arg_0 -> IjentTunnelsUtil.forwardLocalPort$lambda$1(localPort, address, arg_0));
    }

    @ApiStatus.Experimental
    @NotNull
    public static final Deferred<EelTunnelsApi.ResolvedSocketAddress> forwardLocalServer(@NotNull CoroutineScope $this$forwardLocalServer, @NotNull EelTunnelsApi tunnels, int localPort, @NotNull EelTunnelsApi.HostAddress address) {
        Intrinsics.checkNotNullParameter((Object)$this$forwardLocalServer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tunnels, (String)"tunnels");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        CompletableDeferred remoteAddress = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        BuildersKt.launch$default((CoroutineScope)$this$forwardLocalServer, (CoroutineContext)BlockingKt.getBlockingDispatcher().plus((CoroutineContext)new CoroutineName("Local server on port " + localPort + " (tunneling to " + address + ")")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tunnels, address, localPort, (CompletableDeferred<EelTunnelsApi.ResolvedSocketAddress>)remoteAddress, null){
            int label;
            final /* synthetic */ EelTunnelsApi $tunnels;
            final /* synthetic */ EelTunnelsApi.HostAddress $address;
            final /* synthetic */ int $localPort;
            final /* synthetic */ CompletableDeferred<EelTunnelsApi.ResolvedSocketAddress> $remoteAddress;
            {
                this.$tunnels = $tunnels;
                this.$address = $address;
                this.$localPort = $localPort;
                this.$remoteAddress = $remoteAddress;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelTunnelsApiKt.withAcceptorForRemotePort((EelTunnelsApiHelpers.GetAcceptorForRemotePort)EelTunnelsApiKt.hostAddress((EelTunnelsApiHelpers.GetAcceptorForRemotePort)EelTunnelsApiHelpersKt.getAcceptorForRemotePort((EelTunnelsApi)this.$tunnels), (EelTunnelsApi.HostAddress)this.$address), (Function2)((Function2)new Function2<EelConnectionError, Continuation<? super Unit>, Object>(this.$address, this.$localPort, this.$remoteAddress, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ EelTunnelsApi.HostAddress $address;
                            final /* synthetic */ int $localPort;
                            final /* synthetic */ CompletableDeferred<EelTunnelsApi.ResolvedSocketAddress> $remoteAddress;
                            {
                                this.$address = $address;
                                this.$localPort = $localPort;
                                this.$remoteAddress = $remoteAddress;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                EelConnectionError eelConnectionError = (EelConnectionError)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        IjentTunnelsUtil.access$getLOG$p().error("Failed to start a server on " + this.$address + " (was forwarding " + this.$localPort + "): " + (EelConnectionError)it);
                                        Job.DefaultImpls.cancel$default((Job)((Job)this.$remoteAddress), null, (int)1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(EelConnectionError p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Function3)((Function3)new Function3<CoroutineScope, EelTunnelsApi.ConnectionAcceptor, Continuation<? super Unit>, Object>(this.$remoteAddress, this.$localPort, null){
                            Object L$2;
                            int I$0;
                            int label;
                            private /* synthetic */ Object L$0;
                            /* synthetic */ Object L$1;
                            final /* synthetic */ CompletableDeferred<EelTunnelsApi.ResolvedSocketAddress> $remoteAddress;
                            final /* synthetic */ int $localPort;
                            {
                                this.$remoteAddress = $remoteAddress;
                                this.$localPort = $localPort;
                                super(3, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (CoroutineScope)this.L$0;
                                var3_3 = (EelTunnelsApi.ConnectionAcceptor)this.L$1;
                                var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$remoteAddress.complete((Object)acceptor.getBoundAddress());
                                        connections = 0;
                                        var5_6 = acceptor.getIncomingConnections().iterator();
lbl11:
                                        // 2 sources

                                        while (true) {
                                            this.L$0 = $this$withAcceptorForRemotePort;
                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)acceptor);
                                            this.L$2 = var5_6;
                                            this.I$0 = connections;
                                            this.label = 1;
                                            v0 = var5_6.hasNext((Continuation)this);
                                            if (v0 == var10_4) {
                                                return var10_4;
                                            }
                                            ** GOTO lbl26
                                            break;
                                        }
                                    }
                                    case 1: {
                                        connections = this.I$0;
                                        var5_6 = (ChannelIterator)this.L$2;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl26:
                                        // 2 sources

                                        if (((Boolean)v0).booleanValue()) {
                                            var6_7 = (EelTunnelsApi.Connection)var5_6.next();
                                            sendChannel = EelTunnelsApiKt.component1((EelTunnelsApi.Connection)var6_7);
                                            receiveChannel = EelTunnelsApiKt.component2((EelTunnelsApi.Connection)var6_7);
                                            currentConnection = connections++;
                                            BuildersKt.launch$default((CoroutineScope)$this$withAcceptorForRemotePort, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(currentConnection, this.$localPort, sendChannel, receiveChannel, null){
                                                Object L$0;
                                                Object L$1;
                                                int I$0;
                                                int I$1;
                                                int label;
                                                final /* synthetic */ int $currentConnection;
                                                final /* synthetic */ int $localPort;
                                                final /* synthetic */ EelSendChannel $sendChannel;
                                                final /* synthetic */ EelReceiveChannel $receiveChannel;
                                                {
                                                    this.$currentConnection = $currentConnection;
                                                    this.$localPort = $localPort;
                                                    this.$sendChannel = $sendChannel;
                                                    this.$receiveChannel = $receiveChannel;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 * Unable to fully structure code
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            var2_3 = new Socket();
                                                            var3_4 = this.$currentConnection;
                                                            var4_5 = this.$localPort;
                                                            var5_6 = this.$sendChannel;
                                                            var6_7 = this.$receiveChannel;
                                                            var7_8 = null;
                                                            socket = (Socket)var2_3;
                                                            $i$a$-use-IjentTunnelsUtil$forwardLocalServer$1$2$1$1 = 0;
                                                            this.L$0 = var2_3;
                                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)socket);
                                                            this.I$0 = var3_4;
                                                            this.I$1 = $i$a$-use-IjentTunnelsUtil$forwardLocalServer$1$2$1$1;
                                                            this.label = 1;
                                                            v0 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(socket, var4_5, var3_4, var5_6, var6_7, null){
                                                                int label;
                                                                private /* synthetic */ Object L$0;
                                                                final /* synthetic */ Socket $socket;
                                                                final /* synthetic */ int $localPort;
                                                                final /* synthetic */ int $currentConnection;
                                                                final /* synthetic */ EelSendChannel $sendChannel;
                                                                final /* synthetic */ EelReceiveChannel $receiveChannel;
                                                                {
                                                                    this.$socket = $socket;
                                                                    this.$localPort = $localPort;
                                                                    this.$currentConnection = $currentConnection;
                                                                    this.$sendChannel = $sendChannel;
                                                                    this.$receiveChannel = $receiveChannel;
                                                                    super(2, $completion);
                                                                }

                                                                /*
                                                                 * WARNING - void declaration
                                                                 */
                                                                public final Object invokeSuspend(Object $result) {
                                                                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                    switch (this.label) {
                                                                        case 0: {
                                                                            void $this$coroutineScope;
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            this.$socket.setSoTimeout(Duration.toInt-impl((long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), (DurationUnit)DurationUnit.MILLISECONDS));
                                                                            this.$socket.connect(new InetSocketAddress("localhost", this.$localPort));
                                                                            IjentTunnelsUtil.access$redirectClientConnectionDataToIJent((CoroutineScope)$this$coroutineScope, this.$currentConnection, this.$socket, this.$sendChannel);
                                                                            return IjentTunnelsUtil.access$redirectIJentDataToClientConnection((CoroutineScope)$this$coroutineScope, this.$currentConnection, this.$socket, this.$receiveChannel);
                                                                        }
                                                                    }
                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                }

                                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                                    var3_3.L$0 = value;
                                                                    return (Continuation)var3_3;
                                                                }

                                                                public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                }
                                                            }), (Continuation)this);
                                                            ** if (v0 != var10_2) goto lbl23
lbl22:
                                                            // 1 sources

                                                            return var10_2;
lbl23:
                                                            // 1 sources

                                                            ** GOTO lbl34
                                                        }
                                                        case 1: {
                                                            $i$a$-use-IjentTunnelsUtil$forwardLocalServer$1$2$1$1 = this.I$1;
                                                            var3_4 = this.I$0;
                                                            socket = (Socket)this.L$1;
                                                            var7_8 = null;
                                                            var2_3 = (Closeable)this.L$0;
                                                            try {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v0 = $result;
lbl34:
                                                                // 2 sources

                                                                IjentTunnelsUtil.access$getLOG$p().debug("Stopped forwarding remote connection " + var3_4 + " to local server");
                                                                var8_9 = Unit.INSTANCE;
                                                                ** GOTO lbl46
                                                            }
                                                            catch (Throwable var9_12) {
                                                                var7_8 = var9_12;
                                                                throw var9_12;
                                                            }
                                                        }
                                                        catch (Throwable var9_13) {
                                                            throw var9_13;
                                                        }
                                                        {
                                                            finally {
                                                                CloseableKt.closeFinally((Closeable)var2_3, (Throwable)var7_8);
                                                            }
lbl46:
                                                            // 1 sources

                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null);
                                            ** continue;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(CoroutineScope p1, EelTunnelsApi.ConnectionAcceptor p2, Continuation<? super Unit> p3) {
                                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                var4_4.L$0 = p1;
                                var4_4.L$1 = p2;
                                return var4_4.invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null).invokeOnCompletion(arg_0 -> IjentTunnelsUtil.forwardLocalServer$lambda$0(address, arg_0));
        return (Deferred)remoteAddress;
    }

    private static final Job redirectClientConnectionDataToIJent(CoroutineScope $this$redirectClientConnectionDataToIJent, int connectionId, Socket socket, EelSendChannel channelToIJent) {
        return BuildersKt.launch$default((CoroutineScope)$this$redirectClientConnectionDataToIJent, (CoroutineContext)((CoroutineContext)new CoroutineName("Reader for connection " + connectionId)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(socket, channelToIJent, connectionId, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Socket $socket;
            final /* synthetic */ EelSendChannel $channelToIJent;
            final /* synthetic */ int $connectionId;
            {
                this.$socket = $socket;
                this.$channelToIJent = $channelToIJent;
                this.$connectionId = $connectionId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 1;
                        v0 = EelChannelUtilsKt.copy$default(EelChannelUtilsKt.consumeAsEelChannel(this.$socket), this.$channelToIJent, 0, null, (Function2)new Function2<IOException, Continuation<? super OnError>, Object>(this.$channelToIJent, (CoroutineScope)$this$launch, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ EelSendChannel $channelToIJent;
                            final /* synthetic */ CoroutineScope $$this$launch;
                            {
                                this.$channelToIJent = $channelToIJent;
                                this.$$this$launch = $$this$launch;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                IOException iOException = (IOException)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        OnError onError2;
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (it instanceof SocketTimeoutException && this.$channelToIJent.isClosed()) {
                                            CoroutineScopeKt.cancel$default((CoroutineScope)this.$$this$launch, (String)"Channel is closed normally", null, (int)2, null);
                                            onError2 = OnError.EXIT;
                                        } else {
                                            onError2 = OnError.RETRY;
                                        }
                                        return onError2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(IOException p1, Continuation<? super OnError> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, null, (Continuation)this, 44, null);
                        ** if (v0 != var5_3) goto lbl13
lbl12:
                        // 1 sources

                        return var5_3;
lbl13:
                        // 1 sources

                        ** GOTO lbl29
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                        }
                        catch (IOException error) {
                            error = error;
                            if (!(error instanceof CopyError.InError)) ** GOTO lbl27
                            if (!this.$socket.isClosed()) {
                                IjentTunnelsUtil.access$getLOG$p().warn("Connection " + this.$connectionId + " closed", ((CopyError.InError)error).getCause());
                                throw ExceptionsKt.CancellationException((String)"Closed because of a socket exception", (Throwable)((CopyError.InError)error).getCause());
                            }
                            ** GOTO lbl29
lbl27:
                            // 1 sources

                            if (!(error instanceof CopyError.OutError)) ** GOTO lbl29
                            IjentTunnelsUtil.access$getLOG$p().warn("Connection " + this.$connectionId + " closed by IJent; " + ((CopyError.OutError)error).getCause());
                        }
lbl29:
                        // 5 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 2;
                        v1 = this.$channelToIJent.close(null, (Continuation)this);
                        if (v1 == var5_3) {
                            return var5_3;
                        }
                        ** GOTO lbl38
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl38:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final Job redirectIJentDataToClientConnection(CoroutineScope $this$redirectIJentDataToClientConnection, int connectionId, Socket socket, EelReceiveChannel backChannel) {
        return BuildersKt.launch$default((CoroutineScope)$this$redirectIJentDataToClientConnection, (CoroutineContext)((CoroutineContext)new CoroutineName("Writer for connection " + connectionId)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(backChannel, socket, connectionId, null){
            int label;
            final /* synthetic */ EelReceiveChannel $backChannel;
            final /* synthetic */ Socket $socket;
            final /* synthetic */ int $connectionId;
            {
                this.$backChannel = $backChannel;
                this.$socket = $socket;
                this.$connectionId = $connectionId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = EelChannelUtilsKt.copy$default(this.$backChannel, EelChannelUtilsKt.asEelChannel(this.$socket), 0, null, (Function2)new Function2<IOException, Continuation<? super OnError>, Object>(null){
                            int label;
                            /* synthetic */ Object L$0;

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                IOException iOException = (IOException)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        return it instanceof SocketTimeoutException ? OnError.RETRY : OnError.EXIT;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(IOException p1, Continuation<? super OnError> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, null, (Continuation)this, 44, null);
                        ** if (v0 != var5_2) goto lbl11
lbl10:
                        // 1 sources

                        return var5_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl29
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                        }
                        catch (IOException error) {
                            error = error;
                            if (!(error instanceof CopyError.InError)) ** GOTO lbl23
                            IjentTunnelsUtil.access$getLOG$p().warn("Error reading from channel", ((CopyError.InError)error).getCause());
                            ** GOTO lbl29
lbl23:
                            // 1 sources

                            if (!(error instanceof CopyError.OutError)) ** GOTO lbl29
                            e = ((CopyError.OutError)error).getCause();
                            if (this.$socket.isClosed()) ** GOTO lbl28
                            IjentTunnelsUtil.access$getLOG$p().warn("Socket connection " + this.$connectionId + " closed", e);
                            ** GOTO lbl29
lbl28:
                            // 1 sources

                            IjentTunnelsUtil.access$getLOG$p().debug("Socket connection " + this.$connectionId + " closed because of cancellation", e);
                        }
lbl29:
                        // 6 sources

                        this.label = 2;
                        v1 = this.$backChannel.closeForReceive((Continuation)this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl37
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl37:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final InetSocketAddress asInetAddress(@NotNull EelTunnelsApi.ResolvedSocketAddress $this$asInetAddress) {
        InetAddress inetAddress;
        Intrinsics.checkNotNullParameter((Object)$this$asInetAddress, (String)"<this>");
        EelTunnelsApi.ResolvedSocketAddress resolvedSocketAddress = $this$asInetAddress;
        if (resolvedSocketAddress instanceof EelTunnelsApi.ResolvedSocketAddress.V4) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).putInt(((EelTunnelsApi.ResolvedSocketAddress.V4)$this$asInetAddress).getBits-pVg5ArA());
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"putInt(...)");
            inetAddress = InetAddress.getByAddress(IoKt.toByteArray$default((ByteBuffer)byteBuffer, (boolean)false, (int)1, null));
        } else if (resolvedSocketAddress instanceof EelTunnelsApi.ResolvedSocketAddress.V6) {
            inetAddress = InetAddress.getByAddress(ByteBuffer.allocate(16).putLong(((EelTunnelsApi.ResolvedSocketAddress.V6)$this$asInetAddress).getHigherBits-s-VKNKU()).putLong(8, ((EelTunnelsApi.ResolvedSocketAddress.V6)$this$asInetAddress).getLowerBits-s-VKNKU()).array());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        InetAddress inetAddress2 = inetAddress;
        return new InetSocketAddress(inetAddress2, $this$asInetAddress.getPort-Mh2AYeg() & 0xFFFF);
    }

    private static final Unit forwardLocalPort$lambda$0(ServerSocket $serverSocket, Throwable it) {
        LOG.debug("Closing connection to server socket");
        $serverSocket.close();
        return Unit.INSTANCE;
    }

    private static final Unit forwardLocalPort$lambda$1(int $localPort, EelTunnelsApi.HostAddress $address, Throwable it) {
        LOG.info("Local server on " + $localPort + " (was tunneling to " + $address + ") is terminated");
        return Unit.INSTANCE;
    }

    private static final Unit forwardLocalServer$lambda$0(EelTunnelsApi.HostAddress $address, Throwable it) {
        LOG.info("Remote server on " + $address + " (was tunneling local server on " + $address + ") is terminated");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Job access$redirectClientConnectionDataToIJent(CoroutineScope $receiver, int connectionId, Socket socket, EelSendChannel channelToIJent) {
        return IjentTunnelsUtil.redirectClientConnectionDataToIJent($receiver, connectionId, socket, channelToIJent);
    }

    public static final /* synthetic */ Job access$redirectIJentDataToClientConnection(CoroutineScope $receiver, int connectionId, Socket socket, EelReceiveChannel backChannel) {
        return IjentTunnelsUtil.redirectIJentDataToClientConnection($receiver, connectionId, socket, backChannel);
    }

    static {
        Logger logger = Logger.getInstance(EelTunnelsApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

