/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.provider.utils;

import com.intellij.platform.eel.channels.EelSendChannel;
import com.intellij.platform.eel.channels.EelSendChannelKt;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/eel/provider/utils/OutputStreamAdapterImpl;", "Ljava/io/OutputStream;", "sendChannel", "Lcom/intellij/platform/eel/channels/EelSendChannel;", "blockingContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/intellij/platform/eel/channels/EelSendChannel;Lkotlin/coroutines/CoroutineContext;)V", "oneByte", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "write", "", "b", "", "", "off", "len", "flush", "buffer", "close", "intellij.platform.eel.provider"})
public final class OutputStreamAdapterImpl
extends OutputStream {
    @NotNull
    private final EelSendChannel sendChannel;
    @NotNull
    private final CoroutineContext blockingContext;
    private final ByteBuffer oneByte;

    public OutputStreamAdapterImpl(@NotNull EelSendChannel sendChannel, @NotNull CoroutineContext blockingContext) {
        Intrinsics.checkNotNullParameter((Object)sendChannel, (String)"sendChannel");
        Intrinsics.checkNotNullParameter((Object)blockingContext, (String)"blockingContext");
        this.sendChannel = sendChannel;
        this.blockingContext = blockingContext;
        this.oneByte = ByteBuffer.allocate(1);
    }

    @Override
    public void write(int b) {
        this.oneByte.clear().put((byte)b).flip();
        ByteBuffer byteBuffer = this.oneByte;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"oneByte");
        this.write(byteBuffer);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ByteBuffer byteBuffer = ByteBuffer.wrap(b, off, len);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        this.write(byteBuffer);
    }

    @Override
    public void flush() {
    }

    private final void write(ByteBuffer buffer) throws IOException {
        BuildersKt.runBlocking((CoroutineContext)this.blockingContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, buffer, null){
            int label;
            final /* synthetic */ OutputStreamAdapterImpl this$0;
            final /* synthetic */ ByteBuffer $buffer;
            {
                this.this$0 = $receiver;
                this.$buffer = $buffer;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelSendChannelKt.sendWholeBuffer((EelSendChannel)OutputStreamAdapterImpl.access$getSendChannel$p(this.this$0), (ByteBuffer)this.$buffer, (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void close() {
        BuildersKt.runBlocking((CoroutineContext)this.blockingContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ OutputStreamAdapterImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = OutputStreamAdapterImpl.access$getSendChannel$p(this.this$0).close(null, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ EelSendChannel access$getSendChannel$p(OutputStreamAdapterImpl $this) {
        return $this.sendChannel;
    }
}

