/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.bridge.impl.library;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.workspace.jps.bridge.impl.BridgeElementsKt;
import com.intellij.platform.workspace.jps.bridge.impl.library.JpsLibraryBridgeBase;
import com.intellij.platform.workspace.jps.bridge.impl.library.JpsLibraryReferenceBridge;
import com.intellij.platform.workspace.jps.bridge.impl.library.JpsLibraryRootBridge;
import com.intellij.platform.workspace.jps.bridge.impl.library.JpsLibraryRootTypesKt;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryTypeId;
import com.intellij.platform.workspace.jps.entities.Library_extensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.library.JpsLibraryPropertiesSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\f2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00020\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryBridge;", "Lcom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryBridgeBase;", "Lorg/jetbrains/jps/model/JpsElement;", "libraryEntity", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "parentElement", "Lorg/jetbrains/jps/model/ex/JpsElementBase;", "<init>", "(Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;Lorg/jetbrains/jps/model/ex/JpsElementBase;)V", "libraryRoots", "", "Lorg/jetbrains/jps/model/library/JpsOrderRootType;", "", "Lcom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryRootBridge;", "getLibraryRoots", "()Ljava/util/Map;", "libraryRoots$delegate", "Lkotlin/Lazy;", "libraryProperties", "kotlin.jvm.PlatformType", "getLibraryProperties", "()Lorg/jetbrains/jps/model/JpsElement;", "libraryProperties$delegate", "getRoots", "Lorg/jetbrains/jps/model/library/JpsLibraryRoot;", "rootType", "createReference", "Lorg/jetbrains/jps/model/library/JpsLibraryReference;", "getType", "Lorg/jetbrains/jps/model/library/JpsLibraryType;", "getProperties", "Companion", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsLibraryBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsLibraryBridge.kt\ncom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryBridge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1504#2:53\n1534#2,3:54\n1537#2,3:64\n1374#2:68\n1460#2,5:69\n1208#2,2:74\n1236#2,4:76\n382#3,7:57\n1#4:67\n*S KotlinDebug\n*F\n+ 1 JpsLibraryBridge.kt\ncom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryBridge\n*L\n22#1:53\n22#1:54,3\n22#1:64,3\n44#1:68\n44#1:69,5\n44#1:74,2\n44#1:76,4\n22#1:57,7\n*E\n"})
public final class JpsLibraryBridge
extends JpsLibraryBridgeBase<JpsElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LibraryEntity libraryEntity;
    @NotNull
    private final Lazy libraryRoots$delegate;
    @NotNull
    private final Lazy libraryProperties$delegate;
    @NotNull
    private static final Lazy<Map<String, JpsLibraryPropertiesSerializer<?>>> serializers$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, JpsLibraryBridge::serializers_delegate$lambda$0);

    public JpsLibraryBridge(@NotNull LibraryEntity libraryEntity, @NotNull JpsElementBase<?> parentElement) {
        Intrinsics.checkNotNullParameter((Object)libraryEntity, (String)"libraryEntity");
        Intrinsics.checkNotNullParameter(parentElement, (String)"parentElement");
        super(libraryEntity.getName(), parentElement);
        this.libraryEntity = libraryEntity;
        this.libraryRoots$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> JpsLibraryBridge.libraryRoots_delegate$lambda$0(this));
        this.libraryProperties$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> JpsLibraryBridge.libraryProperties_delegate$lambda$0(this));
    }

    private final Map<JpsOrderRootType, List<JpsLibraryRootBridge>> getLibraryRoots() {
        Lazy lazy = this.libraryRoots$delegate;
        return (Map)lazy.getValue();
    }

    private final JpsElement getLibraryProperties() {
        Lazy lazy = this.libraryProperties$delegate;
        return (JpsElement)lazy.getValue();
    }

    @NotNull
    public List<JpsLibraryRoot> getRoots(@NotNull JpsOrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        List list = this.getLibraryRoots().get(rootType);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public JpsLibraryReference createReference() {
        return new JpsLibraryReferenceBridge(this.libraryEntity.getSymbolicId());
    }

    @NotNull
    public JpsLibraryType<JpsElement> getType() {
        LibraryTypeId libraryTypeId = this.libraryEntity.getTypeId();
        Object object = Companion.getSerializer(libraryTypeId != null ? libraryTypeId.getName() : null).getType();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.jps.model.library.JpsLibraryType<org.jetbrains.jps.model.JpsElement>");
        return (JpsLibraryType)object;
    }

    @NotNull
    public JpsElement getProperties() {
        JpsElement jpsElement = this.getLibraryProperties();
        Intrinsics.checkNotNullExpressionValue((Object)jpsElement, (String)"<get-libraryProperties>(...)");
        return jpsElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map libraryRoots_delegate$lambda$0(JpsLibraryBridge this$0) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this$0.libraryEntity.getRoots();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            LibraryRoot it = (LibraryRoot)element$iv$iv;
            boolean bl = false;
            JpsOrderRootType key$iv$iv = JpsLibraryRootTypesKt.asJpsOrderRootType(it.getType());
            Map map2 = destination$iv$iv;
            JpsOrderRootType key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            it = (LibraryRoot)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            list.add(new JpsLibraryRootBridge(it, this$0));
        }
        return destination$iv$iv;
    }

    private static final JpsElement libraryProperties_delegate$lambda$0(JpsLibraryBridge this$0) {
        Element element;
        Object object = Library_extensionsKt.getLibraryProperties(this$0.libraryEntity);
        if (object != null && (object = object.getPropertiesXmlTag()) != null) {
            Object it = object;
            boolean bl = false;
            element = JDOMUtil.load((CharSequence)((CharSequence)it));
        } else {
            element = null;
        }
        Element xml = element;
        LibraryTypeId libraryTypeId = this$0.libraryEntity.getTypeId();
        return Companion.getSerializer(libraryTypeId != null ? libraryTypeId.getName() : null).loadProperties(xml, BridgeElementsKt.getPathMapper(this$0.getModel()));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map serializers_delegate$lambda$0() {
        void $this$associateByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable iterable = JpsModelSerializerExtension.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getExtensions(...)");
        Iterable $this$flatMap$iv = iterable;
        boolean $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JpsModelSerializerExtension it = (JpsModelSerializerExtension)element$iv$iv;
            boolean bl = false;
            List list = it.getLibraryPropertiesSerializers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLibraryPropertiesSerializers(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            JpsLibraryPropertiesSerializer bl = (JpsLibraryPropertiesSerializer)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            map2.put(it.getTypeId(), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\r\u001a\u0006\u0012\u0002\b\u00030\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006R?\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0007*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryBridge$Companion;", "", "<init>", "()V", "serializers", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/jps/model/serialization/library/JpsLibraryPropertiesSerializer;", "getSerializers", "()Ljava/util/Map;", "serializers$delegate", "Lkotlin/Lazy;", "getSerializer", "typeId", "intellij.platform.workspace.jps"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, JpsLibraryPropertiesSerializer<?>> getSerializers() {
            Lazy lazy = serializers$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final JpsLibraryPropertiesSerializer<?> getSerializer(@Nullable String typeId) {
            JpsLibraryPropertiesSerializer jpsLibraryPropertiesSerializer = this.getSerializers().get(typeId);
            if (jpsLibraryPropertiesSerializer == null) {
                JpsLibraryPropertiesSerializer jpsLibraryPropertiesSerializer2 = JpsLibraryTableSerializer.JAVA_LIBRARY_PROPERTIES_SERIALIZER;
                jpsLibraryPropertiesSerializer = jpsLibraryPropertiesSerializer2;
                Intrinsics.checkNotNullExpressionValue((Object)jpsLibraryPropertiesSerializer2, (String)"JAVA_LIBRARY_PROPERTIES_SERIALIZER");
            }
            return jpsLibraryPropertiesSerializer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

