/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.entities.FacetsOrderEntityBuilder;
import com.intellij.platform.workspace.jps.entities.FacetsOrderEntityModifications;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntityBuilder;
import com.intellij.platform.workspace.jps.entities.ModuleEntityModifications;
import com.intellij.platform.workspace.jps.entities.ModuleSettingsFacetBridgeEntity;
import com.intellij.platform.workspace.jps.entities.OrdersKt;
import com.intellij.platform.workspace.jps.serialization.SerializationContext;
import com.intellij.platform.workspace.jps.serialization.impl.CustomFacetRelatedEntitySerializer;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J,\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002JO\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\u00182 \u0010\u0019\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00120\u001a2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00050\u001eH\u0000\u00a2\u0006\u0002\b R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/FacetsSerializer;", "", "internalSource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "externalStorage", "", "context", "Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "<init>", "(Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;ZLcom/intellij/platform/workspace/jps/serialization/SerializationContext;)V", "loadFacetEntities", "", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntityBuilder;", "facetManagerTag", "Lorg/jdom/Element;", "loadFacetEntities$intellij_platform_workspace_jps", "facetStates", "", "Lorg/jetbrains/jps/model/serialization/facet/FacetState;", "orderOfFacets", "", "", "saveFacetEntities", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "affectedEntities", "", "Ljava/lang/Class;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entitySourceFilter", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "saveFacetEntities$intellij_platform_workspace_jps", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nFacetsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetsSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/FacetsSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,92:1\n1208#2,2:93\n1236#2,4:95\n1617#2,9:99\n1869#2:108\n774#2:109\n865#2,2:110\n1563#2:112\n1634#2,3:113\n1870#2:117\n1626#2:118\n1516#2,3:119\n1519#2,3:129\n1869#2,2:132\n1#3:116\n382#4,7:122\n*S KotlinDebug\n*F\n+ 1 FacetsSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/FacetsSerializer\n*L\n53#1:93,2\n53#1:95,4\n66#1:99,9\n66#1:108\n67#1:109\n67#1:110,2\n70#1:112\n70#1:113,3\n66#1:117\n66#1:118\n78#1:119,3\n78#1:129,3\n81#1:132,2\n66#1:116\n78#1:122,7\n*E\n"})
public final class FacetsSerializer {
    @NotNull
    private final JpsFileEntitySource internalSource;
    private final boolean externalStorage;
    @NotNull
    private final SerializationContext context;

    public FacetsSerializer(@NotNull JpsFileEntitySource internalSource, boolean externalStorage, @NotNull SerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)internalSource, (String)"internalSource");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.internalSource = internalSource;
        this.externalStorage = externalStorage;
        this.context = context;
    }

    public final void loadFacetEntities$intellij_platform_workspace_jps(@NotNull ModuleEntityBuilder moduleEntity, @NotNull Element facetManagerTag) {
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)facetManagerTag, (String)"facetManagerTag");
        Object object = XmlSerializer.deserialize((Element)facetManagerTag, FacetManagerState.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deserialize(...)");
        FacetManagerState facetManagerState = (FacetManagerState)object;
        ArrayList orderOfFacets = new ArrayList();
        List list = facetManagerState.facets;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"facets");
        this.loadFacetEntities(list, moduleEntity, orderOfFacets);
        if (orderOfFacets.size() > 1 && !this.externalStorage) {
            FacetsOrderEntityBuilder entity = ModuleEntityModifications.getFacetOrder(moduleEntity);
            if (entity != null) {
                entity.setOrderOfFacets(orderOfFacets);
            } else {
                FacetsOrderEntityModifications.createFacetsOrderEntity(orderOfFacets, this.internalSource, (Function1<? super FacetsOrderEntityBuilder, Unit>)((Function1)arg_0 -> FacetsSerializer.loadFacetEntities$lambda$0(moduleEntity, arg_0)));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadFacetEntities(List<FacetState> facetStates, ModuleEntityBuilder moduleEntity, List<String> orderOfFacets) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.context.getCustomFacetRelatedEntitySerializers();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            CustomFacetRelatedEntitySerializer customFacetRelatedEntitySerializer = (CustomFacetRelatedEntitySerializer)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getSupportedFacetType(), element$iv$iv);
        }
        Map facetTypeToSerializer = destination$iv$iv;
        for (FacetState facetState : facetStates) {
            String string = facetState.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            orderOfFacets.add(string);
            CustomFacetRelatedEntitySerializer customFacetRelatedEntitySerializer = (CustomFacetRelatedEntitySerializer)facetTypeToSerializer.get(facetState.getFacetType());
            if (customFacetRelatedEntitySerializer == null) {
                customFacetRelatedEntitySerializer = (CustomFacetRelatedEntitySerializer)MapsKt.getValue((Map)facetTypeToSerializer, (Object)"<all types of facets>");
            }
            CustomFacetRelatedEntitySerializer serializer = customFacetRelatedEntitySerializer;
            serializer.loadEntitiesFromFacetState(moduleEntity, facetState, (Function1<FacetState, EntitySource>)((Function1)new Function1<FacetState, EntitySource>(this){
                final /* synthetic */ FacetsSerializer this$0;
                {
                    this.this$0 = $receiver;
                    super(1, Intrinsics.Kotlin.class, "evaluateEntitySource", "loadFacetEntities$evaluateEntitySource(Lcom/intellij/platform/workspace/jps/serialization/impl/FacetsSerializer;Lorg/jetbrains/jps/model/serialization/facet/FacetState;)Lcom/intellij/platform/workspace/storage/EntitySource;", 0);
                }

                public final EntitySource invoke(FacetState p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return FacetsSerializer.access$loadFacetEntities$evaluateEntitySource(this.this$0, p0);
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Element saveFacetEntities$intellij_platform_workspace_jps(@Nullable ModuleEntity moduleEntity, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> affectedEntities, @NotNull Function1<? super EntitySource, Boolean> entitySourceFilter) {
        void $this$groupByTo$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(affectedEntities, (String)"affectedEntities");
        Intrinsics.checkNotNullParameter(entitySourceFilter, (String)"entitySourceFilter");
        Iterable iterable = this.context.getCustomFacetRelatedEntitySerializers();
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List<FacetState> list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl6 = false;
            CustomFacetRelatedEntitySerializer entitySerializer = (CustomFacetRelatedEntitySerializer)element$iv$iv;
            boolean bl2 = false;
            List<? extends WorkspaceEntity> list2 = affectedEntities.get(entitySerializer.getRootEntityType());
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    WorkspaceEntity it = (WorkspaceEntity)element$iv$iv2;
                    boolean bl3 = false;
                    if (!((Boolean)entitySourceFilter.invoke((Object)it.getEntitySource())).booleanValue()) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                List entitiesToSave = (List)destination$iv$iv2;
                Intrinsics.checkNotNull((Object)entitySerializer, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.jps.serialization.impl.CustomFacetRelatedEntitySerializer<com.intellij.platform.workspace.jps.entities.ModuleSettingsFacetBridgeEntity>");
                Iterable iterable3 = entitiesToSave;
                CustomFacetRelatedEntitySerializer customFacetRelatedEntitySerializer = entitySerializer;
                boolean $i$f$map = false;
                $this$filter$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    WorkspaceEntity workspaceEntity = (WorkspaceEntity)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.jps.entities.ModuleSettingsFacetBridgeEntity");
                    collection.add((ModuleSettingsFacetBridgeEntity)it);
                }
                list = customFacetRelatedEntitySerializer.createFacetStateFromEntities((List)destination$iv$iv3, this.externalStorage);
            }
            if (list == null) continue;
            List<FacetState> it$iv$iv = list;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List facetStatesFromEP = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        if (facetStatesFromEP.isEmpty()) {
            return null;
        }
        FacetManagerState facetManagerState = new FacetManagerState();
        $this$mapNotNullTo$iv$iv = facetStatesFromEP;
        Map destination$iv = new HashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            void $this$getOrPut$iv$iv;
            FacetState it = (FacetState)element$iv;
            boolean bl = false;
            String key$iv = it.getName();
            Map bl6 = destination$iv;
            String key$iv$iv = key$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
            if (value$iv$iv == null) {
                boolean bl7 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        HashMap facetNameToFacetState = (HashMap)destination$iv;
        Object object = moduleEntity;
        if (object == null || (object = OrdersKt.getFacetOrder((ModuleEntity)object)) == null || (object = object.getOrderOfFacets()) == null) {
            object = CollectionsKt.emptyList();
        }
        List<String> orderOfFacets = object;
        for (String facetName : orderOfFacets) {
            List list = (List)facetNameToFacetState.remove(facetName);
            if (list == null) continue;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                FacetState it = (FacetState)element$iv;
                boolean bl = false;
                facetManagerState.facets.add(it);
            }
        }
        List list = facetManagerState.facets;
        Collection collection = facetNameToFacetState.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        list.addAll(CollectionsKt.flatten((Iterable)collection));
        Element componentTag2 = JDomSerializationUtil.createComponentElement((String)"facets-root");
        XmlSerializer.serializeInto((Object)facetManagerState, (Element)componentTag2);
        return componentTag2;
    }

    private static final Unit loadFacetEntities$lambda$0(ModuleEntityBuilder $moduleEntity, FacetsOrderEntityBuilder $this$FacetsOrderEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$FacetsOrderEntity, (String)"$this$FacetsOrderEntity");
        $this$FacetsOrderEntity.setModuleEntity($moduleEntity);
        return Unit.INSTANCE;
    }

    private static final EntitySource loadFacetEntities$evaluateEntitySource(FacetsSerializer this$0, FacetState facetState) {
        String externalSystemId;
        String string = facetState.getExternalSystemId();
        if (string == null) {
            string = facetState.getExternalSystemIdInInternalStorage();
        }
        return (externalSystemId = string) == null ? (EntitySource)this$0.internalSource : (EntitySource)new JpsImportedEntitySource(this$0.internalSource, externalSystemId, this$0.externalStorage);
    }

    public static final /* synthetic */ EntitySource access$loadFacetEntities$evaluateEntitySource(FacetsSerializer this$0, FacetState facetState) {
        return FacetsSerializer.loadFacetEntities$evaluateEntitySource(this$0, facetState);
    }
}

