/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.platform.workspace.jps.JpsEntitySourceFactory;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntity;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.serialization.impl.JpsDirectoryEntitiesSerializerFactory;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsLibraryEntitiesSerializer;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0002H\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsLibrariesDirectorySerializerFactory;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsDirectoryEntitiesSerializerFactory;", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "directoryUrl", "", "<init>", "(Ljava/lang/String;)V", "getDirectoryUrl", "()Ljava/lang/String;", "componentName", "getComponentName", "getDefaultFileName", "entity", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "entityFilter", "Lkotlin/Function1;", "", "getEntityFilter", "()Lkotlin/jvm/functions/Function1;", "createSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntitiesSerializer;", "fileUrl", "entitySource", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$FileInDirectory;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "changeEntitySourcesToDirectoryBasedFormat", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "configLocation", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsLibraryEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibrariesDirectorySerializerFactory\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,341:1\n1321#2,2:342\n1321#2,2:344\n*S KotlinDebug\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibrariesDirectorySerializerFactory\n*L\n47#1:342,2\n54#1:344,2\n*E\n"})
public final class JpsLibrariesDirectorySerializerFactory
implements JpsDirectoryEntitiesSerializerFactory<LibraryEntity> {
    @NotNull
    private final String directoryUrl;

    public JpsLibrariesDirectorySerializerFactory(@NotNull String directoryUrl) {
        Intrinsics.checkNotNullParameter((Object)directoryUrl, (String)"directoryUrl");
        this.directoryUrl = directoryUrl;
    }

    @Override
    @NotNull
    public String getDirectoryUrl() {
        return this.directoryUrl;
    }

    @Override
    @NotNull
    public String getComponentName() {
        return "libraryTable";
    }

    @Override
    @NotNull
    public String getDefaultFileName(@NotNull LibraryEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getName();
    }

    @Override
    @NotNull
    public Class<LibraryEntity> getEntityClass() {
        return LibraryEntity.class;
    }

    @Override
    @NotNull
    public Function1<LibraryEntity, Boolean> getEntityFilter() {
        return JpsLibrariesDirectorySerializerFactory::_get_entityFilter_$lambda$0;
    }

    @Override
    @NotNull
    public JpsFileEntitiesSerializer<LibraryEntity> createSerializer(@NotNull String fileUrl, @NotNull JpsProjectFileEntitySource.FileInDirectory entitySource, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)entitySource, (String)"entitySource");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        return new JpsLibraryEntitiesSerializer(virtualFileManager.getOrCreateFromUrl(fileUrl), entitySource, LibraryTableId.ProjectLibraryTableId.INSTANCE);
    }

    @Override
    public void changeEntitySourcesToDirectoryBasedFormat(@NotNull MutableEntityStorage builder, @NotNull JpsProjectConfigLocation configLocation) {
        WorkspaceEntity it;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        Object $this$forEach$iv = builder.entities(LibraryEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LibraryEntity)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTableId(), (Object)LibraryTableId.ProjectLibraryTableId.INSTANCE)) continue;
            LibraryEntityModifications.modifyLibraryEntity(builder, (LibraryEntity)it, (Function1<? super LibraryEntityBuilder, Unit>)((Function1)arg_0 -> JpsLibrariesDirectorySerializerFactory.changeEntitySourcesToDirectoryBasedFormat$lambda$0$0(configLocation, arg_0)));
        }
        $this$forEach$iv = builder.entities(LibraryPropertiesEntity.class);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LibraryPropertiesEntity)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getLibrary().getTableId(), (Object)LibraryTableId.ProjectLibraryTableId.INSTANCE)) continue;
            LibraryPropertiesEntityModifications.modifyLibraryPropertiesEntity(builder, (LibraryPropertiesEntity)it, (Function1<? super LibraryPropertiesEntityBuilder, Unit>)((Function1)arg_0 -> JpsLibrariesDirectorySerializerFactory.changeEntitySourcesToDirectoryBasedFormat$lambda$1$0((LibraryPropertiesEntity)it, arg_0)));
        }
    }

    private static final boolean _get_entityFilter_$lambda$0(LibraryEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getTableId(), (Object)LibraryTableId.ProjectLibraryTableId.INSTANCE);
    }

    private static final Unit changeEntitySourcesToDirectoryBasedFormat$lambda$0$0(JpsProjectConfigLocation $configLocation, LibraryEntityBuilder $this$modifyLibraryEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyLibraryEntity, (String)"$this$modifyLibraryEntity");
        $this$modifyLibraryEntity.setEntitySource(JpsEntitySourceFactory.INSTANCE.createJpsEntitySourceForProjectLibrary($configLocation));
        return Unit.INSTANCE;
    }

    private static final Unit changeEntitySourcesToDirectoryBasedFormat$lambda$1$0(LibraryPropertiesEntity $it, LibraryPropertiesEntityBuilder $this$modifyLibraryPropertiesEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyLibraryPropertiesEntity, (String)"$this$modifyLibraryPropertiesEntity");
        $this$modifyLibraryPropertiesEntity.setEntitySource($it.getLibrary().getEntitySource());
        return Unit.INSTANCE;
    }
}

