/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage;

import com.intellij.platform.workspace.storage.ConnectionId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.ChildEntityId;
import com.intellij.platform.workspace.storage.impl.RefsTableKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.util.containers.FList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\u001a+\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u0002H\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0006\u001ah\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\r2\u0014\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u00132\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u0013H\u0002\u00a8\u0006\u0015"}, d2={"createEntityTreeCopy", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "requireTopLevelEntity", "", "(Lcom/intellij/platform/workspace/storage/WorkspaceEntity;Z)Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "copyChildren", "", "oldEntityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "parents", "Lcom/intellij/util/containers/FList;", "parentInterfaces", "Ljava/lang/Class;", "originalSnapshot", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "copied", "", "deferred", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nentityTreeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 entityTreeUtil.kt\ncom/intellij/platform/workspace/storage/EntityTreeUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class EntityTreeUtilKt {
    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public static final <T extends WorkspaceEntity> WorkspaceEntity.Builder<T> createEntityTreeCopy(@NotNull T $this$createEntityTreeCopy, boolean requireTopLevelEntity) {
        Intrinsics.checkNotNullParameter($this$createEntityTreeCopy, (String)"<this>");
        EntityStorage entityStorage = ((WorkspaceEntityBase)$this$createEntityTreeCopy).getSnapshot();
        Intrinsics.checkNotNull((Object)entityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.AbstractEntityStorage");
        AbstractEntityStorage originalSnapshot = (AbstractEntityStorage)entityStorage;
        WorkspaceEntityData<? extends WorkspaceEntity> entityData = originalSnapshot.entityDataByIdOrDie$intellij_platform_workspace_storage(((WorkspaceEntityBase)$this$createEntityTreeCopy).getId());
        if (requireTopLevelEntity && !entityData.getRequiredParents().isEmpty()) {
            boolean $i$a$-require-EntityTreeUtilKt$createEntityTreeCopy$32 = false;
            String $i$a$-require-EntityTreeUtilKt$createEntityTreeCopy$32 = "copying is supported only for top-level entities which don't have required parents";
            throw new IllegalArgumentException($i$a$-require-EntityTreeUtilKt$createEntityTreeCopy$32.toString());
        }
        WorkspaceEntity.Builder<?> newEntity = entityData.createDetachedEntity(CollectionsKt.emptyList());
        HashSet copied = new HashSet();
        HashSet deferred = new HashSet();
        FList parents = FList.emptyList().prepend(newEntity);
        FList parentInterfaces = FList.emptyList().prepend(entityData.getEntityInterface());
        long l = ((WorkspaceEntityBase)$this$createEntityTreeCopy).getId();
        Intrinsics.checkNotNull((Object)parents);
        Intrinsics.checkNotNull((Object)parentInterfaces);
        EntityTreeUtilKt.copyChildren(l, parents, (FList<Class<? extends WorkspaceEntity>>)parentInterfaces, originalSnapshot, copied, deferred);
        deferred.removeAll(copied);
        if (!deferred.isEmpty()) {
            boolean bl = false;
            String string = "some elements weren't copied because their additional parents are located in a separate tree: " + deferred;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull(newEntity, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.WorkspaceEntity.Builder<T of com.intellij.platform.workspace.storage.EntityTreeUtilKt.createEntityTreeCopy>");
        return newEntity;
    }

    public static /* synthetic */ WorkspaceEntity.Builder createEntityTreeCopy$default(WorkspaceEntity workspaceEntity, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return EntityTreeUtilKt.createEntityTreeCopy(workspaceEntity, bl);
    }

    private static final void copyChildren(long oldEntityId, FList<WorkspaceEntity.Builder<?>> parents, FList<Class<? extends WorkspaceEntity>> parentInterfaces, AbstractEntityStorage originalSnapshot, Set<Long> copied, Set<Long> deferred) {
        Iterator<Map.Entry<ConnectionId, List<ChildEntityId>>> iterator = originalSnapshot.getRefs$intellij_platform_workspace_storage().getChildrenRefsOfParentBy-42Q2mxQ(RefsTableKt.asParent(oldEntityId)).entrySet().iterator();
        while (iterator.hasNext()) {
            List<ChildEntityId> children = iterator.next().getValue();
            Iterator<ChildEntityId> iterator2 = children.iterator();
            while (iterator2.hasNext()) {
                long child = iterator2.next().unbox-impl();
                WorkspaceEntityData<? extends WorkspaceEntity> childData = originalSnapshot.entityDataByIdOrDie$intellij_platform_workspace_storage(child);
                if (parentInterfaces.containsAll((Collection)childData.getRequiredParents())) {
                    WorkspaceEntity.Builder<?> childCopy = childData.createDetachedEntity((List)parents);
                    copied.add(child);
                    FList fList = parents.prepend(childCopy);
                    Intrinsics.checkNotNullExpressionValue((Object)fList, (String)"prepend(...)");
                    FList fList2 = parentInterfaces.prepend(childData.getEntityInterface());
                    Intrinsics.checkNotNullExpressionValue((Object)fList2, (String)"prepend(...)");
                    EntityTreeUtilKt.copyChildren(child, fList, (FList<Class<? extends WorkspaceEntity>>)fList2, originalSnapshot, copied, deferred);
                    continue;
                }
                deferred.add(child);
            }
        }
    }
}

