/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.external.AbstractExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.indices.AbstractMultimapStorageIndex;
import com.intellij.platform.workspace.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.SymbolicIdInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.VirtualFileIndex;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0016X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u0082\u0001\u0002!\"\u00a8\u0006#"}, d2={"Lcom/intellij/platform/workspace/storage/impl/AbstractStorageIndexes;", "", "<init>", "()V", "softLinks", "Lcom/intellij/platform/workspace/storage/impl/indices/AbstractMultimapStorageIndex;", "getSoftLinks$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/AbstractMultimapStorageIndex;", "virtualFileIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex;", "getVirtualFileIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex;", "entitySourceIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "getEntitySourceIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex;", "symbolicIdIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex;", "getSymbolicIdIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex;", "externalMappings", "", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "Lcom/intellij/platform/workspace/storage/impl/external/AbstractExternalEntityMappingImpl;", "getExternalMappings$intellij_platform_workspace_storage", "()Ljava/util/Map;", "assertConsistency", "", "storage", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "assertSymbolicIdIndex", "assertEntitySourceIndex", "Lcom/intellij/platform/workspace/storage/impl/ImmutableStorageIndexes;", "Lcom/intellij/platform/workspace/storage/impl/MutableStorageIndexes;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nStorageIndexes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/platform/workspace/storage/impl/AbstractStorageIndexes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n1878#2,2:289\n295#2,2:291\n1869#2:293\n1870#2:295\n1880#2:296\n1878#2,2:297\n1869#2,2:299\n1880#2:301\n1#3:294\n*S KotlinDebug\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/platform/workspace/storage/impl/AbstractStorageIndexes\n*L\n88#1:289,2\n90#1:291,2\n93#1:293\n93#1:295\n88#1:296\n109#1:297,2\n113#1:299,2\n109#1:301\n*E\n"})
public abstract class AbstractStorageIndexes {
    private AbstractStorageIndexes() {
    }

    @NotNull
    public abstract AbstractMultimapStorageIndex getSoftLinks$intellij_platform_workspace_storage();

    @NotNull
    public abstract VirtualFileIndex getVirtualFileIndex$intellij_platform_workspace_storage();

    @NotNull
    public abstract EntityStorageInternalIndex<EntitySource> getEntitySourceIndex$intellij_platform_workspace_storage();

    @NotNull
    public abstract SymbolicIdInternalIndex getSymbolicIdIndex$intellij_platform_workspace_storage();

    @NotNull
    public abstract Map<ExternalMappingKey<?>, AbstractExternalEntityMappingImpl<?>> getExternalMappings$intellij_platform_workspace_storage();

    public final void assertConsistency(@NotNull AbstractEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.assertEntitySourceIndex(storage);
        this.assertSymbolicIdIndex(storage);
        this.getVirtualFileIndex$intellij_platform_workspace_storage().assertConsistency$intellij_platform_workspace_storage();
        Iterator<Map.Entry<ExternalMappingKey<?>, AbstractExternalEntityMappingImpl<?>>> iterator = this.getExternalMappings$intellij_platform_workspace_storage().entrySet().iterator();
        while (iterator.hasNext()) {
            AbstractExternalEntityMappingImpl<?> mappings = iterator.next().getValue();
            mappings.getIndex$intellij_platform_workspace_storage().forEach((arg_0, arg_1) -> AbstractStorageIndexes.assertConsistency$lambda$0(storage, arg_0, arg_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertSymbolicIdIndex(AbstractEntityStorage storage) {
        boolean bl;
        int expectedSize = 0;
        Iterable $this$forEachIndexed$iv = storage.getEntitiesByType$intellij_platform_workspace_storage().getEntityFamilies$intellij_platform_workspace_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            WorkspaceEntityWithSymbolicId entityData;
            Object v0;
            void family;
            int i;
            block6: {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EntityFamily entityFamily = (EntityFamily)item$iv;
                i = n;
                boolean bl2 = false;
                if (family == null) continue;
                Iterable $this$firstOrNull$iv = family.getEntities$intellij_platform_workspace_storage();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    WorkspaceEntityData it = (WorkspaceEntityData)element$iv;
                    boolean bl3 = false;
                    if (!(it != null)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            WorkspaceEntityData workspaceEntityData = v0;
            Object var18_24 = workspaceEntityData != null ? workspaceEntityData.createEntity(storage) : null;
            WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId = entityData = var18_24 instanceof WorkspaceEntityWithSymbolicId ? (WorkspaceEntityWithSymbolicId)var18_24 : null;
            if ((workspaceEntityWithSymbolicId != null ? workspaceEntityWithSymbolicId.getSymbolicId() : null) == null) continue;
            long mutableId = 0L;
            mutableId = EntityIdKt.createEntityId(0, i);
            Iterable $this$forEach$iv = family.getEntities$intellij_platform_workspace_storage();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceEntityData data = (WorkspaceEntityData)element$iv;
                boolean bl4 = false;
                if (data == null) continue;
                mutableId = EntityIdKt.copy$default(mutableId, data.getId(), 0, 2, null);
                SymbolicEntityId<?> expectedSymbolicId = this.getSymbolicIdIndex$intellij_platform_workspace_storage().getEntryById$intellij_platform_workspace_storage(mutableId);
                Object e = data.createEntity(storage);
                WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId2 = e instanceof WorkspaceEntityWithSymbolicId ? (WorkspaceEntityWithSymbolicId)e : null;
                SymbolicEntityId<WorkspaceEntityWithSymbolicId> symbolicId = workspaceEntityWithSymbolicId2 != null ? workspaceEntityWithSymbolicId2.getSymbolicId() : null;
                boolean bl5 = Intrinsics.areEqual(expectedSymbolicId, symbolicId);
                if (_Assertions.ENABLED && !bl5) {
                    boolean bl6 = false;
                    String string = "Entity " + data + " isn't found in persistent id index. SymbolicId: " + symbolicId + ", Id: " + mutableId + ". Expected entity source: " + expectedSymbolicId;
                    throw new AssertionError((Object)string);
                }
                ++expectedSize;
            }
        }
        boolean bl7 = bl = expectedSize == this.getSymbolicIdIndex$intellij_platform_workspace_storage().getIndex$intellij_platform_workspace_storage().size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl8 = false;
            String string = "Incorrect size of symbolic id index. Expected: " + expectedSize + ", actual: " + this.getSymbolicIdIndex$intellij_platform_workspace_storage().getIndex$intellij_platform_workspace_storage().size();
            throw new AssertionError((Object)string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertEntitySourceIndex(AbstractEntityStorage storage) {
        boolean bl;
        int expectedSize = 0;
        Iterable $this$forEachIndexed$iv = storage.getEntitiesByType$intellij_platform_workspace_storage().getEntityFamilies$intellij_platform_workspace_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void family;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EntityFamily entityFamily = (EntityFamily)item$iv;
            int i = n;
            boolean bl2 = false;
            if (family == null) continue;
            long mutableId = 0L;
            mutableId = EntityIdKt.createEntityId(0, i);
            Iterable $this$forEach$iv = family.getEntities$intellij_platform_workspace_storage();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceEntityData data = (WorkspaceEntityData)element$iv;
                boolean bl3 = false;
                if (data == null) continue;
                mutableId = EntityIdKt.copy$default(mutableId, data.getId(), 0, 2, null);
                EntitySource expectedEntitySource = this.getEntitySourceIndex$intellij_platform_workspace_storage().getEntryById$intellij_platform_workspace_storage(mutableId);
                boolean bl4 = Intrinsics.areEqual((Object)expectedEntitySource, (Object)data.getEntitySource());
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl5 = false;
                    String string = "Entity " + data + " isn't found in entity source index. Entity source: " + data.getEntitySource() + ", Id: " + mutableId + ". Expected entity source: " + expectedEntitySource;
                    throw new AssertionError((Object)string);
                }
                ++expectedSize;
            }
        }
        boolean bl6 = bl = expectedSize == this.getEntitySourceIndex$intellij_platform_workspace_storage().getIndex$intellij_platform_workspace_storage().getSize();
        if (_Assertions.ENABLED && !bl) {
            boolean bl7 = false;
            String string = "Incorrect size of entity source index. Expected: " + expectedSize + ", actual: " + this.getEntitySourceIndex$intellij_platform_workspace_storage().getIndex$intellij_platform_workspace_storage().getSize();
            throw new AssertionError((Object)string);
        }
    }

    private static final Unit assertConsistency$lambda$0(AbstractEntityStorage $storage, long id, Object object) {
        boolean bl;
        boolean bl2 = bl = $storage.entityDataById$intellij_platform_workspace_storage(id) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Missing entity by id: " + id;
            throw new AssertionError((Object)string);
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ AbstractStorageIndexes(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

